package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstance;
import io.ciera.tool.sql.ooaofooa.instance.IntercomponentQueueEntry;
import io.ciera.tool.sql.ooaofooa.instance.IntercomponentQueueEntrySet;
import io.ciera.tool.sql.ooaofooa.instance.Stack;
import io.ciera.tool.sql.ooaofooa.instance.StackFrame;
import io.ciera.tool.sql.ooaofooa.instance.StackFrameSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.IntercomponentQueueEntrySetImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.StackFrameImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.StackFrameSetImpl;

import ooaofooa.datatypes.RunStateType;


public class StackImpl extends ModelInstance<Stack,Sql> implements Stack {

    public static final String KEY_LETTERS = "I_STACK";
    public static final Stack EMPTY_STACK = new EmptyStack();

    private Sql context;

    // constructors
    private StackImpl( Sql context ) {
        this.context = context;
        m_Stack_ID = UniqueId.random();
        ref_Execution_Engine_ID = UniqueId.random();
        m_runState = RunStateType.UNINITIALIZED_ENUM;
        m_suspendReason = "";
        R2929_has_a_top_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2930_is_controlled_by_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2943_executes_StackFrame_set = new StackFrameSetImpl();
        R2966_has_queued_IntercomponentQueueEntry_set = new IntercomponentQueueEntrySetImpl();
        R2967_has_return_values_on_StackFrame_set = new StackFrameSetImpl();
    }

    private StackImpl( Sql context, UniqueId instanceId, UniqueId m_Stack_ID, UniqueId ref_Execution_Engine_ID, RunStateType m_runState, String m_suspendReason ) {
        super(instanceId);
        this.context = context;
        this.m_Stack_ID = m_Stack_ID;
        this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
        this.m_runState = m_runState;
        this.m_suspendReason = m_suspendReason;
        R2929_has_a_top_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2930_is_controlled_by_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2943_executes_StackFrame_set = new StackFrameSetImpl();
        R2966_has_queued_IntercomponentQueueEntry_set = new IntercomponentQueueEntrySetImpl();
        R2967_has_return_values_on_StackFrame_set = new StackFrameSetImpl();
    }

    public static Stack create( Sql context ) throws XtumlException {
        Stack newStack = new StackImpl( context );
        if ( context.addInstance( newStack ) ) {
            newStack.getRunContext().addChange(new InstanceCreatedDelta(newStack, KEY_LETTERS));
            return newStack;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Stack create( Sql context, UniqueId instanceId, UniqueId m_Stack_ID, UniqueId ref_Execution_Engine_ID, RunStateType m_runState, String m_suspendReason ) throws XtumlException {
        Stack newStack = new StackImpl( context, instanceId, m_Stack_ID, ref_Execution_Engine_ID, m_runState, m_suspendReason );
        if ( context.addInstance( newStack ) ) {
            return newStack;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Stack_ID;
    @Override
    public void setStack_ID( UniqueId m_Stack_ID ) throws XtumlException {
        checkLiving();
        if ( m_Stack_ID.inequality( this.m_Stack_ID ) ) {
            final UniqueId oldValue = this.m_Stack_ID;
            this.m_Stack_ID = m_Stack_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Stack_ID", oldValue, this.m_Stack_ID));
            if ( !R2929_has_a_top_StackFrame().isEmpty() ) R2929_has_a_top_StackFrame().setTop_Stack_Frame_Stack_ID( m_Stack_ID );
            if ( !R2967_has_return_values_on_StackFrame().isEmpty() ) R2967_has_return_values_on_StackFrame().setValue_Q_Stack_ID( m_Stack_ID );
            if ( !R2943_executes_StackFrame().isEmpty() ) R2943_executes_StackFrame().setStack_ID( m_Stack_ID );
            if ( !R2966_has_queued_IntercomponentQueueEntry().isEmpty() ) R2966_has_queued_IntercomponentQueueEntry().setStack_ID( m_Stack_ID );
        }
    }
    @Override
    public UniqueId getStack_ID() throws XtumlException {
        checkLiving();
                return m_Stack_ID;
    }
    private UniqueId ref_Execution_Engine_ID;
    @Override
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Execution_Engine_ID.inequality( this.ref_Execution_Engine_ID ) ) {
            final UniqueId oldValue = this.ref_Execution_Engine_ID;
            this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Execution_Engine_ID", oldValue, this.ref_Execution_Engine_ID));
        }
    }
    @Override
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        checkLiving();
                return ref_Execution_Engine_ID;
    }
    private RunStateType m_runState;
    @Override
    public void setRunState( RunStateType m_runState ) throws XtumlException {
        checkLiving();
        if ( m_runState.inequality( this.m_runState ) ) {
            final RunStateType oldValue = this.m_runState;
            this.m_runState = m_runState;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_runState", oldValue, this.m_runState));
        }
    }
    @Override
    public RunStateType getRunState() throws XtumlException {
        checkLiving();
                return m_runState;
    }
    private String m_suspendReason;
    @Override
    public void setSuspendReason( String m_suspendReason ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_suspendReason, this.m_suspendReason ) ) {
            final String oldValue = this.m_suspendReason;
            this.m_suspendReason = m_suspendReason;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_suspendReason", oldValue, this.m_suspendReason));
        }
    }
    @Override
    public String getSuspendReason() throws XtumlException {
        checkLiving();
                return m_suspendReason;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStack_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StackFrame R2929_has_a_top_StackFrame_inst;
    @Override
    public void setR2929_has_a_top_StackFrame( StackFrame inst ) {
        R2929_has_a_top_StackFrame_inst = inst;
    }
    @Override
    public StackFrame R2929_has_a_top_StackFrame() throws XtumlException {
        return R2929_has_a_top_StackFrame_inst;
    }
    private ComponentInstance R2930_is_controlled_by_ComponentInstance_inst;
    @Override
    public void setR2930_is_controlled_by_ComponentInstance( ComponentInstance inst ) {
        R2930_is_controlled_by_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2930_is_controlled_by_ComponentInstance() throws XtumlException {
        return R2930_is_controlled_by_ComponentInstance_inst;
    }
    private StackFrameSet R2943_executes_StackFrame_set;
    @Override
    public void addR2943_executes_StackFrame( StackFrame inst ) {
        R2943_executes_StackFrame_set.add(inst);
    }
    @Override
    public void removeR2943_executes_StackFrame( StackFrame inst ) {
        R2943_executes_StackFrame_set.remove(inst);
    }
    @Override
    public StackFrameSet R2943_executes_StackFrame() throws XtumlException {
        return R2943_executes_StackFrame_set;
    }
    private IntercomponentQueueEntrySet R2966_has_queued_IntercomponentQueueEntry_set;
    @Override
    public void addR2966_has_queued_IntercomponentQueueEntry( IntercomponentQueueEntry inst ) {
        R2966_has_queued_IntercomponentQueueEntry_set.add(inst);
    }
    @Override
    public void removeR2966_has_queued_IntercomponentQueueEntry( IntercomponentQueueEntry inst ) {
        R2966_has_queued_IntercomponentQueueEntry_set.remove(inst);
    }
    @Override
    public IntercomponentQueueEntrySet R2966_has_queued_IntercomponentQueueEntry() throws XtumlException {
        return R2966_has_queued_IntercomponentQueueEntry_set;
    }
    private StackFrameSet R2967_has_return_values_on_StackFrame_set;
    @Override
    public void addR2967_has_return_values_on_StackFrame( StackFrame inst ) {
        R2967_has_return_values_on_StackFrame_set.add(inst);
    }
    @Override
    public void removeR2967_has_return_values_on_StackFrame( StackFrame inst ) {
        R2967_has_return_values_on_StackFrame_set.remove(inst);
    }
    @Override
    public StackFrameSet R2967_has_return_values_on_StackFrame() throws XtumlException {
        return R2967_has_return_values_on_StackFrame_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Stack value() {
        return this;
    }

    @Override
    public Stack self() {
        return this;
    }

    @Override
    public Stack oneWhere( IWhere<Stack> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_STACK;
    }

}

class EmptyStack extends ModelInstance<Stack,Sql> implements Stack {

    // attributes
    public void setStack_ID( UniqueId m_Stack_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStack_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRunState( RunStateType m_runState ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public RunStateType getRunState() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSuspendReason( String m_suspendReason ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSuspendReason() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StackFrame R2929_has_a_top_StackFrame() {
        return StackFrameImpl.EMPTY_STACKFRAME;
    }
    @Override
    public ComponentInstance R2930_is_controlled_by_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }
    @Override
    public StackFrameSet R2943_executes_StackFrame() {
        return (new StackFrameSetImpl());
    }
    @Override
    public IntercomponentQueueEntrySet R2966_has_queued_IntercomponentQueueEntry() {
        return (new IntercomponentQueueEntrySetImpl());
    }
    @Override
    public StackFrameSet R2967_has_return_values_on_StackFrame() {
        return (new StackFrameSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return StackImpl.KEY_LETTERS;
    }

    @Override
    public Stack value() {
        return this;
    }
    
    @Override
    public Stack self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Stack oneWhere( IWhere<Stack> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return StackImpl.EMPTY_STACK;
    }

}
