package io.ciera.tool.sql.ooaofooa.elementpackaging.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKG;
import io.ciera.tool.sql.ooaofooa.elementpackaging.PackageReference;
import io.ciera.tool.sql.ooaofooa.elementpackaging.impl.EP_PKGImpl;


public class PackageReferenceImpl extends ModelInstance<PackageReference,Sql> implements PackageReference {

    public static final String KEY_LETTERS = "EP_PKGREF";
    public static final PackageReference EMPTY_PACKAGEREFERENCE = new EmptyPackageReference();

    private Sql context;

    // constructors
    private PackageReferenceImpl( Sql context ) {
        this.context = context;
        ref_Referring_Package_ID = UniqueId.random();
        ref_Referred_Package_ID = UniqueId.random();
        R1402_is_referenced_by_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
        R1402_refers_to_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
    }

    private PackageReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Referring_Package_ID, UniqueId ref_Referred_Package_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Referring_Package_ID = ref_Referring_Package_ID;
        this.ref_Referred_Package_ID = ref_Referred_Package_ID;
        R1402_is_referenced_by_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
        R1402_refers_to_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
    }

    public static PackageReference create( Sql context ) throws XtumlException {
        PackageReference newPackageReference = new PackageReferenceImpl( context );
        if ( context.addInstance( newPackageReference ) ) {
            newPackageReference.getRunContext().addChange(new InstanceCreatedDelta(newPackageReference, KEY_LETTERS));
            return newPackageReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PackageReference create( Sql context, UniqueId instanceId, UniqueId ref_Referring_Package_ID, UniqueId ref_Referred_Package_ID ) throws XtumlException {
        PackageReference newPackageReference = new PackageReferenceImpl( context, instanceId, ref_Referring_Package_ID, ref_Referred_Package_ID );
        if ( context.addInstance( newPackageReference ) ) {
            return newPackageReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Referring_Package_ID;
    @Override
    public UniqueId getReferring_Package_ID() throws XtumlException {
        checkLiving();
                return ref_Referring_Package_ID;
    }
    @Override
    public void setReferring_Package_ID( UniqueId ref_Referring_Package_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Referring_Package_ID.inequality( this.ref_Referring_Package_ID ) ) {
            final UniqueId oldValue = this.ref_Referring_Package_ID;
            this.ref_Referring_Package_ID = ref_Referring_Package_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Referring_Package_ID", oldValue, this.ref_Referring_Package_ID));
        }
    }
    private UniqueId ref_Referred_Package_ID;
    @Override
    public void setReferred_Package_ID( UniqueId ref_Referred_Package_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Referred_Package_ID.inequality( this.ref_Referred_Package_ID ) ) {
            final UniqueId oldValue = this.ref_Referred_Package_ID;
            this.ref_Referred_Package_ID = ref_Referred_Package_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Referred_Package_ID", oldValue, this.ref_Referred_Package_ID));
        }
    }
    @Override
    public UniqueId getReferred_Package_ID() throws XtumlException {
        checkLiving();
                return ref_Referred_Package_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getReferring_Package_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EP_PKG R1402_is_referenced_by_EP_PKG_inst;
    @Override
    public void setR1402_is_referenced_by_EP_PKG( EP_PKG inst ) {
        R1402_is_referenced_by_EP_PKG_inst = inst;
    }
    @Override
    public EP_PKG R1402_is_referenced_by_EP_PKG() throws XtumlException {
        return R1402_is_referenced_by_EP_PKG_inst;
    }
    private EP_PKG R1402_refers_to_EP_PKG_inst;
    @Override
    public void setR1402_refers_to_EP_PKG( EP_PKG inst ) {
        R1402_refers_to_EP_PKG_inst = inst;
    }
    @Override
    public EP_PKG R1402_refers_to_EP_PKG() throws XtumlException {
        return R1402_refers_to_EP_PKG_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PackageReference value() {
        return this;
    }

    @Override
    public PackageReference self() {
        return this;
    }

    @Override
    public PackageReference oneWhere( IWhere<PackageReference> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_PACKAGEREFERENCE;
    }

}

class EmptyPackageReference extends ModelInstance<PackageReference,Sql> implements PackageReference {

    // attributes
    public UniqueId getReferring_Package_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferring_Package_ID( UniqueId ref_Referring_Package_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setReferred_Package_ID( UniqueId ref_Referred_Package_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getReferred_Package_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EP_PKG R1402_is_referenced_by_EP_PKG() {
        return EP_PKGImpl.EMPTY_EP_PKG;
    }
    @Override
    public EP_PKG R1402_refers_to_EP_PKG() {
        return EP_PKGImpl.EMPTY_EP_PKG;
    }


    @Override
    public String getKeyLetters() {
        return PackageReferenceImpl.KEY_LETTERS;
    }

    @Override
    public PackageReference value() {
        return this;
    }
    
    @Override
    public PackageReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PackageReference oneWhere( IWhere<PackageReference> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return PackageReferenceImpl.EMPTY_PACKAGEREFERENCE;
    }

}
