package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.Exception;
import io.ciera.tool.sql.ooaofooa.domain.ExceptionSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElementSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ExceptionSetImpl extends InstanceSet<ExceptionSet,Exception> implements ExceptionSet {

    public ExceptionSetImpl() {
    }

    public ExceptionSetImpl(Comparator<? super Exception> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Exception exception : this ) exception.setName( m_Name );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( Exception exception : this ) exception.setDescrip( m_Descrip );
    }
    @Override
    public void setException_ID( UniqueId ref_Exception_ID ) throws XtumlException {
        for ( Exception exception : this ) exception.setException_ID( ref_Exception_ID );
    }


    // selections
    @Override
    public PackageableElementSet R8001_is_a_PackageableElement() throws XtumlException {
        PackageableElementSet packageableelementset = new PackageableElementSetImpl();
        for ( Exception exception : this ) packageableelementset.add( exception.R8001_is_a_PackageableElement() );
        return packageableelementset;
    }


    @Override
    public Exception nullElement() {
        return ExceptionImpl.EMPTY_EXCEPTION;
    }

    @Override
    public ExceptionSet emptySet() {
      return new ExceptionSetImpl();
    }

    @Override
    public ExceptionSet emptySet(Comparator<? super Exception> comp) {
      return new ExceptionSetImpl(comp);
    }

    @Override
    public ExceptionSet value() {
        return this;
    }

    @Override
    public List<Exception> elements() {
        Exception[] elements = toArray(new Exception[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
