package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.domain.CoreDataType;
import io.ciera.tool.sql.ooaofooa.domain.CoreDataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.DataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class CoreDataTypeSetImpl extends InstanceSet<CoreDataTypeSet,CoreDataType> implements CoreDataTypeSet {

    public CoreDataTypeSetImpl() {
    }

    public CoreDataTypeSetImpl(Comparator<? super CoreDataType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        for ( CoreDataType coredatatype : this ) coredatatype.setDT_ID( ref_DT_ID );
    }
    @Override
    public void setCore_Typ( int m_Core_Typ ) throws XtumlException {
        for ( CoreDataType coredatatype : this ) coredatatype.setCore_Typ( m_Core_Typ );
    }


    // selections
    @Override
    public DataTypeSet R17_is_a_DataType() throws XtumlException {
        DataTypeSet datatypeset = new DataTypeSetImpl();
        for ( CoreDataType coredatatype : this ) datatypeset.add( coredatatype.R17_is_a_DataType() );
        return datatypeset;
    }


    @Override
    public CoreDataType nullElement() {
        return CoreDataTypeImpl.EMPTY_COREDATATYPE;
    }

    @Override
    public CoreDataTypeSet emptySet() {
      return new CoreDataTypeSetImpl();
    }

    @Override
    public CoreDataTypeSet emptySet(Comparator<? super CoreDataType> comp) {
      return new CoreDataTypeSetImpl(comp);
    }

    @Override
    public CoreDataTypeSet value() {
        return this;
    }

    @Override
    public List<CoreDataType> elements() {
        return Arrays.asList(toArray(new CoreDataType[0]));
    }

}
