package io.ciera.tool.sql.ooaofooa.deployment.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.deployment.Deployment;
import io.ciera.tool.sql.ooaofooa.deployment.Terminator;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorService;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceSet;
import io.ciera.tool.sql.ooaofooa.deployment.impl.DeploymentImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceSetImpl;


public class TerminatorImpl extends ModelInstance<Terminator,Sql> implements Terminator {

    public static final String KEY_LETTERS = "D_TERM";
    public static final Terminator EMPTY_TERMINATOR = new EmptyTerminator();

    private Sql context;

    // constructors
    private TerminatorImpl( Sql context ) {
        this.context = context;
        m_Term_ID = UniqueId.random();
        ref_Deployment_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Domain_Name = "";
        m_Terminator_Name = "";
        m_Provider = false;
        R1650_Deployment_inst = DeploymentImpl.EMPTY_DEPLOYMENT;
        R1651_TerminatorService_set = new TerminatorServiceSetImpl();
    }

    private TerminatorImpl( Sql context, UniqueId instanceId, UniqueId m_Term_ID, UniqueId ref_Deployment_ID, String m_Name, String m_Descrip, String m_Domain_Name, String m_Terminator_Name, boolean m_Provider ) {
        super(instanceId);
        this.context = context;
        this.m_Term_ID = m_Term_ID;
        this.ref_Deployment_ID = ref_Deployment_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Domain_Name = m_Domain_Name;
        this.m_Terminator_Name = m_Terminator_Name;
        this.m_Provider = m_Provider;
        R1650_Deployment_inst = DeploymentImpl.EMPTY_DEPLOYMENT;
        R1651_TerminatorService_set = new TerminatorServiceSetImpl();
    }

    public static Terminator create( Sql context ) throws XtumlException {
        Terminator newTerminator = new TerminatorImpl( context );
        if ( context.addInstance( newTerminator ) ) {
            newTerminator.getRunContext().addChange(new InstanceCreatedDelta(newTerminator, KEY_LETTERS));
            return newTerminator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Terminator create( Sql context, UniqueId instanceId, UniqueId m_Term_ID, UniqueId ref_Deployment_ID, String m_Name, String m_Descrip, String m_Domain_Name, String m_Terminator_Name, boolean m_Provider ) throws XtumlException {
        Terminator newTerminator = new TerminatorImpl( context, instanceId, m_Term_ID, ref_Deployment_ID, m_Name, m_Descrip, m_Domain_Name, m_Terminator_Name, m_Provider );
        if ( context.addInstance( newTerminator ) ) {
            return newTerminator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Term_ID;
    @Override
    public void setTerm_ID( UniqueId m_Term_ID ) throws XtumlException {
        checkLiving();
        if ( m_Term_ID.inequality( this.m_Term_ID ) ) {
            final UniqueId oldValue = this.m_Term_ID;
            this.m_Term_ID = m_Term_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Term_ID", oldValue, this.m_Term_ID));
            if ( !R1651_TerminatorService().isEmpty() ) R1651_TerminatorService().setTerm_ID( m_Term_ID );
        }
    }
    @Override
    public UniqueId getTerm_ID() throws XtumlException {
        checkLiving();
                return m_Term_ID;
    }
    private UniqueId ref_Deployment_ID;
    @Override
    public UniqueId getDeployment_ID() throws XtumlException {
        checkLiving();
                return ref_Deployment_ID;
    }
    @Override
    public void setDeployment_ID( UniqueId ref_Deployment_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Deployment_ID.inequality( this.ref_Deployment_ID ) ) {
            final UniqueId oldValue = this.ref_Deployment_ID;
            this.ref_Deployment_ID = ref_Deployment_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Deployment_ID", oldValue, this.ref_Deployment_ID));
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_Domain_Name;
    @Override
    public void setDomain_Name( String m_Domain_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Domain_Name, this.m_Domain_Name ) ) {
            final String oldValue = this.m_Domain_Name;
            this.m_Domain_Name = m_Domain_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Domain_Name", oldValue, this.m_Domain_Name));
        }
    }
    @Override
    public String getDomain_Name() throws XtumlException {
        checkLiving();
                return m_Domain_Name;
    }
    private String m_Terminator_Name;
    @Override
    public void setTerminator_Name( String m_Terminator_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Terminator_Name, this.m_Terminator_Name ) ) {
            final String oldValue = this.m_Terminator_Name;
            this.m_Terminator_Name = m_Terminator_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Terminator_Name", oldValue, this.m_Terminator_Name));
        }
    }
    @Override
    public String getTerminator_Name() throws XtumlException {
        checkLiving();
                return m_Terminator_Name;
    }
    private boolean m_Provider;
    @Override
    public boolean getProvider() throws XtumlException {
        checkLiving();
                return m_Provider;
    }
    @Override
    public void setProvider( boolean m_Provider ) throws XtumlException {
        checkLiving();
        if ( m_Provider != this.m_Provider ) {
            final boolean oldValue = this.m_Provider;
            this.m_Provider = m_Provider;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Provider", oldValue, this.m_Provider));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getTerm_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Deployment R1650_Deployment_inst;
    @Override
    public void setR1650_Deployment( Deployment inst ) {
        R1650_Deployment_inst = inst;
    }
    @Override
    public Deployment R1650_Deployment() throws XtumlException {
        return R1650_Deployment_inst;
    }
    private TerminatorServiceSet R1651_TerminatorService_set;
    @Override
    public void addR1651_TerminatorService( TerminatorService inst ) {
        R1651_TerminatorService_set.add(inst);
    }
    @Override
    public void removeR1651_TerminatorService( TerminatorService inst ) {
        R1651_TerminatorService_set.remove(inst);
    }
    @Override
    public TerminatorServiceSet R1651_TerminatorService() throws XtumlException {
        return R1651_TerminatorService_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Terminator value() {
        return this;
    }

    @Override
    public Terminator self() {
        return this;
    }

    @Override
    public Terminator oneWhere( IWhere<Terminator> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_TERMINATOR;
    }

}

class EmptyTerminator extends ModelInstance<Terminator,Sql> implements Terminator {

    // attributes
    public void setTerm_ID( UniqueId m_Term_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTerm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDeployment_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDeployment_ID( UniqueId ref_Deployment_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDomain_Name( String m_Domain_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDomain_Name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTerminator_Name( String m_Terminator_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getTerminator_Name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getProvider() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setProvider( boolean m_Provider ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Deployment R1650_Deployment() {
        return DeploymentImpl.EMPTY_DEPLOYMENT;
    }
    @Override
    public TerminatorServiceSet R1651_TerminatorService() {
        return (new TerminatorServiceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TerminatorImpl.KEY_LETTERS;
    }

    @Override
    public Terminator value() {
        return this;
    }
    
    @Override
    public Terminator self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Terminator oneWhere( IWhere<Terminator> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return TerminatorImpl.EMPTY_TERMINATOR;
    }

}
