package io.ciera.tool.sql.ooaofooa.constants.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.constants.LeafSymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.LiteralSymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.impl.LeafSymbolicConstantImpl;


public class LiteralSymbolicConstantImpl extends ModelInstance<LiteralSymbolicConstant,Sql> implements LiteralSymbolicConstant {

    public static final String KEY_LETTERS = "CNST_LSC";
    public static final LiteralSymbolicConstant EMPTY_LITERALSYMBOLICCONSTANT = new EmptyLiteralSymbolicConstant();

    private Sql context;

    // constructors
    private LiteralSymbolicConstantImpl( Sql context ) {
        this.context = context;
        ref_Const_ID = UniqueId.random();
        m_DT_ID_Deprecated = UniqueId.random();
        m_Value = "";
        R1503_is_a_LeafSymbolicConstant_inst = LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
    }

    private LiteralSymbolicConstantImpl( Sql context, UniqueId instanceId, UniqueId ref_Const_ID, UniqueId m_DT_ID_Deprecated, String m_Value ) {
        super(instanceId);
        this.context = context;
        this.ref_Const_ID = ref_Const_ID;
        this.m_DT_ID_Deprecated = m_DT_ID_Deprecated;
        this.m_Value = m_Value;
        R1503_is_a_LeafSymbolicConstant_inst = LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
    }

    public static LiteralSymbolicConstant create( Sql context ) throws XtumlException {
        LiteralSymbolicConstant newLiteralSymbolicConstant = new LiteralSymbolicConstantImpl( context );
        if ( context.addInstance( newLiteralSymbolicConstant ) ) {
            newLiteralSymbolicConstant.getRunContext().addChange(new InstanceCreatedDelta(newLiteralSymbolicConstant, KEY_LETTERS));
            return newLiteralSymbolicConstant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LiteralSymbolicConstant create( Sql context, UniqueId instanceId, UniqueId ref_Const_ID, UniqueId m_DT_ID_Deprecated, String m_Value ) throws XtumlException {
        LiteralSymbolicConstant newLiteralSymbolicConstant = new LiteralSymbolicConstantImpl( context, instanceId, ref_Const_ID, m_DT_ID_Deprecated, m_Value );
        if ( context.addInstance( newLiteralSymbolicConstant ) ) {
            return newLiteralSymbolicConstant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Const_ID;
    @Override
    public void setConst_ID( UniqueId ref_Const_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Const_ID.inequality( this.ref_Const_ID ) ) {
            final UniqueId oldValue = this.ref_Const_ID;
            this.ref_Const_ID = ref_Const_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Const_ID", oldValue, this.ref_Const_ID));
        }
    }
    @Override
    public UniqueId getConst_ID() throws XtumlException {
        checkLiving();
                return ref_Const_ID;
    }
    private UniqueId m_DT_ID_Deprecated;
    @Override
    public UniqueId getDT_ID_Deprecated() throws XtumlException {
        checkLiving();
                return m_DT_ID_Deprecated;
    }
    @Override
    public void setDT_ID_Deprecated( UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        checkLiving();
        if ( m_DT_ID_Deprecated.inequality( this.m_DT_ID_Deprecated ) ) {
            final UniqueId oldValue = this.m_DT_ID_Deprecated;
            this.m_DT_ID_Deprecated = m_DT_ID_Deprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DT_ID_Deprecated", oldValue, this.m_DT_ID_Deprecated));
        }
    }
    private String m_Value;
    @Override
    public void setValue( String m_Value ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Value, this.m_Value ) ) {
            final String oldValue = this.m_Value;
            this.m_Value = m_Value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Value", oldValue, this.m_Value));
        }
    }
    @Override
    public String getValue() throws XtumlException {
        checkLiving();
                return m_Value;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getConst_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private LeafSymbolicConstant R1503_is_a_LeafSymbolicConstant_inst;
    @Override
    public void setR1503_is_a_LeafSymbolicConstant( LeafSymbolicConstant inst ) {
        R1503_is_a_LeafSymbolicConstant_inst = inst;
    }
    @Override
    public LeafSymbolicConstant R1503_is_a_LeafSymbolicConstant() throws XtumlException {
        return R1503_is_a_LeafSymbolicConstant_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LiteralSymbolicConstant value() {
        return this;
    }

    @Override
    public LiteralSymbolicConstant self() {
        return this;
    }

    @Override
    public LiteralSymbolicConstant oneWhere( IWhere<LiteralSymbolicConstant> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_LITERALSYMBOLICCONSTANT;
    }

}

class EmptyLiteralSymbolicConstant extends ModelInstance<LiteralSymbolicConstant,Sql> implements LiteralSymbolicConstant {

    // attributes
    public void setConst_ID( UniqueId ref_Const_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getConst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getDT_ID_Deprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID_Deprecated( UniqueId m_DT_ID_Deprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setValue( String m_Value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public LeafSymbolicConstant R1503_is_a_LeafSymbolicConstant() {
        return LeafSymbolicConstantImpl.EMPTY_LEAFSYMBOLICCONSTANT;
    }


    @Override
    public String getKeyLetters() {
        return LiteralSymbolicConstantImpl.KEY_LETTERS;
    }

    @Override
    public LiteralSymbolicConstant value() {
        return this;
    }
    
    @Override
    public LiteralSymbolicConstant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LiteralSymbolicConstant oneWhere( IWhere<LiteralSymbolicConstant> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return LiteralSymbolicConstantImpl.EMPTY_LITERALSYMBOLICCONSTANT;
    }

}
