package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.DelegationSet;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceInDelegationSet;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceInDelegationSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.RuntimeChannelSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.RuntimeChannelSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElementSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementSetImpl;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.DelegationInComponentSet;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.impl.DelegationInComponentSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class DelegationSetImpl extends InstanceSet<DelegationSet,Delegation> implements DelegationSet {

    public DelegationSetImpl() {
    }

    public DelegationSetImpl(Comparator<? super Delegation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        for ( Delegation delegation : this ) delegation.setId( ref_Id );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Delegation delegation : this ) delegation.setName( m_Name );
    }


    // selections
    @Override
    public RuntimeChannelSet R2972_is_implemented_at_runtime_by_RuntimeChannel() throws XtumlException {
        RuntimeChannelSet runtimechannelset = new RuntimeChannelSetImpl();
        for ( Delegation delegation : this ) runtimechannelset.addAll( delegation.R2972_is_implemented_at_runtime_by_RuntimeChannel() );
        return runtimechannelset;
    }
    @Override
    public InterfaceReferenceInDelegationSet R4013_handles_delegation_for_InterfaceReferenceInDelegation() throws XtumlException {
        InterfaceReferenceInDelegationSet interfacereferenceindelegationset = new InterfaceReferenceInDelegationSetImpl();
        for ( Delegation delegation : this ) interfacereferenceindelegationset.addAll( delegation.R4013_handles_delegation_for_InterfaceReferenceInDelegation() );
        return interfacereferenceindelegationset;
    }
    @Override
    public InterfaceReferenceSet R4014_provides_delegation_to_InterfaceReference() throws XtumlException {
        InterfaceReferenceSet interfacereferenceset = new InterfaceReferenceSetImpl();
        for ( Delegation delegation : this ) interfacereferenceset.addAll( delegation.R4014_provides_delegation_to_InterfaceReference() );
        return interfacereferenceset;
    }
    @Override
    public ImportedReferenceSet R4704_delivers_communication_through_ImportedReference() throws XtumlException {
        ImportedReferenceSet importedreferenceset = new ImportedReferenceSetImpl();
        for ( Delegation delegation : this ) importedreferenceset.add( delegation.R4704_delivers_communication_through_ImportedReference() );
        return importedreferenceset;
    }
    @Override
    public PackageableElementSet R8001_is_a_PackageableElement() throws XtumlException {
        PackageableElementSet packageableelementset = new PackageableElementSetImpl();
        for ( Delegation delegation : this ) packageableelementset.add( delegation.R8001_is_a_PackageableElement() );
        return packageableelementset;
    }
    @Override
    public DelegationInComponentSet R9002_DelegationInComponent() throws XtumlException {
        DelegationInComponentSet delegationincomponentset = new DelegationInComponentSetImpl();
        for ( Delegation delegation : this ) delegationincomponentset.add( delegation.R9002_DelegationInComponent() );
        return delegationincomponentset;
    }


    @Override
    public Delegation nullElement() {
        return DelegationImpl.EMPTY_DELEGATION;
    }

    @Override
    public DelegationSet emptySet() {
      return new DelegationSetImpl();
    }

    @Override
    public DelegationSet emptySet(Comparator<? super Delegation> comp) {
      return new DelegationSetImpl(comp);
    }

    @Override
    public DelegationSet value() {
        return this;
    }

    @Override
    public List<Delegation> elements() {
        Delegation[] elements = toArray(new Delegation[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
