package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Delegation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReference;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceInDelegation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceInDelegationSet;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedReference;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedReferenceImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceInDelegationSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.RuntimeChannel;
import io.ciera.tool.sql.ooaofooa.instance.RuntimeChannelSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.RuntimeChannelSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.DelegationInComponent;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.impl.DelegationInComponentImpl;


public class DelegationImpl extends ModelInstance<Delegation,Sql> implements Delegation {

    public static final String KEY_LETTERS = "C_DG";
    public static final Delegation EMPTY_DELEGATION = new EmptyDelegation();

    private Sql context;

    // constructors
    private DelegationImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        m_Name = "";
        R2972_is_implemented_at_runtime_by_RuntimeChannel_set = new RuntimeChannelSetImpl();
        R4013_handles_delegation_for_InterfaceReferenceInDelegation_set = new InterfaceReferenceInDelegationSetImpl();
        R4014_provides_delegation_to_InterfaceReference_set = new InterfaceReferenceSetImpl();
        R4704_delivers_communication_through_ImportedReference_inst = ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R9002_DelegationInComponent_inst = DelegationInComponentImpl.EMPTY_DELEGATIONINCOMPONENT;
    }

    private DelegationImpl( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        this.m_Name = m_Name;
        R2972_is_implemented_at_runtime_by_RuntimeChannel_set = new RuntimeChannelSetImpl();
        R4013_handles_delegation_for_InterfaceReferenceInDelegation_set = new InterfaceReferenceInDelegationSetImpl();
        R4014_provides_delegation_to_InterfaceReference_set = new InterfaceReferenceSetImpl();
        R4704_delivers_communication_through_ImportedReference_inst = ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R9002_DelegationInComponent_inst = DelegationInComponentImpl.EMPTY_DELEGATIONINCOMPONENT;
    }

    public static Delegation create( Sql context ) throws XtumlException {
        Delegation newDelegation = new DelegationImpl( context );
        if ( context.addInstance( newDelegation ) ) {
            newDelegation.getRunContext().addChange(new InstanceCreatedDelta(newDelegation, KEY_LETTERS));
            return newDelegation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Delegation create( Sql context, UniqueId instanceId, UniqueId ref_Id, String m_Name ) throws XtumlException {
        Delegation newDelegation = new DelegationImpl( context, instanceId, ref_Id, m_Name );
        if ( context.addInstance( newDelegation ) ) {
            return newDelegation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R4014_provides_delegation_to_InterfaceReference().isEmpty() ) R4014_provides_delegation_to_InterfaceReference().setDelegation_Id( ref_Id );
            if ( !R9002_DelegationInComponent().isEmpty() ) R9002_DelegationInComponent().setDelegation_Id( ref_Id );
            if ( !R4704_delivers_communication_through_ImportedReference().isEmpty() ) R4704_delivers_communication_through_ImportedReference().setDelegation_Id( ref_Id );
            if ( !R4013_handles_delegation_for_InterfaceReferenceInDelegation().isEmpty() ) R4013_handles_delegation_for_InterfaceReferenceInDelegation().setDelegation_Id( ref_Id );
            if ( !R2972_is_implemented_at_runtime_by_RuntimeChannel().isEmpty() ) R2972_is_implemented_at_runtime_by_RuntimeChannel().setDelegation_Id( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private RuntimeChannelSet R2972_is_implemented_at_runtime_by_RuntimeChannel_set;
    @Override
    public void addR2972_is_implemented_at_runtime_by_RuntimeChannel( RuntimeChannel inst ) {
        R2972_is_implemented_at_runtime_by_RuntimeChannel_set.add(inst);
    }
    @Override
    public void removeR2972_is_implemented_at_runtime_by_RuntimeChannel( RuntimeChannel inst ) {
        R2972_is_implemented_at_runtime_by_RuntimeChannel_set.remove(inst);
    }
    @Override
    public RuntimeChannelSet R2972_is_implemented_at_runtime_by_RuntimeChannel() throws XtumlException {
        return R2972_is_implemented_at_runtime_by_RuntimeChannel_set;
    }
    private InterfaceReferenceInDelegationSet R4013_handles_delegation_for_InterfaceReferenceInDelegation_set;
    @Override
    public void addR4013_handles_delegation_for_InterfaceReferenceInDelegation( InterfaceReferenceInDelegation inst ) {
        R4013_handles_delegation_for_InterfaceReferenceInDelegation_set.add(inst);
    }
    @Override
    public void removeR4013_handles_delegation_for_InterfaceReferenceInDelegation( InterfaceReferenceInDelegation inst ) {
        R4013_handles_delegation_for_InterfaceReferenceInDelegation_set.remove(inst);
    }
    @Override
    public InterfaceReferenceInDelegationSet R4013_handles_delegation_for_InterfaceReferenceInDelegation() throws XtumlException {
        return R4013_handles_delegation_for_InterfaceReferenceInDelegation_set;
    }
    private InterfaceReferenceSet R4014_provides_delegation_to_InterfaceReference_set;
    @Override
    public void addR4014_provides_delegation_to_InterfaceReference( InterfaceReference inst ) {
        R4014_provides_delegation_to_InterfaceReference_set.add(inst);
    }
    @Override
    public void removeR4014_provides_delegation_to_InterfaceReference( InterfaceReference inst ) {
        R4014_provides_delegation_to_InterfaceReference_set.remove(inst);
    }
    @Override
    public InterfaceReferenceSet R4014_provides_delegation_to_InterfaceReference() throws XtumlException {
        return R4014_provides_delegation_to_InterfaceReference_set;
    }
    private ImportedReference R4704_delivers_communication_through_ImportedReference_inst;
    @Override
    public void setR4704_delivers_communication_through_ImportedReference( ImportedReference inst ) {
        R4704_delivers_communication_through_ImportedReference_inst = inst;
    }
    @Override
    public ImportedReference R4704_delivers_communication_through_ImportedReference() throws XtumlException {
        return R4704_delivers_communication_through_ImportedReference_inst;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }
    private DelegationInComponent R9002_DelegationInComponent_inst;
    @Override
    public void setR9002_DelegationInComponent( DelegationInComponent inst ) {
        R9002_DelegationInComponent_inst = inst;
    }
    @Override
    public DelegationInComponent R9002_DelegationInComponent() throws XtumlException {
        return R9002_DelegationInComponent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Delegation value() {
        return this;
    }

    @Override
    public Delegation self() {
        return this;
    }

    @Override
    public Delegation oneWhere( IWhere<Delegation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_DELEGATION;
    }

}

class EmptyDelegation extends ModelInstance<Delegation,Sql> implements Delegation {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public RuntimeChannelSet R2972_is_implemented_at_runtime_by_RuntimeChannel() {
        return (new RuntimeChannelSetImpl());
    }
    @Override
    public InterfaceReferenceInDelegationSet R4013_handles_delegation_for_InterfaceReferenceInDelegation() {
        return (new InterfaceReferenceInDelegationSetImpl());
    }
    @Override
    public InterfaceReferenceSet R4014_provides_delegation_to_InterfaceReference() {
        return (new InterfaceReferenceSetImpl());
    }
    @Override
    public ImportedReference R4704_delivers_communication_through_ImportedReference() {
        return ImportedReferenceImpl.EMPTY_IMPORTEDREFERENCE;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public DelegationInComponent R9002_DelegationInComponent() {
        return DelegationInComponentImpl.EMPTY_DELEGATIONINCOMPONENT;
    }


    @Override
    public String getKeyLetters() {
        return DelegationImpl.KEY_LETTERS;
    }

    @Override
    public Delegation value() {
        return this;
    }
    
    @Override
    public Delegation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Delegation oneWhere( IWhere<Delegation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return DelegationImpl.EMPTY_DELEGATION;
    }

}
