package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.DerivedAttributeBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.DerivedBaseAttribute;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.DerivedBaseAttributeImpl;


public class DerivedAttributeBodyImpl extends ModelInstance<DerivedAttributeBody,Sql> implements DerivedAttributeBody {

    public static final String KEY_LETTERS = "ACT_DAB";
    public static final DerivedAttributeBody EMPTY_DERIVEDATTRIBUTEBODY = new EmptyDerivedAttributeBody();

    private Sql context;

    // constructors
    private DerivedAttributeBodyImpl( Sql context ) {
        this.context = context;
        ref_Action_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Attr_ID = UniqueId.random();
        m_AttributeWritten = false;
        R693_specifies_processing_for_DerivedBaseAttribute_inst = DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    private DerivedAttributeBodyImpl( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, boolean m_AttributeWritten ) {
        super(instanceId);
        this.context = context;
        this.ref_Action_ID = ref_Action_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Attr_ID = ref_Attr_ID;
        this.m_AttributeWritten = m_AttributeWritten;
        R693_specifies_processing_for_DerivedBaseAttribute_inst = DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    public static DerivedAttributeBody create( Sql context ) throws XtumlException {
        DerivedAttributeBody newDerivedAttributeBody = new DerivedAttributeBodyImpl( context );
        if ( context.addInstance( newDerivedAttributeBody ) ) {
            newDerivedAttributeBody.getRunContext().addChange(new InstanceCreatedDelta(newDerivedAttributeBody, KEY_LETTERS));
            return newDerivedAttributeBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DerivedAttributeBody create( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, boolean m_AttributeWritten ) throws XtumlException {
        DerivedAttributeBody newDerivedAttributeBody = new DerivedAttributeBodyImpl( context, instanceId, ref_Action_ID, ref_Obj_ID, ref_Attr_ID, m_AttributeWritten );
        if ( context.addInstance( newDerivedAttributeBody ) ) {
            return newDerivedAttributeBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Action_ID;
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
                return ref_Action_ID;
    }
    @Override
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Action_ID.inequality( this.ref_Action_ID ) ) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    private UniqueId ref_Attr_ID;
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
                return ref_Attr_ID;
    }
    @Override
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Attr_ID.inequality( this.ref_Attr_ID ) ) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    private boolean m_AttributeWritten;
    @Override
    public boolean getAttributeWritten() throws XtumlException {
        checkLiving();
                return m_AttributeWritten;
    }
    @Override
    public void setAttributeWritten( boolean m_AttributeWritten ) throws XtumlException {
        checkLiving();
        if ( m_AttributeWritten != this.m_AttributeWritten ) {
            final boolean oldValue = this.m_AttributeWritten;
            this.m_AttributeWritten = m_AttributeWritten;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_AttributeWritten", oldValue, this.m_AttributeWritten));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private DerivedBaseAttribute R693_specifies_processing_for_DerivedBaseAttribute_inst;
    @Override
    public void setR693_specifies_processing_for_DerivedBaseAttribute( DerivedBaseAttribute inst ) {
        R693_specifies_processing_for_DerivedBaseAttribute_inst = inst;
    }
    @Override
    public DerivedBaseAttribute R693_specifies_processing_for_DerivedBaseAttribute() throws XtumlException {
        return R693_specifies_processing_for_DerivedBaseAttribute_inst;
    }
    private Body R698_is_a_Body_inst;
    @Override
    public void setR698_is_a_Body( Body inst ) {
        R698_is_a_Body_inst = inst;
    }
    @Override
    public Body R698_is_a_Body() throws XtumlException {
        return R698_is_a_Body_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DerivedAttributeBody value() {
        return this;
    }

    @Override
    public DerivedAttributeBody self() {
        return this;
    }

    @Override
    public DerivedAttributeBody oneWhere( IWhere<DerivedAttributeBody> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_DERIVEDATTRIBUTEBODY;
    }

}

class EmptyDerivedAttributeBody extends ModelInstance<DerivedAttributeBody,Sql> implements DerivedAttributeBody {

    // attributes
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getAttributeWritten() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttributeWritten( boolean m_AttributeWritten ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public DerivedBaseAttribute R693_specifies_processing_for_DerivedBaseAttribute() {
        return DerivedBaseAttributeImpl.EMPTY_DERIVEDBASEATTRIBUTE;
    }
    @Override
    public Body R698_is_a_Body() {
        return BodyImpl.EMPTY_BODY;
    }


    @Override
    public String getKeyLetters() {
        return DerivedAttributeBodyImpl.KEY_LETTERS;
    }

    @Override
    public DerivedAttributeBody value() {
        return this;
    }
    
    @Override
    public DerivedAttributeBody self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DerivedAttributeBody oneWhere( IWhere<DerivedAttributeBody> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return DerivedAttributeBodyImpl.EMPTY_DERIVEDATTRIBUTEBODY;
    }

}
