package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.ClassAsDerivedOneSide;
import io.ciera.tool.sql.ooaofooa.association.ClassAsDerivedOtherSide;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociation;
import io.ciera.tool.sql.ooaofooa.association.ReferredToClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.ReferringClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsDerivedOneSideImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsDerivedOtherSideImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferredToClassInAssocImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferringClassInAssocImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ImportedClass;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ImportedClassImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class ClassInAssociationImpl extends ModelInstance<ClassInAssociation,Sql> implements ClassInAssociation {

    public static final String KEY_LETTERS = "R_OIR";
    public static final ClassInAssociation EMPTY_CLASSINASSOCIATION = new EmptyClassInAssociation();

    private Sql context;

    // constructors
    private ClassInAssociationImpl( Sql context ) {
        this.context = context;
        ref_Obj_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        m_OIR_ID = UniqueId.random();
        ref_IObj_ID = UniqueId.random();
        R201_abstracts_association_between_instances_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R201_has_instance_associations_abstracted_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R202_may_be_represented_by_ImportedClass_inst = ImportedClassImpl.EMPTY_IMPORTEDCLASS;
        R203_is_a_ClassAsDerivedOneSide_inst = ClassAsDerivedOneSideImpl.EMPTY_CLASSASDERIVEDONESIDE;
        R203_is_a_ClassAsDerivedOtherSide_inst = ClassAsDerivedOtherSideImpl.EMPTY_CLASSASDERIVEDOTHERSIDE;
        R203_is_a_ReferredToClassInAssoc_inst = ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
        R203_is_a_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
    }

    private ClassInAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId m_OIR_ID, UniqueId ref_IObj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.m_OIR_ID = m_OIR_ID;
        this.ref_IObj_ID = ref_IObj_ID;
        R201_abstracts_association_between_instances_of_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R201_has_instance_associations_abstracted_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R202_may_be_represented_by_ImportedClass_inst = ImportedClassImpl.EMPTY_IMPORTEDCLASS;
        R203_is_a_ClassAsDerivedOneSide_inst = ClassAsDerivedOneSideImpl.EMPTY_CLASSASDERIVEDONESIDE;
        R203_is_a_ClassAsDerivedOtherSide_inst = ClassAsDerivedOtherSideImpl.EMPTY_CLASSASDERIVEDOTHERSIDE;
        R203_is_a_ReferredToClassInAssoc_inst = ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
        R203_is_a_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
    }

    public static ClassInAssociation create( Sql context ) throws XtumlException {
        ClassInAssociation newClassInAssociation = new ClassInAssociationImpl( context );
        if ( context.addInstance( newClassInAssociation ) ) {
            newClassInAssociation.getRunContext().addChange(new InstanceCreatedDelta(newClassInAssociation, KEY_LETTERS));
            return newClassInAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassInAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId m_OIR_ID, UniqueId ref_IObj_ID ) throws XtumlException {
        ClassInAssociation newClassInAssociation = new ClassInAssociationImpl( context, instanceId, ref_Obj_ID, ref_Rel_ID, m_OIR_ID, ref_IObj_ID );
        if ( context.addInstance( newClassInAssociation ) ) {
            return newClassInAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Obj_ID.inequality( this.ref_Obj_ID ) ) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R203_is_a_ReferringClassInAssoc().isEmpty() ) R203_is_a_ReferringClassInAssoc().setObj_ID( ref_Obj_ID );
            if ( !R203_is_a_ClassAsDerivedOtherSide().isEmpty() ) R203_is_a_ClassAsDerivedOtherSide().setObj_ID( ref_Obj_ID );
            if ( !R203_is_a_ClassAsDerivedOneSide().isEmpty() ) R203_is_a_ClassAsDerivedOneSide().setObj_ID( ref_Obj_ID );
            if ( !R203_is_a_ReferredToClassInAssoc().isEmpty() ) R203_is_a_ReferredToClassInAssoc().setObj_ID( ref_Obj_ID );
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
                return ref_Obj_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
                return ref_Rel_ID;
    }
    @Override
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Rel_ID.inequality( this.ref_Rel_ID ) ) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R203_is_a_ReferringClassInAssoc().isEmpty() ) R203_is_a_ReferringClassInAssoc().setRel_ID( ref_Rel_ID );
            if ( !R203_is_a_ClassAsDerivedOtherSide().isEmpty() ) R203_is_a_ClassAsDerivedOtherSide().setRel_ID( ref_Rel_ID );
            if ( !R203_is_a_ClassAsDerivedOneSide().isEmpty() ) R203_is_a_ClassAsDerivedOneSide().setRel_ID( ref_Rel_ID );
            if ( !R203_is_a_ReferredToClassInAssoc().isEmpty() ) R203_is_a_ReferredToClassInAssoc().setRel_ID( ref_Rel_ID );
        }
    }
    private UniqueId m_OIR_ID;
    @Override
    public void setOIR_ID( UniqueId m_OIR_ID ) throws XtumlException {
        checkLiving();
        if ( m_OIR_ID.inequality( this.m_OIR_ID ) ) {
            final UniqueId oldValue = this.m_OIR_ID;
            this.m_OIR_ID = m_OIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_OIR_ID", oldValue, this.m_OIR_ID));
            if ( !R203_is_a_ClassAsDerivedOneSide().isEmpty() ) R203_is_a_ClassAsDerivedOneSide().setOIR_ID( m_OIR_ID );
            if ( !R203_is_a_ReferredToClassInAssoc().isEmpty() ) R203_is_a_ReferredToClassInAssoc().setOIR_ID( m_OIR_ID );
            if ( !R203_is_a_ReferringClassInAssoc().isEmpty() ) R203_is_a_ReferringClassInAssoc().setOIR_ID( m_OIR_ID );
            if ( !R203_is_a_ClassAsDerivedOtherSide().isEmpty() ) R203_is_a_ClassAsDerivedOtherSide().setOIR_ID( m_OIR_ID );
        }
    }
    @Override
    public UniqueId getOIR_ID() throws XtumlException {
        checkLiving();
                return m_OIR_ID;
    }
    private UniqueId ref_IObj_ID;
    @Override
    public void setIObj_ID( UniqueId ref_IObj_ID ) throws XtumlException {
        checkLiving();
        if ( ref_IObj_ID.inequality( this.ref_IObj_ID ) ) {
            final UniqueId oldValue = this.ref_IObj_ID;
            this.ref_IObj_ID = ref_IObj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_IObj_ID", oldValue, this.ref_IObj_ID));
        }
    }
    @Override
    public UniqueId getIObj_ID() throws XtumlException {
        checkLiving();
                return ref_IObj_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getObj_ID(), getRel_ID(), getOIR_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ModelClass R201_abstracts_association_between_instances_of_ModelClass_inst;
    @Override
    public void setR201_abstracts_association_between_instances_of_ModelClass( ModelClass inst ) {
        R201_abstracts_association_between_instances_of_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R201_abstracts_association_between_instances_of_ModelClass() throws XtumlException {
        return R201_abstracts_association_between_instances_of_ModelClass_inst;
    }
    private Association R201_has_instance_associations_abstracted_Association_inst;
    @Override
    public void setR201_has_instance_associations_abstracted_Association( Association inst ) {
        R201_has_instance_associations_abstracted_Association_inst = inst;
    }
    @Override
    public Association R201_has_instance_associations_abstracted_Association() throws XtumlException {
        return R201_has_instance_associations_abstracted_Association_inst;
    }
    private ImportedClass R202_may_be_represented_by_ImportedClass_inst;
    @Override
    public void setR202_may_be_represented_by_ImportedClass( ImportedClass inst ) {
        R202_may_be_represented_by_ImportedClass_inst = inst;
    }
    @Override
    public ImportedClass R202_may_be_represented_by_ImportedClass() throws XtumlException {
        return R202_may_be_represented_by_ImportedClass_inst;
    }
    private ClassAsDerivedOneSide R203_is_a_ClassAsDerivedOneSide_inst;
    @Override
    public void setR203_is_a_ClassAsDerivedOneSide( ClassAsDerivedOneSide inst ) {
        R203_is_a_ClassAsDerivedOneSide_inst = inst;
    }
    @Override
    public ClassAsDerivedOneSide R203_is_a_ClassAsDerivedOneSide() throws XtumlException {
        return R203_is_a_ClassAsDerivedOneSide_inst;
    }
    private ClassAsDerivedOtherSide R203_is_a_ClassAsDerivedOtherSide_inst;
    @Override
    public void setR203_is_a_ClassAsDerivedOtherSide( ClassAsDerivedOtherSide inst ) {
        R203_is_a_ClassAsDerivedOtherSide_inst = inst;
    }
    @Override
    public ClassAsDerivedOtherSide R203_is_a_ClassAsDerivedOtherSide() throws XtumlException {
        return R203_is_a_ClassAsDerivedOtherSide_inst;
    }
    private ReferredToClassInAssoc R203_is_a_ReferredToClassInAssoc_inst;
    @Override
    public void setR203_is_a_ReferredToClassInAssoc( ReferredToClassInAssoc inst ) {
        R203_is_a_ReferredToClassInAssoc_inst = inst;
    }
    @Override
    public ReferredToClassInAssoc R203_is_a_ReferredToClassInAssoc() throws XtumlException {
        return R203_is_a_ReferredToClassInAssoc_inst;
    }
    private ReferringClassInAssoc R203_is_a_ReferringClassInAssoc_inst;
    @Override
    public void setR203_is_a_ReferringClassInAssoc( ReferringClassInAssoc inst ) {
        R203_is_a_ReferringClassInAssoc_inst = inst;
    }
    @Override
    public ReferringClassInAssoc R203_is_a_ReferringClassInAssoc() throws XtumlException {
        return R203_is_a_ReferringClassInAssoc_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassInAssociation value() {
        return this;
    }

    @Override
    public ClassInAssociation self() {
        return this;
    }

    @Override
    public ClassInAssociation oneWhere( IWhere<ClassInAssociation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_CLASSINASSOCIATION;
    }

}

class EmptyClassInAssociation extends ModelInstance<ClassInAssociation,Sql> implements ClassInAssociation {

    // attributes
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setOIR_ID( UniqueId m_OIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIObj_ID( UniqueId ref_IObj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getIObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ModelClass R201_abstracts_association_between_instances_of_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }
    @Override
    public Association R201_has_instance_associations_abstracted_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }
    @Override
    public ImportedClass R202_may_be_represented_by_ImportedClass() {
        return ImportedClassImpl.EMPTY_IMPORTEDCLASS;
    }
    @Override
    public ClassAsDerivedOneSide R203_is_a_ClassAsDerivedOneSide() {
        return ClassAsDerivedOneSideImpl.EMPTY_CLASSASDERIVEDONESIDE;
    }
    @Override
    public ClassAsDerivedOtherSide R203_is_a_ClassAsDerivedOtherSide() {
        return ClassAsDerivedOtherSideImpl.EMPTY_CLASSASDERIVEDOTHERSIDE;
    }
    @Override
    public ReferredToClassInAssoc R203_is_a_ReferredToClassInAssoc() {
        return ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
    }
    @Override
    public ReferringClassInAssoc R203_is_a_ReferringClassInAssoc() {
        return ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
    }


    @Override
    public String getKeyLetters() {
        return ClassInAssociationImpl.KEY_LETTERS;
    }

    @Override
    public ClassInAssociation value() {
        return this;
    }
    
    @Override
    public ClassInAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassInAssociation oneWhere( IWhere<ClassInAssociation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ClassInAssociationImpl.EMPTY_CLASSINASSOCIATION;
    }

}
