package io.ciera.tool.sql.ooaofooa.activity.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.activity.ActivityFinalNode;
import io.ciera.tool.sql.ooaofooa.activity.ActivityNode;
import io.ciera.tool.sql.ooaofooa.activity.ControlNode;
import io.ciera.tool.sql.ooaofooa.activity.DecisionMergeNode;
import io.ciera.tool.sql.ooaofooa.activity.FlowFinalNode;
import io.ciera.tool.sql.ooaofooa.activity.ForkJoinNode;
import io.ciera.tool.sql.ooaofooa.activity.InitialNode;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityFinalNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ActivityNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.DecisionMergeNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.FlowFinalNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.ForkJoinNodeImpl;
import io.ciera.tool.sql.ooaofooa.activity.impl.InitialNodeImpl;


public class ControlNodeImpl extends ModelInstance<ControlNode,Sql> implements ControlNode {

    public static final String KEY_LETTERS = "A_CTL";
    public static final ControlNode EMPTY_CONTROLNODE = new EmptyControlNode();

    private Sql context;

    // constructors
    private ControlNodeImpl( Sql context ) {
        this.context = context;
        ref_Id = UniqueId.random();
        R1105_is_a_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R1106_is_a_ActivityFinalNode_inst = ActivityFinalNodeImpl.EMPTY_ACTIVITYFINALNODE;
        R1106_is_a_DecisionMergeNode_inst = DecisionMergeNodeImpl.EMPTY_DECISIONMERGENODE;
        R1106_is_a_FlowFinalNode_inst = FlowFinalNodeImpl.EMPTY_FLOWFINALNODE;
        R1106_is_a_ForkJoinNode_inst = ForkJoinNodeImpl.EMPTY_FORKJOINNODE;
        R1106_is_a_InitialNode_inst = InitialNodeImpl.EMPTY_INITIALNODE;
    }

    private ControlNodeImpl( Sql context, UniqueId instanceId, UniqueId ref_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Id = ref_Id;
        R1105_is_a_ActivityNode_inst = ActivityNodeImpl.EMPTY_ACTIVITYNODE;
        R1106_is_a_ActivityFinalNode_inst = ActivityFinalNodeImpl.EMPTY_ACTIVITYFINALNODE;
        R1106_is_a_DecisionMergeNode_inst = DecisionMergeNodeImpl.EMPTY_DECISIONMERGENODE;
        R1106_is_a_FlowFinalNode_inst = FlowFinalNodeImpl.EMPTY_FLOWFINALNODE;
        R1106_is_a_ForkJoinNode_inst = ForkJoinNodeImpl.EMPTY_FORKJOINNODE;
        R1106_is_a_InitialNode_inst = InitialNodeImpl.EMPTY_INITIALNODE;
    }

    public static ControlNode create( Sql context ) throws XtumlException {
        ControlNode newControlNode = new ControlNodeImpl( context );
        if ( context.addInstance( newControlNode ) ) {
            newControlNode.getRunContext().addChange(new InstanceCreatedDelta(newControlNode, KEY_LETTERS));
            return newControlNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ControlNode create( Sql context, UniqueId instanceId, UniqueId ref_Id ) throws XtumlException {
        ControlNode newControlNode = new ControlNodeImpl( context, instanceId, ref_Id );
        if ( context.addInstance( newControlNode ) ) {
            return newControlNode;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Id;
    @Override
    public void setId( UniqueId ref_Id ) throws XtumlException {
        checkLiving();
        if ( ref_Id.inequality( this.ref_Id ) ) {
            final UniqueId oldValue = this.ref_Id;
            this.ref_Id = ref_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Id", oldValue, this.ref_Id));
            if ( !R1106_is_a_DecisionMergeNode().isEmpty() ) R1106_is_a_DecisionMergeNode().setId( ref_Id );
            if ( !R1106_is_a_InitialNode().isEmpty() ) R1106_is_a_InitialNode().setId( ref_Id );
            if ( !R1106_is_a_ActivityFinalNode().isEmpty() ) R1106_is_a_ActivityFinalNode().setId( ref_Id );
            if ( !R1106_is_a_ForkJoinNode().isEmpty() ) R1106_is_a_ForkJoinNode().setId( ref_Id );
            if ( !R1106_is_a_FlowFinalNode().isEmpty() ) R1106_is_a_FlowFinalNode().setId( ref_Id );
        }
    }
    @Override
    public UniqueId getId() throws XtumlException {
        checkLiving();
                return ref_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getId());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActivityNode R1105_is_a_ActivityNode_inst;
    @Override
    public void setR1105_is_a_ActivityNode( ActivityNode inst ) {
        R1105_is_a_ActivityNode_inst = inst;
    }
    @Override
    public ActivityNode R1105_is_a_ActivityNode() throws XtumlException {
        return R1105_is_a_ActivityNode_inst;
    }
    private ActivityFinalNode R1106_is_a_ActivityFinalNode_inst;
    @Override
    public void setR1106_is_a_ActivityFinalNode( ActivityFinalNode inst ) {
        R1106_is_a_ActivityFinalNode_inst = inst;
    }
    @Override
    public ActivityFinalNode R1106_is_a_ActivityFinalNode() throws XtumlException {
        return R1106_is_a_ActivityFinalNode_inst;
    }
    private DecisionMergeNode R1106_is_a_DecisionMergeNode_inst;
    @Override
    public void setR1106_is_a_DecisionMergeNode( DecisionMergeNode inst ) {
        R1106_is_a_DecisionMergeNode_inst = inst;
    }
    @Override
    public DecisionMergeNode R1106_is_a_DecisionMergeNode() throws XtumlException {
        return R1106_is_a_DecisionMergeNode_inst;
    }
    private FlowFinalNode R1106_is_a_FlowFinalNode_inst;
    @Override
    public void setR1106_is_a_FlowFinalNode( FlowFinalNode inst ) {
        R1106_is_a_FlowFinalNode_inst = inst;
    }
    @Override
    public FlowFinalNode R1106_is_a_FlowFinalNode() throws XtumlException {
        return R1106_is_a_FlowFinalNode_inst;
    }
    private ForkJoinNode R1106_is_a_ForkJoinNode_inst;
    @Override
    public void setR1106_is_a_ForkJoinNode( ForkJoinNode inst ) {
        R1106_is_a_ForkJoinNode_inst = inst;
    }
    @Override
    public ForkJoinNode R1106_is_a_ForkJoinNode() throws XtumlException {
        return R1106_is_a_ForkJoinNode_inst;
    }
    private InitialNode R1106_is_a_InitialNode_inst;
    @Override
    public void setR1106_is_a_InitialNode( InitialNode inst ) {
        R1106_is_a_InitialNode_inst = inst;
    }
    @Override
    public InitialNode R1106_is_a_InitialNode() throws XtumlException {
        return R1106_is_a_InitialNode_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ControlNode value() {
        return this;
    }

    @Override
    public ControlNode self() {
        return this;
    }

    @Override
    public ControlNode oneWhere( IWhere<ControlNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_CONTROLNODE;
    }

}

class EmptyControlNode extends ModelInstance<ControlNode,Sql> implements ControlNode {

    // attributes
    public void setId( UniqueId ref_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActivityNode R1105_is_a_ActivityNode() {
        return ActivityNodeImpl.EMPTY_ACTIVITYNODE;
    }
    @Override
    public ActivityFinalNode R1106_is_a_ActivityFinalNode() {
        return ActivityFinalNodeImpl.EMPTY_ACTIVITYFINALNODE;
    }
    @Override
    public DecisionMergeNode R1106_is_a_DecisionMergeNode() {
        return DecisionMergeNodeImpl.EMPTY_DECISIONMERGENODE;
    }
    @Override
    public FlowFinalNode R1106_is_a_FlowFinalNode() {
        return FlowFinalNodeImpl.EMPTY_FLOWFINALNODE;
    }
    @Override
    public ForkJoinNode R1106_is_a_ForkJoinNode() {
        return ForkJoinNodeImpl.EMPTY_FORKJOINNODE;
    }
    @Override
    public InitialNode R1106_is_a_InitialNode() {
        return InitialNodeImpl.EMPTY_INITIALNODE;
    }


    @Override
    public String getKeyLetters() {
        return ControlNodeImpl.KEY_LETTERS;
    }

    @Override
    public ControlNode value() {
        return this;
    }
    
    @Override
    public ControlNode self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ControlNode oneWhere( IWhere<ControlNode> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ControlNodeImpl.EMPTY_CONTROLNODE;
    }

}
