package io.ciera.tool.sql.ooaofmarking.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.ooaofmarking.FeatureSet;
import io.ciera.tool.sql.ooaofmarking.MarkSet;
import io.ciera.tool.sql.ooaofmarking.MarkableElementType;
import io.ciera.tool.sql.ooaofmarking.MarkableElementTypeSet;
import io.ciera.tool.sql.ooaofmarking.impl.FeatureSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class MarkableElementTypeSetImpl extends InstanceSet<MarkableElementTypeSet,MarkableElementType> implements MarkableElementTypeSet {

    public MarkableElementTypeSetImpl() {
    }

    public MarkableElementTypeSetImpl(Comparator<? super MarkableElementType> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( MarkableElementType markableelementtype : this ) markableelementtype.setName( m_name );
    }


    // selections
    @Override
    public MarkSet R2821_is_marked_by_Mark() throws XtumlException {
        MarkSet markset = new MarkSetImpl();
        for ( MarkableElementType markableelementtype : this ) markset.addAll( markableelementtype.R2821_is_marked_by_Mark() );
        return markset;
    }
    @Override
    public FeatureSet R2822_makes_available_Feature() throws XtumlException {
        FeatureSet featureset = new FeatureSetImpl();
        for ( MarkableElementType markableelementtype : this ) featureset.addAll( markableelementtype.R2822_makes_available_Feature() );
        return featureset;
    }


    @Override
    public MarkableElementType nullElement() {
        return MarkableElementTypeImpl.EMPTY_MARKABLEELEMENTTYPE;
    }

    @Override
    public MarkableElementTypeSet emptySet() {
      return new MarkableElementTypeSetImpl();
    }

    @Override
    public MarkableElementTypeSet emptySet(Comparator<? super MarkableElementType> comp) {
      return new MarkableElementTypeSetImpl(comp);
    }

    @Override
    public MarkableElementTypeSet value() {
        return this;
    }

    @Override
    public List<MarkableElementType> elements() {
        MarkableElementType[] elements = toArray(new MarkableElementType[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
