package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeLoader;
import io.ciera.tool.sql.loader.StringLoader;
import io.ciera.tool.sql.loader.impl.AttributeLoaderImpl;


public class StringLoaderImpl extends ModelInstance<StringLoader,Sql> implements StringLoader {

    public static final String KEY_LETTERS = "Z_StringLoader";
    public static final StringLoader EMPTY_STRINGLOADER = new EmptyStringLoader();

    private Sql context;

    // constructors
    private StringLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        ref_index = 0;
        ref_attr_name = "";
        R3008_is_a_AttributeLoader_inst = AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }

    private StringLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, String ref_attr_name ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.ref_index = ref_index;
        this.ref_attr_name = ref_attr_name;
        R3008_is_a_AttributeLoader_inst = AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }

    public static StringLoader create( Sql context ) throws XtumlException {
        StringLoader newStringLoader = new StringLoaderImpl( context );
        if ( context.addInstance( newStringLoader ) ) {
            newStringLoader.getRunContext().addChange(new InstanceCreatedDelta(newStringLoader, KEY_LETTERS));
            return newStringLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StringLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, int ref_index, String ref_attr_name ) throws XtumlException {
        StringLoader newStringLoader = new StringLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, ref_index, ref_attr_name );
        if ( context.addInstance( newStringLoader ) ) {
            return newStringLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_name, this.ref_loader_name ) ) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
                return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
                return ref_loader_package;
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_loader_package, this.ref_loader_package ) ) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
                return ref_class_name;
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_class_name, this.ref_class_name ) ) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private int ref_index;
    @Override
    public void setIndex( int ref_index ) throws XtumlException {
        checkLiving();
        if ( ref_index != this.ref_index ) {
            final int oldValue = this.ref_index;
            this.ref_index = ref_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_index", oldValue, this.ref_index));
        }
    }
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
                return ref_index;
    }
    private String ref_attr_name;
    @Override
    public String getAttr_name() throws XtumlException {
        checkLiving();
                return ref_attr_name;
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_attr_name, this.ref_attr_name ) ) {
            final String oldValue = this.ref_attr_name;
            this.ref_attr_name = ref_attr_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_attr_name", oldValue, this.ref_attr_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name(), getIndex(), getAttr_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        AttributeLoader attr_loader = self().R3008_is_a_AttributeLoader();
        int value_index = attr_loader.getValue_index();
        context().T().include( "loader/t.stringloader.java", value_index );
    }



    // static operations


    // events


    // selections
    private AttributeLoader R3008_is_a_AttributeLoader_inst;
    @Override
    public void setR3008_is_a_AttributeLoader( AttributeLoader inst ) {
        R3008_is_a_AttributeLoader_inst = inst;
    }
    @Override
    public AttributeLoader R3008_is_a_AttributeLoader() throws XtumlException {
        return R3008_is_a_AttributeLoader_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StringLoader value() {
        return this;
    }

    @Override
    public StringLoader self() {
        return this;
    }

    @Override
    public StringLoader oneWhere( IWhere<StringLoader> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_STRINGLOADER;
    }

}

class EmptyStringLoader extends ModelInstance<StringLoader,Sql> implements StringLoader {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIndex( int ref_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getAttr_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public AttributeLoader R3008_is_a_AttributeLoader() {
        return AttributeLoaderImpl.EMPTY_ATTRIBUTELOADER;
    }


    @Override
    public String getKeyLetters() {
        return StringLoaderImpl.KEY_LETTERS;
    }

    @Override
    public StringLoader value() {
        return this;
    }
    
    @Override
    public StringLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StringLoader oneWhere( IWhere<StringLoader> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return StringLoaderImpl.EMPTY_STRINGLOADER;
    }

}
