package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.impl.GeneralFileImpl;
import io.ciera.tool.sql.loader.BatchRelator;
import io.ciera.tool.sql.loader.BatchRelatorSet;
import io.ciera.tool.sql.loader.InstanceLoader;
import io.ciera.tool.sql.loader.InstanceLoaderSet;
import io.ciera.tool.sql.loader.InstanceSerializer;
import io.ciera.tool.sql.loader.InstanceSerializerSet;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.impl.BatchRelatorSetImpl;
import io.ciera.tool.sql.loader.impl.InstanceLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.InstanceSerializerSetImpl;

import java.util.Iterator;

import types.ImportType;


public class PopulationLoaderImpl extends ModelInstance<PopulationLoader,Sql> implements PopulationLoader {

    public static final String KEY_LETTERS = "Z_PopulationLoader";
    public static final PopulationLoader EMPTY_POPULATIONLOADER = new EmptyPopulationLoader();

    private Sql context;

    // constructors
    private PopulationLoaderImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        m_comp_name = "";
        R3001_serializes_population_using_InstanceSerializer_set = new InstanceSerializerSetImpl();
        R3005_loads_population_using_InstanceLoader_set = new InstanceLoaderSetImpl();
        R3009_is_a_GeneralFile_inst = GeneralFileImpl.EMPTY_GENERALFILE;
        R3011_relates_instances_using_BatchRelator_set = new BatchRelatorSetImpl();
    }

    private PopulationLoaderImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String m_comp_name ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.m_comp_name = m_comp_name;
        R3001_serializes_population_using_InstanceSerializer_set = new InstanceSerializerSetImpl();
        R3005_loads_population_using_InstanceLoader_set = new InstanceLoaderSetImpl();
        R3009_is_a_GeneralFile_inst = GeneralFileImpl.EMPTY_GENERALFILE;
        R3011_relates_instances_using_BatchRelator_set = new BatchRelatorSetImpl();
    }

    public static PopulationLoader create( Sql context ) throws XtumlException {
        PopulationLoader newPopulationLoader = new PopulationLoaderImpl( context );
        if ( context.addInstance( newPopulationLoader ) ) {
            newPopulationLoader.getRunContext().addChange(new InstanceCreatedDelta(newPopulationLoader, KEY_LETTERS));
            return newPopulationLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PopulationLoader create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String m_comp_name ) throws XtumlException {
        PopulationLoader newPopulationLoader = new PopulationLoaderImpl( context, instanceId, ref_name, ref_package, m_comp_name );
        if ( context.addInstance( newPopulationLoader ) ) {
            return newPopulationLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R3005_loads_population_using_InstanceLoader().isEmpty() ) R3005_loads_population_using_InstanceLoader().setLoader_name( ref_name );
            if ( !R3011_relates_instances_using_BatchRelator().isEmpty() ) R3011_relates_instances_using_BatchRelator().setLoader_name( ref_name );
            if ( !R3001_serializes_population_using_InstanceSerializer().isEmpty() ) R3001_serializes_population_using_InstanceSerializer().setLoader_name( ref_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    private String ref_package;
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_package, this.ref_package ) ) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
            if ( !R3001_serializes_population_using_InstanceSerializer().isEmpty() ) R3001_serializes_population_using_InstanceSerializer().setLoader_package( ref_package );
            if ( !R3005_loads_population_using_InstanceLoader().isEmpty() ) R3005_loads_population_using_InstanceLoader().setLoader_package( ref_package );
            if ( !R3011_relates_instances_using_BatchRelator().isEmpty() ) R3011_relates_instances_using_BatchRelator().setLoader_package( ref_package );
        }
    }
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
                return ref_package;
    }
    private String m_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return m_comp_name;
    }
    @Override
    public void setComp_name( String m_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_comp_name, this.m_comp_name ) ) {
            final String oldValue = this.m_comp_name;
            this.m_comp_name = m_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_comp_name", oldValue, this.m_comp_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        InstanceSerializerSet class_inst_serializers = self().R3001_serializes_population_using_InstanceSerializer().R3015_is_a_ClassInstanceSerializer().R3015_is_a_InstanceSerializer();
        InstanceSerializer class_inst_serializer;
        for ( Iterator<InstanceSerializer> _class_inst_serializer_iter = class_inst_serializers.elements().iterator(); _class_inst_serializer_iter.hasNext(); ) {
            class_inst_serializer = _class_inst_serializer_iter.next();
            class_inst_serializer.render();
        }
        InstanceSerializerSet timer_serializers = self().R3001_serializes_population_using_InstanceSerializer().R3015_is_a_TimerInstanceSerializer().R3015_is_a_InstanceSerializer();
        InstanceSerializer timer_serializer;
        for ( Iterator<InstanceSerializer> _timer_serializer_iter = timer_serializers.elements().iterator(); _timer_serializer_iter.hasNext(); ) {
            timer_serializer = _timer_serializer_iter.next();
            timer_serializer.render();
        }
        InstanceSerializerSet event_serializers = self().R3001_serializes_population_using_InstanceSerializer().R3015_is_a_EventInstanceSerializer().R3015_is_a_InstanceSerializer();
        InstanceSerializer event_serializer;
        for ( Iterator<InstanceSerializer> _event_serializer_iter = event_serializers.elements().iterator(); _event_serializer_iter.hasNext(); ) {
            event_serializer = _event_serializer_iter.next();
            event_serializer.render();
        }
        String instance_serializers = context().T().body();
        context().T().clear();
        InstanceSerializerSet inst_serializers = self().R3001_serializes_population_using_InstanceSerializer();
        InstanceSerializer inst_serializer;
        for ( Iterator<InstanceSerializer> _inst_serializer_iter = inst_serializers.elements().iterator(); _inst_serializer_iter.hasNext(); ) {
            inst_serializer = _inst_serializer_iter.next();
            inst_serializer.render_def();
        }
        String instance_serializer_definitions = context().T().body();
        for ( Iterator<InstanceSerializer> _inst_serializer_iter = inst_serializers.elements().iterator(); _inst_serializer_iter.hasNext(); ) {
            inst_serializer = _inst_serializer_iter.next();
            inst_serializer.render_init();
        }
        String instance_serializer_initializers = context().T().body();
        InstanceLoaderSet class_inst_loaders = self().R3005_loads_population_using_InstanceLoader().R3016_is_a_ClassInstanceLoader().R3016_is_a_InstanceLoader();
        InstanceLoader class_inst_loader;
        for ( Iterator<InstanceLoader> _class_inst_loader_iter = class_inst_loaders.elements().iterator(); _class_inst_loader_iter.hasNext(); ) {
            class_inst_loader = _class_inst_loader_iter.next();
            class_inst_loader.render();
        }
        InstanceLoaderSet timer_loaders = self().R3005_loads_population_using_InstanceLoader().R3016_is_a_TimerInstanceLoader().R3016_is_a_InstanceLoader();
        InstanceLoader timer_loader;
        for ( Iterator<InstanceLoader> _timer_loader_iter = timer_loaders.elements().iterator(); _timer_loader_iter.hasNext(); ) {
            timer_loader = _timer_loader_iter.next();
            timer_loader.render();
        }
        InstanceLoaderSet event_loaders = self().R3005_loads_population_using_InstanceLoader().R3016_is_a_EventInstanceLoader().R3016_is_a_InstanceLoader();
        InstanceLoader event_loader;
        for ( Iterator<InstanceLoader> _event_loader_iter = event_loaders.elements().iterator(); _event_loader_iter.hasNext(); ) {
            event_loader = _event_loader_iter.next();
            event_loader.render();
        }
        String instance_loaders = context().T().body();
        context().T().clear();
        BatchRelatorSet batch_relates = self().R3011_relates_instances_using_BatchRelator();
        BatchRelator batch_relator;
        for ( Iterator<BatchRelator> _batch_relator_iter = batch_relates.elements().iterator(); _batch_relator_iter.hasNext(); ) {
            batch_relator = _batch_relator_iter.next();
            batch_relator.render();
        }
        String batch_relator_definitions = context().T().body();
        context().T().clear();
        String batch_relators = "";
        String relate_count = "";
        String sep = "";
        for ( Iterator<BatchRelator> _batch_relator_iter = batch_relates.elements().iterator(); _batch_relator_iter.hasNext(); ) {
            batch_relator = _batch_relator_iter.next();
            batch_relators = ( ( batch_relators + "        batch_relate_" ) + batch_relator.getRel_name() ) + "();\n";
            relate_count = ( ( ( relate_count + sep ) + "population." ) + batch_relator.getForm_name() ) + "_instances().size()";
            sep = " + ";
        }
        String instance_count = "";
        sep = "";
        for ( Iterator<InstanceSerializer> _class_inst_serializer_iter = class_inst_serializers.elements().iterator(); _class_inst_serializer_iter.hasNext(); ) {
            class_inst_serializer = _class_inst_serializer_iter.next();
            instance_count = ( ( ( instance_count + sep ) + "population." ) + class_inst_serializer.getClass_name() ) + "_instances().size()";
            sep = " + ";
        }
        if ( !timer_serializers.isEmpty() ) {
            instance_count = ( instance_count + sep ) + "population.getRunContext().getActiveTimers().where(selected -> selected.getPopulationId() == population.getId()).size()";
            sep = " + ";
        }
        if ( !event_serializers.isEmpty() ) {
            instance_count = ( instance_count + sep ) + "population.getRunContext().getActiveEvents().where(selected -> selected.getPopulationId() == population.getId()).size()";
            sep = " + ";
        }
        GeneralFile general_file = self().R3009_is_a_GeneralFile();
        File file = general_file.R401_is_a_File();
        String imports = file.getFormattedImports( ImportType.IMPL );
        context().T().include( "loader/t.populationloader.java", batch_relator_definitions, batch_relators, imports, instance_loaders, instance_serializer_definitions, instance_serializers, self() );
        general_file.setContents( context().T().body() );
        context().T().clear();
        file.render();
    }



    // static operations


    // events


    // selections
    private InstanceSerializerSet R3001_serializes_population_using_InstanceSerializer_set;
    @Override
    public void addR3001_serializes_population_using_InstanceSerializer( InstanceSerializer inst ) {
        R3001_serializes_population_using_InstanceSerializer_set.add(inst);
    }
    @Override
    public void removeR3001_serializes_population_using_InstanceSerializer( InstanceSerializer inst ) {
        R3001_serializes_population_using_InstanceSerializer_set.remove(inst);
    }
    @Override
    public InstanceSerializerSet R3001_serializes_population_using_InstanceSerializer() throws XtumlException {
        return R3001_serializes_population_using_InstanceSerializer_set;
    }
    private InstanceLoaderSet R3005_loads_population_using_InstanceLoader_set;
    @Override
    public void addR3005_loads_population_using_InstanceLoader( InstanceLoader inst ) {
        R3005_loads_population_using_InstanceLoader_set.add(inst);
    }
    @Override
    public void removeR3005_loads_population_using_InstanceLoader( InstanceLoader inst ) {
        R3005_loads_population_using_InstanceLoader_set.remove(inst);
    }
    @Override
    public InstanceLoaderSet R3005_loads_population_using_InstanceLoader() throws XtumlException {
        return R3005_loads_population_using_InstanceLoader_set;
    }
    private GeneralFile R3009_is_a_GeneralFile_inst;
    @Override
    public void setR3009_is_a_GeneralFile( GeneralFile inst ) {
        R3009_is_a_GeneralFile_inst = inst;
    }
    @Override
    public GeneralFile R3009_is_a_GeneralFile() throws XtumlException {
        return R3009_is_a_GeneralFile_inst;
    }
    private BatchRelatorSet R3011_relates_instances_using_BatchRelator_set;
    @Override
    public void addR3011_relates_instances_using_BatchRelator( BatchRelator inst ) {
        R3011_relates_instances_using_BatchRelator_set.add(inst);
    }
    @Override
    public void removeR3011_relates_instances_using_BatchRelator( BatchRelator inst ) {
        R3011_relates_instances_using_BatchRelator_set.remove(inst);
    }
    @Override
    public BatchRelatorSet R3011_relates_instances_using_BatchRelator() throws XtumlException {
        return R3011_relates_instances_using_BatchRelator_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PopulationLoader value() {
        return this;
    }

    @Override
    public PopulationLoader self() {
        return this;
    }

    @Override
    public PopulationLoader oneWhere( IWhere<PopulationLoader> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_POPULATIONLOADER;
    }

}

class EmptyPopulationLoader extends ModelInstance<PopulationLoader,Sql> implements PopulationLoader {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String m_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InstanceSerializerSet R3001_serializes_population_using_InstanceSerializer() {
        return (new InstanceSerializerSetImpl());
    }
    @Override
    public InstanceLoaderSet R3005_loads_population_using_InstanceLoader() {
        return (new InstanceLoaderSetImpl());
    }
    @Override
    public GeneralFile R3009_is_a_GeneralFile() {
        return GeneralFileImpl.EMPTY_GENERALFILE;
    }
    @Override
    public BatchRelatorSet R3011_relates_instances_using_BatchRelator() {
        return (new BatchRelatorSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return PopulationLoaderImpl.KEY_LETTERS;
    }

    @Override
    public PopulationLoader value() {
        return this;
    }
    
    @Override
    public PopulationLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PopulationLoader oneWhere( IWhere<PopulationLoader> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }

}
