package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeSerializerSet;
import io.ciera.tool.sql.loader.ClassInstanceSerializerSet;
import io.ciera.tool.sql.loader.EventInstanceSerializerSet;
import io.ciera.tool.sql.loader.InstanceSerializer;
import io.ciera.tool.sql.loader.InstanceSerializerSet;
import io.ciera.tool.sql.loader.PopulationLoaderSet;
import io.ciera.tool.sql.loader.TimerInstanceSerializerSet;
import io.ciera.tool.sql.loader.impl.AttributeSerializerSetImpl;
import io.ciera.tool.sql.loader.impl.ClassInstanceSerializerSetImpl;
import io.ciera.tool.sql.loader.impl.EventInstanceSerializerSetImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.TimerInstanceSerializerSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class InstanceSerializerSetImpl extends InstanceSet<InstanceSerializerSet,InstanceSerializer> implements InstanceSerializerSet {

    public InstanceSerializerSetImpl() {
    }

    public InstanceSerializerSetImpl(Comparator<? super InstanceSerializer> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setClass_name( String m_class_name ) throws XtumlException {
        for ( InstanceSerializer instanceserializer : this ) instanceserializer.setClass_name( m_class_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( InstanceSerializer instanceserializer : this ) instanceserializer.setLoader_name( ref_loader_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( InstanceSerializer instanceserializer : this ) instanceserializer.setLoader_package( ref_loader_package );
    }


    // selections
    @Override
    public PopulationLoaderSet R3001_invoked_by_PopulationLoader() throws XtumlException {
        PopulationLoaderSet populationloaderset = new PopulationLoaderSetImpl();
        for ( InstanceSerializer instanceserializer : this ) populationloaderset.add( instanceserializer.R3001_invoked_by_PopulationLoader() );
        return populationloaderset;
    }
    @Override
    public AttributeSerializerSet R3002_serializes_data_value_using_AttributeSerializer() throws XtumlException {
        AttributeSerializerSet attributeserializerset = new AttributeSerializerSetImpl();
        for ( InstanceSerializer instanceserializer : this ) attributeserializerset.addAll( instanceserializer.R3002_serializes_data_value_using_AttributeSerializer() );
        return attributeserializerset;
    }
    @Override
    public ClassInstanceSerializerSet R3015_is_a_ClassInstanceSerializer() throws XtumlException {
        ClassInstanceSerializerSet classinstanceserializerset = new ClassInstanceSerializerSetImpl();
        for ( InstanceSerializer instanceserializer : this ) classinstanceserializerset.add( instanceserializer.R3015_is_a_ClassInstanceSerializer() );
        return classinstanceserializerset;
    }
    @Override
    public EventInstanceSerializerSet R3015_is_a_EventInstanceSerializer() throws XtumlException {
        EventInstanceSerializerSet eventinstanceserializerset = new EventInstanceSerializerSetImpl();
        for ( InstanceSerializer instanceserializer : this ) eventinstanceserializerset.add( instanceserializer.R3015_is_a_EventInstanceSerializer() );
        return eventinstanceserializerset;
    }
    @Override
    public TimerInstanceSerializerSet R3015_is_a_TimerInstanceSerializer() throws XtumlException {
        TimerInstanceSerializerSet timerinstanceserializerset = new TimerInstanceSerializerSetImpl();
        for ( InstanceSerializer instanceserializer : this ) timerinstanceserializerset.add( instanceserializer.R3015_is_a_TimerInstanceSerializer() );
        return timerinstanceserializerset;
    }


    @Override
    public InstanceSerializer nullElement() {
        return InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
    }

    @Override
    public InstanceSerializerSet emptySet() {
      return new InstanceSerializerSetImpl();
    }

    @Override
    public InstanceSerializerSet emptySet(Comparator<? super InstanceSerializer> comp) {
      return new InstanceSerializerSetImpl(comp);
    }

    @Override
    public InstanceSerializerSet value() {
        return this;
    }

    @Override
    public List<InstanceSerializer> elements() {
        return Arrays.asList(toArray(new InstanceSerializer[0]));
    }

}
