package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.statement.NullSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;


public class NullSmtImpl extends ModelInstance<NullSmt,Sql> implements NullSmt {

    public static final String KEY_LETTERS = "NullSmt";
    public static final NullSmt EMPTY_NULLSMT = new EmptyNullSmt();

    private Sql context;

    // constructors
    private NullSmtImpl( Sql context ) {
        this.context = context;
        ref_statement_number = "";
        ref_parent_name = "";
        ref_parent_package = "";
        ref_name = "";
        ref_block_number = "";
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
    }

    private NullSmtImpl( Sql context, UniqueId instanceId, String ref_statement_number, String ref_parent_name, String ref_parent_package, String ref_name, String ref_block_number ) {
        super(instanceId);
        this.context = context;
        this.ref_statement_number = ref_statement_number;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_name = ref_name;
        this.ref_block_number = ref_block_number;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
    }

    public static NullSmt create( Sql context ) throws XtumlException {
        NullSmt newNullSmt = new NullSmtImpl( context );
        if ( context.addInstance( newNullSmt ) ) {
            newNullSmt.getRunContext().addChange(new InstanceCreatedDelta(newNullSmt, KEY_LETTERS));
            return newNullSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static NullSmt create( Sql context, UniqueId instanceId, String ref_statement_number, String ref_parent_name, String ref_parent_package, String ref_name, String ref_block_number ) throws XtumlException {
        NullSmt newNullSmt = new NullSmtImpl( context, instanceId, ref_statement_number, ref_parent_name, ref_parent_package, ref_name, ref_block_number );
        if ( context.addInstance( newNullSmt ) ) {
            return newNullSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_statement_number;
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_statement_number, this.ref_statement_number ) ) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
                return ref_statement_number;
    }
    private String ref_parent_name;
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_name, this.ref_parent_name ) ) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
                return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
                return ref_parent_package;
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_package, this.ref_parent_package ) ) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    private String ref_block_number;
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_block_number, this.ref_block_number ) ) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
                return ref_block_number;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_number(), getParent_name(), getParent_package(), getName(), getBlock_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public NullSmt value() {
        return this;
    }

    @Override
    public NullSmt self() {
        return this;
    }

    @Override
    public NullSmt oneWhere( IWhere<NullSmt> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_NULLSMT;
    }

}

class EmptyNullSmt extends ModelInstance<NullSmt,Sql> implements NullSmt {

    // attributes
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }


    @Override
    public String getKeyLetters() {
        return NullSmtImpl.KEY_LETTERS;
    }

    @Override
    public NullSmt value() {
        return this;
    }
    
    @Override
    public NullSmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public NullSmt oneWhere( IWhere<NullSmt> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return NullSmtImpl.EMPTY_NULLSMT;
    }

}
