package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.statemachine.State;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCellSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableRow;
import io.ciera.tool.sql.architecture.statemachine.impl.StateImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableCellSetImpl;


public class TransitionTableRowImpl extends ModelInstance<TransitionTableRow,Sql> implements TransitionTableRow {

    public static final String KEY_LETTERS = "TransitionTableRow";
    public static final TransitionTableRow EMPTY_TRANSITIONTABLEROW = new EmptyTransitionTableRow();

    private Sql context;

    // constructors
    private TransitionTableRowImpl( Sql context ) {
        this.context = context;
        ref_sm_name = "";
        ref_sm_package = "";
        ref_state_name = "";
        m_index = 0;
        R4753_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R4754_State_inst = StateImpl.EMPTY_STATE;
        R4755_defined_by_TransitionTableCell_set = new TransitionTableCellSetImpl();
    }

    private TransitionTableRowImpl( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_state_name, int m_index ) {
        super(instanceId);
        this.context = context;
        this.ref_sm_name = ref_sm_name;
        this.ref_sm_package = ref_sm_package;
        this.ref_state_name = ref_state_name;
        this.m_index = m_index;
        R4753_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R4754_State_inst = StateImpl.EMPTY_STATE;
        R4755_defined_by_TransitionTableCell_set = new TransitionTableCellSetImpl();
    }

    public static TransitionTableRow create( Sql context ) throws XtumlException {
        TransitionTableRow newTransitionTableRow = new TransitionTableRowImpl( context );
        if ( context.addInstance( newTransitionTableRow ) ) {
            newTransitionTableRow.getRunContext().addChange(new InstanceCreatedDelta(newTransitionTableRow, KEY_LETTERS));
            return newTransitionTableRow;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TransitionTableRow create( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_state_name, int m_index ) throws XtumlException {
        TransitionTableRow newTransitionTableRow = new TransitionTableRowImpl( context, instanceId, ref_sm_name, ref_sm_package, ref_state_name, m_index );
        if ( context.addInstance( newTransitionTableRow ) ) {
            return newTransitionTableRow;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_sm_name;
    @Override
    public String getSm_name() throws XtumlException {
        checkLiving();
                return ref_sm_name;
    }
    @Override
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_sm_name, this.ref_sm_name ) ) {
            final String oldValue = this.ref_sm_name;
            this.ref_sm_name = ref_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_name", oldValue, this.ref_sm_name));
            if ( !R4755_defined_by_TransitionTableCell().isEmpty() ) R4755_defined_by_TransitionTableCell().setSm_name( ref_sm_name );
        }
    }
    private String ref_sm_package;
    @Override
    public String getSm_package() throws XtumlException {
        checkLiving();
                return ref_sm_package;
    }
    @Override
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_sm_package, this.ref_sm_package ) ) {
            final String oldValue = this.ref_sm_package;
            this.ref_sm_package = ref_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_package", oldValue, this.ref_sm_package));
            if ( !R4755_defined_by_TransitionTableCell().isEmpty() ) R4755_defined_by_TransitionTableCell().setSm_package( ref_sm_package );
        }
    }
    private String ref_state_name;
    @Override
    public String getState_name() throws XtumlException {
        checkLiving();
                return ref_state_name;
    }
    @Override
    public void setState_name( String ref_state_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_state_name, this.ref_state_name ) ) {
            final String oldValue = this.ref_state_name;
            this.ref_state_name = ref_state_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_state_name", oldValue, this.ref_state_name));
            if ( !R4755_defined_by_TransitionTableCell().isEmpty() ) R4755_defined_by_TransitionTableCell().setState_name( ref_state_name );
        }
    }
    private int m_index;
    @Override
    public int getIndex() throws XtumlException {
        checkLiving();
                return m_index;
    }
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        checkLiving();
        if ( m_index != this.m_index ) {
            final int oldValue = this.m_index;
            this.m_index = m_index;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_index", oldValue, this.m_index));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSm_name(), getSm_package(), getState_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        int index = 0;
        String sep = "";
        final int _final0_index = index;
        TransitionTableCell cell = self().R4755_defined_by_TransitionTableCell().anyWhere(selected -> selected.getIndex() == _final0_index);
        while ( !cell.isEmpty() ) {
            context().T().append( sep );
            cell.render();
            index = index + 1;
            sep = ",\n              ";
            final int _final1_index = index;
            cell = self().R4755_defined_by_TransitionTableCell().anyWhere(selected -> selected.getIndex() == _final1_index);
        }
        String transition_table_cells = context().T().body();
        context().T().pop_buffer();
        context().T().include( "statemachine/t.transitiontablerow.java", transition_table_cells );
    }



    // static operations


    // events


    // selections
    private StateMachine R4753_StateMachine_inst;
    @Override
    public void setR4753_StateMachine( StateMachine inst ) {
        R4753_StateMachine_inst = inst;
    }
    @Override
    public StateMachine R4753_StateMachine() throws XtumlException {
        return R4753_StateMachine_inst;
    }
    private State R4754_State_inst;
    @Override
    public void setR4754_State( State inst ) {
        R4754_State_inst = inst;
    }
    @Override
    public State R4754_State() throws XtumlException {
        return R4754_State_inst;
    }
    private TransitionTableCellSet R4755_defined_by_TransitionTableCell_set;
    @Override
    public void addR4755_defined_by_TransitionTableCell( TransitionTableCell inst ) {
        R4755_defined_by_TransitionTableCell_set.add(inst);
    }
    @Override
    public void removeR4755_defined_by_TransitionTableCell( TransitionTableCell inst ) {
        R4755_defined_by_TransitionTableCell_set.remove(inst);
    }
    @Override
    public TransitionTableCellSet R4755_defined_by_TransitionTableCell() throws XtumlException {
        return R4755_defined_by_TransitionTableCell_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TransitionTableRow value() {
        return this;
    }

    @Override
    public TransitionTableRow self() {
        return this;
    }

    @Override
    public TransitionTableRow oneWhere( IWhere<TransitionTableRow> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_TRANSITIONTABLEROW;
    }

}

class EmptyTransitionTableRow extends ModelInstance<TransitionTableRow,Sql> implements TransitionTableRow {

    // attributes
    public String getSm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getState_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setState_name( String ref_state_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getIndex() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIndex( int m_index ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public StateMachine R4753_StateMachine() {
        return StateMachineImpl.EMPTY_STATEMACHINE;
    }
    @Override
    public State R4754_State() {
        return StateImpl.EMPTY_STATE;
    }
    @Override
    public TransitionTableCellSet R4755_defined_by_TransitionTableCell() {
        return (new TransitionTableCellSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TransitionTableRowImpl.KEY_LETTERS;
    }

    @Override
    public TransitionTableRow value() {
        return this;
    }
    
    @Override
    public TransitionTableRow self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TransitionTableRow oneWhere( IWhere<TransitionTableRow> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return TransitionTableRowImpl.EMPTY_TRANSITIONTABLEROW;
    }

}
