package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.EventSet;
import io.ciera.tool.sql.architecture.statemachine.StateMachineSet;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCellSet;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineSetImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableCellSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventSet;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class EventSetImpl extends InstanceSet<EventSet,Event> implements EventSet {

    public EventSetImpl() {
    }

    public EventSetImpl(Comparator<? super Event> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Event event : this ) event.setName( ref_name );
    }
    @Override
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        for ( Event event : this ) event.setSMevt_ID( ref_SMevt_ID );
    }
    @Override
    public void setId( int m_id ) throws XtumlException {
        for ( Event event : this ) event.setId( m_id );
    }
    @Override
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        for ( Event event : this ) event.setSm_package( ref_sm_package );
    }
    @Override
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        for ( Event event : this ) event.setSm_name( ref_sm_name );
    }


    // selections
    @Override
    public InvocableObjectSet R427_is_a_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( Event event : this ) invocableobjectset.add( event.R427_is_a_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public StateMachineSet R4752_StateMachine() throws XtumlException {
        StateMachineSet statemachineset = new StateMachineSetImpl();
        for ( Event event : this ) statemachineset.add( event.R4752_StateMachine() );
        return statemachineset;
    }
    @Override
    public TransitionTableCellSet R4756_TransitionTableCell() throws XtumlException {
        TransitionTableCellSet transitiontablecellset = new TransitionTableCellSetImpl();
        for ( Event event : this ) transitiontablecellset.addAll( event.R4756_TransitionTableCell() );
        return transitiontablecellset;
    }
    @Override
    public StateMachineEventSet R4759_StateMachineEvent() throws XtumlException {
        StateMachineEventSet statemachineeventset = new StateMachineEventSetImpl();
        for ( Event event : this ) statemachineeventset.add( event.R4759_StateMachineEvent() );
        return statemachineeventset;
    }


    @Override
    public Event nullElement() {
        return EventImpl.EMPTY_EVENT;
    }

    @Override
    public EventSet emptySet() {
      return new EventSetImpl();
    }

    @Override
    public EventSet emptySet(Comparator<? super Event> comp) {
      return new EventSetImpl(comp);
    }

    @Override
    public EventSet value() {
        return this;
    }

    @Override
    public List<Event> elements() {
        Event[] elements = toArray(new Event[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
