package io.ciera.tool.sql.architecture.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterImpl;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.statemachine.Event;
import io.ciera.tool.sql.architecture.statemachine.StateMachine;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCell;
import io.ciera.tool.sql.architecture.statemachine.TransitionTableCellSet;
import io.ciera.tool.sql.architecture.statemachine.impl.StateMachineImpl;
import io.ciera.tool.sql.architecture.statemachine.impl.TransitionTableCellSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;


public class EventImpl extends ModelInstance<Event,Sql> implements Event {

    public static final String KEY_LETTERS = "Event";
    public static final Event EMPTY_EVENT = new EmptyEvent();

    private Sql context;

    // constructors
    private EventImpl( Sql context ) {
        this.context = context;
        ref_sm_name = "";
        ref_sm_package = "";
        ref_name = "";
        m_id = 0;
        ref_SMevt_ID = UniqueId.random();
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4752_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R4756_TransitionTableCell_set = new TransitionTableCellSetImpl();
        R4759_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

    private EventImpl( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_name, int m_id, UniqueId ref_SMevt_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_sm_name = ref_sm_name;
        this.ref_sm_package = ref_sm_package;
        this.ref_name = ref_name;
        this.m_id = m_id;
        this.ref_SMevt_ID = ref_SMevt_ID;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R4752_StateMachine_inst = StateMachineImpl.EMPTY_STATEMACHINE;
        R4756_TransitionTableCell_set = new TransitionTableCellSetImpl();
        R4759_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

    public static Event create( Sql context ) throws XtumlException {
        Event newEvent = new EventImpl( context );
        if ( context.addInstance( newEvent ) ) {
            newEvent.getRunContext().addChange(new InstanceCreatedDelta(newEvent, KEY_LETTERS));
            return newEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Event create( Sql context, UniqueId instanceId, String ref_sm_name, String ref_sm_package, String ref_name, int m_id, UniqueId ref_SMevt_ID ) throws XtumlException {
        Event newEvent = new EventImpl( context, instanceId, ref_sm_name, ref_sm_package, ref_name, m_id, ref_SMevt_ID );
        if ( context.addInstance( newEvent ) ) {
            return newEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_sm_name;
    @Override
    public String getSm_name() throws XtumlException {
        checkLiving();
                return ref_sm_name;
    }
    @Override
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_sm_name, this.ref_sm_name ) ) {
            final String oldValue = this.ref_sm_name;
            this.ref_sm_name = ref_sm_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_name", oldValue, this.ref_sm_name));
            if ( !R4756_TransitionTableCell().isEmpty() ) R4756_TransitionTableCell().setEvent_sm_name( ref_sm_name );
        }
    }
    private String ref_sm_package;
    @Override
    public String getSm_package() throws XtumlException {
        checkLiving();
                return ref_sm_package;
    }
    @Override
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_sm_package, this.ref_sm_package ) ) {
            final String oldValue = this.ref_sm_package;
            this.ref_sm_package = ref_sm_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_sm_package", oldValue, this.ref_sm_package));
            if ( !R4756_TransitionTableCell().isEmpty() ) R4756_TransitionTableCell().setEvent_sm_package( ref_sm_package );
        }
    }
    private String ref_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
            if ( !R4756_TransitionTableCell().isEmpty() ) R4756_TransitionTableCell().setEvent_name( ref_name );
        }
    }
    private int m_id;
    @Override
    public int getId() throws XtumlException {
        checkLiving();
                return m_id;
    }
    @Override
    public void setId( int m_id ) throws XtumlException {
        checkLiving();
        if ( m_id != this.m_id ) {
            final int oldValue = this.m_id;
            this.m_id = m_id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_id", oldValue, this.m_id));
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
                return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        checkLiving();
        if ( ref_SMevt_ID.inequality( this.ref_SMevt_ID ) ) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSm_name(), getSm_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String parameter_list = invocable.parameter_list();
        String invocation_parameter_list = "";
        FormalParameter parm = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        FormalParameter prev_parm = invocable.R429_declares_signature_with_FormalParameter().any();
        while ( !prev_parm.isEmpty() ) {
            parm = prev_parm;
            prev_parm = parm.R404_follows_FormalParameter();
        }
        String separator = "";
        while ( !parm.isEmpty() ) {
            invocation_parameter_list = ( invocation_parameter_list + separator ) + parm.getName();
            separator = ",  ";
            parm = parm.R404_precedes_FormalParameter();
        }
        ModelInst obj = self().R4752_StateMachine().R4750_models_behavior_of_ModelInst();
        String class_name = obj.getName();
        context().T().include( "statemachine/t.event.java", class_name, invocation_parameter_list, parameter_list, self() );
    }



    // static operations


    // events


    // selections
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }
    private StateMachine R4752_StateMachine_inst;
    @Override
    public void setR4752_StateMachine( StateMachine inst ) {
        R4752_StateMachine_inst = inst;
    }
    @Override
    public StateMachine R4752_StateMachine() throws XtumlException {
        return R4752_StateMachine_inst;
    }
    private TransitionTableCellSet R4756_TransitionTableCell_set;
    @Override
    public void addR4756_TransitionTableCell( TransitionTableCell inst ) {
        R4756_TransitionTableCell_set.add(inst);
    }
    @Override
    public void removeR4756_TransitionTableCell( TransitionTableCell inst ) {
        R4756_TransitionTableCell_set.remove(inst);
    }
    @Override
    public TransitionTableCellSet R4756_TransitionTableCell() throws XtumlException {
        return R4756_TransitionTableCell_set;
    }
    private StateMachineEvent R4759_StateMachineEvent_inst;
    @Override
    public void setR4759_StateMachineEvent( StateMachineEvent inst ) {
        R4759_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R4759_StateMachineEvent() throws XtumlException {
        return R4759_StateMachineEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Event value() {
        return this;
    }

    @Override
    public Event self() {
        return this;
    }

    @Override
    public Event oneWhere( IWhere<Event> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_EVENT;
    }

}

class EmptyEvent extends ModelInstance<Event,Sql> implements Event {

    // attributes
    public String getSm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_name( String ref_sm_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSm_package( String ref_sm_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getId() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId( int m_id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public StateMachine R4752_StateMachine() {
        return StateMachineImpl.EMPTY_STATEMACHINE;
    }
    @Override
    public TransitionTableCellSet R4756_TransitionTableCell() {
        return (new TransitionTableCellSetImpl());
    }
    @Override
    public StateMachineEvent R4759_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }


    @Override
    public String getKeyLetters() {
        return EventImpl.KEY_LETTERS;
    }

    @Override
    public Event value() {
        return this;
    }
    
    @Override
    public Event self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Event oneWhere( IWhere<Event> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return EventImpl.EMPTY_EVENT;
    }

}
