package io.ciera.tool.sql.architecture.relationship.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.AttributeReference;
import io.ciera.tool.sql.architecture.classes.AttributeReferenceSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeReferenceSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionImpl;
import io.ciera.tool.sql.architecture.component.impl.RelationshipPopulationSelectorImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationship;
import io.ciera.tool.sql.architecture.statement.RelateSmt;
import io.ciera.tool.sql.architecture.statement.RelateSmtSet;
import io.ciera.tool.sql.architecture.statement.UnrelateSmt;
import io.ciera.tool.sql.architecture.statement.UnrelateSmtSet;
import io.ciera.tool.sql.architecture.statement.impl.RelateSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.UnrelateSmtSetImpl;

import java.util.Iterator;

import types.AttributeAccessorType;
import types.Cond;
import types.Mult;


public class ClassRelationshipImpl extends ModelInstance<ClassRelationship,Sql> implements ClassRelationship {

    public static final String KEY_LETTERS = "Relationship";
    public static final ClassRelationship EMPTY_CLASSRELATIONSHIP = new EmptyClassRelationship();

    private Sql context;

    // constructors
    private ClassRelationshipImpl( Sql context ) {
        this.context = context;
        ref_comp_name = "";
        ref_comp_package = "";
        m_name = "";
        m_num = 0;
        ref_form_name = "";
        m_form_phrase = "";
        ref_part_name = "";
        m_part_phrase = "";
        ref_form_package = "";
        ref_part_package = "";
        m_form_mult = Mult.UNINITIALIZED_ENUM;
        m_part_mult = Mult.UNINITIALIZED_ENUM;
        m_form_cond = Cond.UNINITIALIZED_ENUM;
        m_part_cond = Cond.UNINITIALIZED_ENUM;
        m_id_num = 0;
        R434_has_participating_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R435_has_formalizing_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R448_forms_relationship_population_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R4511_provides_link_for_AttributeReference_set = new AttributeReferenceSetImpl();
        R4512_traversed_by_Selector_set = new SelectorSetImpl();
        R4572_extent_accessed_by_RelationshipPopulationSelector_inst = RelationshipPopulationSelectorImpl.EMPTY_RELATIONSHIPPOPULATIONSELECTOR;
        R481_created_by_RelateSmt_set = new RelateSmtSetImpl();
        R484_deleted_by_UnrelateSmt_set = new UnrelateSmtSetImpl();
    }

    private ClassRelationshipImpl( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String m_name, int m_num, String ref_form_name, String m_form_phrase, String ref_part_name, String m_part_phrase, String ref_form_package, String ref_part_package, Mult m_form_mult, Mult m_part_mult, Cond m_form_cond, Cond m_part_cond, int m_id_num ) {
        super(instanceId);
        this.context = context;
        this.ref_comp_name = ref_comp_name;
        this.ref_comp_package = ref_comp_package;
        this.m_name = m_name;
        this.m_num = m_num;
        this.ref_form_name = ref_form_name;
        this.m_form_phrase = m_form_phrase;
        this.ref_part_name = ref_part_name;
        this.m_part_phrase = m_part_phrase;
        this.ref_form_package = ref_form_package;
        this.ref_part_package = ref_part_package;
        this.m_form_mult = m_form_mult;
        this.m_part_mult = m_part_mult;
        this.m_form_cond = m_form_cond;
        this.m_part_cond = m_part_cond;
        this.m_id_num = m_id_num;
        R434_has_participating_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R435_has_formalizing_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R448_forms_relationship_population_of_ComponentDefinition_inst = ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
        R4511_provides_link_for_AttributeReference_set = new AttributeReferenceSetImpl();
        R4512_traversed_by_Selector_set = new SelectorSetImpl();
        R4572_extent_accessed_by_RelationshipPopulationSelector_inst = RelationshipPopulationSelectorImpl.EMPTY_RELATIONSHIPPOPULATIONSELECTOR;
        R481_created_by_RelateSmt_set = new RelateSmtSetImpl();
        R484_deleted_by_UnrelateSmt_set = new UnrelateSmtSetImpl();
    }

    public static ClassRelationship create( Sql context ) throws XtumlException {
        ClassRelationship newClassRelationship = new ClassRelationshipImpl( context );
        if ( context.addInstance( newClassRelationship ) ) {
            newClassRelationship.getRunContext().addChange(new InstanceCreatedDelta(newClassRelationship, KEY_LETTERS));
            return newClassRelationship;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassRelationship create( Sql context, UniqueId instanceId, String ref_comp_name, String ref_comp_package, String m_name, int m_num, String ref_form_name, String m_form_phrase, String ref_part_name, String m_part_phrase, String ref_form_package, String ref_part_package, Mult m_form_mult, Mult m_part_mult, Cond m_form_cond, Cond m_part_cond, int m_id_num ) throws XtumlException {
        ClassRelationship newClassRelationship = new ClassRelationshipImpl( context, instanceId, ref_comp_name, ref_comp_package, m_name, m_num, ref_form_name, m_form_phrase, ref_part_name, m_part_phrase, ref_form_package, ref_part_package, m_form_mult, m_part_mult, m_form_cond, m_part_cond, m_id_num );
        if ( context.addInstance( newClassRelationship ) ) {
            return newClassRelationship;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_comp_name;
    @Override
    public String getComp_name() throws XtumlException {
        checkLiving();
                return ref_comp_name;
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_name, this.ref_comp_name ) ) {
            final String oldValue = this.ref_comp_name;
            this.ref_comp_name = ref_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_name", oldValue, this.ref_comp_name));
            if ( !R4572_extent_accessed_by_RelationshipPopulationSelector().isEmpty() ) R4572_extent_accessed_by_RelationshipPopulationSelector().setComp_name( ref_comp_name );
            if ( !R484_deleted_by_UnrelateSmt().isEmpty() ) R484_deleted_by_UnrelateSmt().setComp_name( ref_comp_name );
            if ( !R481_created_by_RelateSmt().isEmpty() ) R481_created_by_RelateSmt().setComp_name( ref_comp_name );
            if ( !R4512_traversed_by_Selector().isEmpty() ) R4512_traversed_by_Selector().setRel_comp_name( ref_comp_name );
        }
    }
    private String ref_comp_package;
    @Override
    public String getComp_package() throws XtumlException {
        checkLiving();
                return ref_comp_package;
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_comp_package, this.ref_comp_package ) ) {
            final String oldValue = this.ref_comp_package;
            this.ref_comp_package = ref_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_comp_package", oldValue, this.ref_comp_package));
            if ( !R4572_extent_accessed_by_RelationshipPopulationSelector().isEmpty() ) R4572_extent_accessed_by_RelationshipPopulationSelector().setComp_package( ref_comp_package );
            if ( !R484_deleted_by_UnrelateSmt().isEmpty() ) R484_deleted_by_UnrelateSmt().setComp_package( ref_comp_package );
            if ( !R481_created_by_RelateSmt().isEmpty() ) R481_created_by_RelateSmt().setComp_package( ref_comp_package );
            if ( !R4512_traversed_by_Selector().isEmpty() ) R4512_traversed_by_Selector().setRel_comp_package( ref_comp_package );
        }
    }
    private String m_name;
    @Override
    public void setName( String m_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_name, this.m_name ) ) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R4512_traversed_by_Selector().isEmpty() ) R4512_traversed_by_Selector().setRel_name( m_name );
            if ( !R4572_extent_accessed_by_RelationshipPopulationSelector().isEmpty() ) R4572_extent_accessed_by_RelationshipPopulationSelector().setRel_name( m_name );
            if ( !R481_created_by_RelateSmt().isEmpty() ) R481_created_by_RelateSmt().setRel_name( m_name );
            if ( !R484_deleted_by_UnrelateSmt().isEmpty() ) R484_deleted_by_UnrelateSmt().setRel_name( m_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_name;
    }
    private int m_num;
    @Override
    public void setNum( int m_num ) throws XtumlException {
        checkLiving();
        if ( m_num != this.m_num ) {
            final int oldValue = this.m_num;
            this.m_num = m_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_num", oldValue, this.m_num));
            if ( !R4511_provides_link_for_AttributeReference().isEmpty() ) R4511_provides_link_for_AttributeReference().setRel_num( m_num );
        }
    }
    @Override
    public int getNum() throws XtumlException {
        checkLiving();
                return m_num;
    }
    private String ref_form_name;
    @Override
    public void setForm_name( String ref_form_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_form_name, this.ref_form_name ) ) {
            final String oldValue = this.ref_form_name;
            this.ref_form_name = ref_form_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_form_name", oldValue, this.ref_form_name));
            if ( !R4511_provides_link_for_AttributeReference().isEmpty() ) R4511_provides_link_for_AttributeReference().setForm_name( ref_form_name );
        }
    }
    @Override
    public String getForm_name() throws XtumlException {
        checkLiving();
                return ref_form_name;
    }
    private String m_form_phrase;
    @Override
    public String getForm_phrase() throws XtumlException {
        checkLiving();
                return m_form_phrase;
    }
    @Override
    public void setForm_phrase( String m_form_phrase ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_form_phrase, this.m_form_phrase ) ) {
            final String oldValue = this.m_form_phrase;
            this.m_form_phrase = m_form_phrase;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_form_phrase", oldValue, this.m_form_phrase));
            if ( !R4511_provides_link_for_AttributeReference().isEmpty() ) R4511_provides_link_for_AttributeReference().setForm_phrase( m_form_phrase );
        }
    }
    private String ref_part_name;
    @Override
    public String getPart_name() throws XtumlException {
        checkLiving();
                return ref_part_name;
    }
    @Override
    public void setPart_name( String ref_part_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_part_name, this.ref_part_name ) ) {
            final String oldValue = this.ref_part_name;
            this.ref_part_name = ref_part_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_part_name", oldValue, this.ref_part_name));
            if ( !R4511_provides_link_for_AttributeReference().isEmpty() ) R4511_provides_link_for_AttributeReference().setPart_name( ref_part_name );
        }
    }
    private String m_part_phrase;
    @Override
    public void setPart_phrase( String m_part_phrase ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_part_phrase, this.m_part_phrase ) ) {
            final String oldValue = this.m_part_phrase;
            this.m_part_phrase = m_part_phrase;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_part_phrase", oldValue, this.m_part_phrase));
            if ( !R4511_provides_link_for_AttributeReference().isEmpty() ) R4511_provides_link_for_AttributeReference().setPart_phrase( m_part_phrase );
        }
    }
    @Override
    public String getPart_phrase() throws XtumlException {
        checkLiving();
                return m_part_phrase;
    }
    private String ref_form_package;
    @Override
    public String getForm_package() throws XtumlException {
        checkLiving();
                return ref_form_package;
    }
    @Override
    public void setForm_package( String ref_form_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_form_package, this.ref_form_package ) ) {
            final String oldValue = this.ref_form_package;
            this.ref_form_package = ref_form_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_form_package", oldValue, this.ref_form_package));
        }
    }
    private String ref_part_package;
    @Override
    public void setPart_package( String ref_part_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_part_package, this.ref_part_package ) ) {
            final String oldValue = this.ref_part_package;
            this.ref_part_package = ref_part_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_part_package", oldValue, this.ref_part_package));
        }
    }
    @Override
    public String getPart_package() throws XtumlException {
        checkLiving();
                return ref_part_package;
    }
    private Mult m_form_mult;
    @Override
    public Mult getForm_mult() throws XtumlException {
        checkLiving();
                return m_form_mult;
    }
    @Override
    public void setForm_mult( Mult m_form_mult ) throws XtumlException {
        checkLiving();
        if ( m_form_mult.inequality( this.m_form_mult ) ) {
            final Mult oldValue = this.m_form_mult;
            this.m_form_mult = m_form_mult;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_form_mult", oldValue, this.m_form_mult));
        }
    }
    private Mult m_part_mult;
    @Override
    public Mult getPart_mult() throws XtumlException {
        checkLiving();
                return m_part_mult;
    }
    @Override
    public void setPart_mult( Mult m_part_mult ) throws XtumlException {
        checkLiving();
        if ( m_part_mult.inequality( this.m_part_mult ) ) {
            final Mult oldValue = this.m_part_mult;
            this.m_part_mult = m_part_mult;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_part_mult", oldValue, this.m_part_mult));
        }
    }
    private Cond m_form_cond;
    @Override
    public Cond getForm_cond() throws XtumlException {
        checkLiving();
                return m_form_cond;
    }
    @Override
    public void setForm_cond( Cond m_form_cond ) throws XtumlException {
        checkLiving();
        if ( m_form_cond.inequality( this.m_form_cond ) ) {
            final Cond oldValue = this.m_form_cond;
            this.m_form_cond = m_form_cond;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_form_cond", oldValue, this.m_form_cond));
        }
    }
    private Cond m_part_cond;
    @Override
    public void setPart_cond( Cond m_part_cond ) throws XtumlException {
        checkLiving();
        if ( m_part_cond.inequality( this.m_part_cond ) ) {
            final Cond oldValue = this.m_part_cond;
            this.m_part_cond = m_part_cond;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_part_cond", oldValue, this.m_part_cond));
        }
    }
    @Override
    public Cond getPart_cond() throws XtumlException {
        checkLiving();
                return m_part_cond;
    }
    private int m_id_num;
    @Override
    public void setId_num( int m_id_num ) throws XtumlException {
        checkLiving();
        if ( m_id_num != this.m_id_num ) {
            final int oldValue = this.m_id_num;
            this.m_id_num = m_id_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_id_num", oldValue, this.m_id_num));
        }
    }
    @Override
    public int getId_num() throws XtumlException {
        checkLiving();
                return m_id_num;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComp_name(), getComp_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getNum(), getForm_name(), getForm_phrase(), getPart_name(), getPart_phrase());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render_modifiers() throws XtumlException {
        String cardinality_check = "        // TODO cardinality check\n";
        context().T().push_buffer();
        String attribute_propagations = "";
        AttributeReferenceSet refs = self().R434_has_participating_ModelInst().R410_data_abstracted_by_Attribute().R4506_provides_value_for_AttributeReference().where(selected -> ( ( ( selected.getRel_num() == self().getNum() && StringUtil.equality( selected.getForm_phrase(), self().getForm_phrase() ) ) && StringUtil.equality( selected.getForm_name(), self().getForm_name() ) ) && StringUtil.equality( selected.getPart_phrase(), self().getPart_phrase() ) ) && StringUtil.equality( selected.getPart_name(), self().getPart_name() ));
        AttributeReference ref;
        for ( Iterator<AttributeReference> _ref_iter = refs.elements().iterator(); _ref_iter.hasNext(); ) {
            ref = _ref_iter.next();
            AttributeAccessor form_accessor = ref.R4506_provides_value_for_Attribute().R4510_value_accessed_through_AttributeAccessor().anyWhere(selected -> selected.getAccessor_type().equality( AttributeAccessorType.SETTER ));
            String form_accessor_name = form_accessor.getName();
            AttributeAccessor part_accessor = ref.R4506_has_value_provided_by_Attribute().R4510_value_accessed_through_AttributeAccessor().anyWhere(selected -> selected.getAccessor_type().equality( AttributeAccessorType.GETTER ));
            String part_accessor_name = part_accessor.getName();
            context().T().include( "relationship/t.referentialattributeinitialization.java", form_accessor_name, part_accessor_name );
        }
        attribute_propagations = context().T().body();
        context().T().clear();
        String relationship_setters = "";
        String relationship_unsetters = "";
        ModelInst form = self().R434_has_participating_ModelInst();
        ModelInst part = self().R435_has_formalizing_ModelInst();
        String form_name = ( "R" + context().STRING().itoa( self().getNum() ) ) + "_";
        if ( StringUtil.inequality( "", self().getForm_phrase() ) ) {
            form_name = ( form_name + context().T().sub( "_", self().getForm_phrase() ) ) + "_";
        }
        form_name = form_name + part.getName();
        String part_name = ( "R" + context().STRING().itoa( self().getNum() ) ) + "_";
        if ( StringUtil.inequality( "", self().getPart_phrase() ) ) {
            part_name = ( part_name + context().T().sub( "_", self().getPart_phrase() ) ) + "_";
        }
        part_name = part_name + form.getName();
        final String _final0_form_name = form_name;
        Selector form_selector = form.R442_selects_instances_through_InstanceSelector().R445_is_a_Selector().anyWhere(selected -> StringUtil.equality( selected.getName(), _final0_form_name ));
        final String _final0_part_name = part_name;
        Selector part_selector = part.R442_selects_instances_through_InstanceSelector().R445_is_a_Selector().anyWhere(selected -> StringUtil.equality( selected.getName(), _final0_part_name ));
        if ( form_selector.getMultiplicity().equality( Mult.MANY ) ) {
            relationship_setters = ( ( relationship_setters + "            part.add" ) + form_selector.getName() ) + "(form);\n";
            relationship_unsetters = ( ( relationship_unsetters + "            part.remove" ) + form_selector.getName() ) + "(form);\n";
        }
        else {
            relationship_setters = ( ( relationship_setters + "            part.set" ) + form_selector.getName() ) + "(form);\n";
            relationship_unsetters = ( ( ( ( ( ( relationship_unsetters + "            part.set" ) + form_selector.getName() ) + "(" ) + form_selector.getType_reference_name() ) + "Impl.EMPTY_" ) + context().T().sub( "u_", form_selector.getType_reference_name() ) ) + ");\n";
        }
        if ( part_selector.getMultiplicity().equality( Mult.MANY ) ) {
            relationship_setters = ( ( relationship_setters + "            form.add" ) + part_selector.getName() ) + "(part);\n";
            relationship_unsetters = ( ( relationship_unsetters + "            form.remove" ) + part_selector.getName() ) + "(part);\n";
        }
        else {
            relationship_setters = ( ( relationship_setters + "            form.set" ) + part_selector.getName() ) + "(part);\n";
            relationship_unsetters = ( ( ( ( ( ( relationship_unsetters + "            form.set" ) + part_selector.getName() ) + "(" ) + part_selector.getType_reference_name() ) + "Impl.EMPTY_" ) + context().T().sub( "u_", part_selector.getType_reference_name() ) ) + ");\n";
        }
        context().T().pop_buffer();
        context().T().include( "relationship/t.relationshipmodifiers.java", attribute_propagations, cardinality_check, relationship_setters, relationship_unsetters, self() );
    }



    // static operations


    // events


    // selections
    private ModelInst R434_has_participating_ModelInst_inst;
    @Override
    public void setR434_has_participating_ModelInst( ModelInst inst ) {
        R434_has_participating_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R434_has_participating_ModelInst() throws XtumlException {
        return R434_has_participating_ModelInst_inst;
    }
    private ModelInst R435_has_formalizing_ModelInst_inst;
    @Override
    public void setR435_has_formalizing_ModelInst( ModelInst inst ) {
        R435_has_formalizing_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R435_has_formalizing_ModelInst() throws XtumlException {
        return R435_has_formalizing_ModelInst_inst;
    }
    private ComponentDefinition R448_forms_relationship_population_of_ComponentDefinition_inst;
    @Override
    public void setR448_forms_relationship_population_of_ComponentDefinition( ComponentDefinition inst ) {
        R448_forms_relationship_population_of_ComponentDefinition_inst = inst;
    }
    @Override
    public ComponentDefinition R448_forms_relationship_population_of_ComponentDefinition() throws XtumlException {
        return R448_forms_relationship_population_of_ComponentDefinition_inst;
    }
    private AttributeReferenceSet R4511_provides_link_for_AttributeReference_set;
    @Override
    public void addR4511_provides_link_for_AttributeReference( AttributeReference inst ) {
        R4511_provides_link_for_AttributeReference_set.add(inst);
    }
    @Override
    public void removeR4511_provides_link_for_AttributeReference( AttributeReference inst ) {
        R4511_provides_link_for_AttributeReference_set.remove(inst);
    }
    @Override
    public AttributeReferenceSet R4511_provides_link_for_AttributeReference() throws XtumlException {
        return R4511_provides_link_for_AttributeReference_set;
    }
    private SelectorSet R4512_traversed_by_Selector_set;
    @Override
    public void addR4512_traversed_by_Selector( Selector inst ) {
        R4512_traversed_by_Selector_set.add(inst);
    }
    @Override
    public void removeR4512_traversed_by_Selector( Selector inst ) {
        R4512_traversed_by_Selector_set.remove(inst);
    }
    @Override
    public SelectorSet R4512_traversed_by_Selector() throws XtumlException {
        return R4512_traversed_by_Selector_set;
    }
    private RelationshipPopulationSelector R4572_extent_accessed_by_RelationshipPopulationSelector_inst;
    @Override
    public void setR4572_extent_accessed_by_RelationshipPopulationSelector( RelationshipPopulationSelector inst ) {
        R4572_extent_accessed_by_RelationshipPopulationSelector_inst = inst;
    }
    @Override
    public RelationshipPopulationSelector R4572_extent_accessed_by_RelationshipPopulationSelector() throws XtumlException {
        return R4572_extent_accessed_by_RelationshipPopulationSelector_inst;
    }
    private RelateSmtSet R481_created_by_RelateSmt_set;
    @Override
    public void addR481_created_by_RelateSmt( RelateSmt inst ) {
        R481_created_by_RelateSmt_set.add(inst);
    }
    @Override
    public void removeR481_created_by_RelateSmt( RelateSmt inst ) {
        R481_created_by_RelateSmt_set.remove(inst);
    }
    @Override
    public RelateSmtSet R481_created_by_RelateSmt() throws XtumlException {
        return R481_created_by_RelateSmt_set;
    }
    private UnrelateSmtSet R484_deleted_by_UnrelateSmt_set;
    @Override
    public void addR484_deleted_by_UnrelateSmt( UnrelateSmt inst ) {
        R484_deleted_by_UnrelateSmt_set.add(inst);
    }
    @Override
    public void removeR484_deleted_by_UnrelateSmt( UnrelateSmt inst ) {
        R484_deleted_by_UnrelateSmt_set.remove(inst);
    }
    @Override
    public UnrelateSmtSet R484_deleted_by_UnrelateSmt() throws XtumlException {
        return R484_deleted_by_UnrelateSmt_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassRelationship value() {
        return this;
    }

    @Override
    public ClassRelationship self() {
        return this;
    }

    @Override
    public ClassRelationship oneWhere( IWhere<ClassRelationship> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_CLASSRELATIONSHIP;
    }

}

class EmptyClassRelationship extends ModelInstance<ClassRelationship,Sql> implements ClassRelationship {

    // attributes
    public String getComp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getComp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNum( int m_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNum() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_name( String ref_form_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getForm_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getForm_phrase() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_phrase( String m_form_phrase ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_name( String ref_part_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPart_phrase( String m_part_phrase ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_phrase() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getForm_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_package( String ref_form_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPart_package( String ref_part_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPart_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public Mult getForm_mult() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_mult( Mult m_form_mult ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public Mult getPart_mult() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_mult( Mult m_part_mult ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public Cond getForm_cond() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setForm_cond( Cond m_form_cond ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPart_cond( Cond m_part_cond ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public Cond getPart_cond() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setId_num( int m_id_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getId_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render_modifiers() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public ModelInst R434_has_participating_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public ModelInst R435_has_formalizing_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public ComponentDefinition R448_forms_relationship_population_of_ComponentDefinition() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }
    @Override
    public AttributeReferenceSet R4511_provides_link_for_AttributeReference() {
        return (new AttributeReferenceSetImpl());
    }
    @Override
    public SelectorSet R4512_traversed_by_Selector() {
        return (new SelectorSetImpl());
    }
    @Override
    public RelationshipPopulationSelector R4572_extent_accessed_by_RelationshipPopulationSelector() {
        return RelationshipPopulationSelectorImpl.EMPTY_RELATIONSHIPPOPULATIONSELECTOR;
    }
    @Override
    public RelateSmtSet R481_created_by_RelateSmt() {
        return (new RelateSmtSetImpl());
    }
    @Override
    public UnrelateSmtSet R484_deleted_by_UnrelateSmt() {
        return (new UnrelateSmtSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ClassRelationshipImpl.KEY_LETTERS;
    }

    @Override
    public ClassRelationship value() {
        return this;
    }
    
    @Override
    public ClassRelationship self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassRelationship oneWhere( IWhere<ClassRelationship> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ClassRelationshipImpl.EMPTY_CLASSRELATIONSHIP;
    }

}
