package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.TypeImportReference;
import io.ciera.tool.sql.architecture.file.TypeImportReferenceSet;
import io.ciera.tool.sql.architecture.file.TypeImportSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.file.impl.TypeImportSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import types.ImportType;


public class TypeImportReferenceSetImpl extends InstanceSet<TypeImportReferenceSet,TypeImportReference> implements TypeImportReferenceSet {

    public TypeImportReferenceSetImpl() {
    }

    public TypeImportReferenceSetImpl(Comparator<? super TypeImportReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setFile_name( String ref_file_name ) throws XtumlException {
        for ( TypeImportReference typeimportreference : this ) typeimportreference.setFile_name( ref_file_name );
    }
    @Override
    public void setFile_package( String ref_file_package ) throws XtumlException {
        for ( TypeImportReference typeimportreference : this ) typeimportreference.setFile_package( ref_file_package );
    }
    @Override
    public void setFully_qualified_name( String ref_fully_qualified_name ) throws XtumlException {
        for ( TypeImportReference typeimportreference : this ) typeimportreference.setFully_qualified_name( ref_fully_qualified_name );
    }
    @Override
    public void setType( ImportType m_type ) throws XtumlException {
        for ( TypeImportReference typeimportreference : this ) typeimportreference.setType( m_type );
    }


    // selections
    @Override
    public FileSet R402_imports_type_into_context_of_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( TypeImportReference typeimportreference : this ) fileset.add( typeimportreference.R402_imports_type_into_context_of_File() );
        return fileset;
    }
    @Override
    public TypeImportSet R402_imports_type_via_TypeImport() throws XtumlException {
        TypeImportSet typeimportset = new TypeImportSetImpl();
        for ( TypeImportReference typeimportreference : this ) typeimportset.add( typeimportreference.R402_imports_type_via_TypeImport() );
        return typeimportset;
    }


    @Override
    public TypeImportReference nullElement() {
        return TypeImportReferenceImpl.EMPTY_TYPEIMPORTREFERENCE;
    }

    @Override
    public TypeImportReferenceSet emptySet() {
      return new TypeImportReferenceSetImpl();
    }

    @Override
    public TypeImportReferenceSet emptySet(Comparator<? super TypeImportReference> comp) {
      return new TypeImportReferenceSetImpl(comp);
    }

    @Override
    public TypeImportReferenceSet value() {
        return this;
    }

    @Override
    public List<TypeImportReference> elements() {
        return Arrays.asList(toArray(new TypeImportReference[0]));
    }

}
