package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.Select;
import io.ciera.tool.sql.architecture.expression.SelectFromInstancesSet;
import io.ciera.tool.sql.architecture.expression.SelectRelatedSet;
import io.ciera.tool.sql.architecture.expression.SelectSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.SelectFromInstancesSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.SelectRelatedSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class SelectSetImpl extends InstanceSet<SelectSet,Select> implements SelectSet {

    public SelectSetImpl() {
    }

    public SelectSetImpl(Comparator<? super Select> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Select select : this ) select.setParent_name( ref_parent_name );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( Select select : this ) select.setExpression_number( ref_expression_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Select select : this ) select.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Select select : this ) select.setBlock_number( ref_block_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Select select : this ) select.setParent_package( ref_parent_package );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Select select : this ) select.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Select select : this ) expressionset.add( select.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public SelectFromInstancesSet R789_is_a_SelectFromInstances() throws XtumlException {
        SelectFromInstancesSet selectfrominstancesset = new SelectFromInstancesSetImpl();
        for ( Select select : this ) selectfrominstancesset.add( select.R789_is_a_SelectFromInstances() );
        return selectfrominstancesset;
    }
    @Override
    public SelectRelatedSet R789_is_a_SelectRelated() throws XtumlException {
        SelectRelatedSet selectrelatedset = new SelectRelatedSetImpl();
        for ( Select select : this ) selectrelatedset.add( select.R789_is_a_SelectRelated() );
        return selectrelatedset;
    }


    @Override
    public Select nullElement() {
        return SelectImpl.EMPTY_SELECT;
    }

    @Override
    public SelectSet emptySet() {
      return new SelectSetImpl();
    }

    @Override
    public SelectSet emptySet(Comparator<? super Select> comp) {
      return new SelectSetImpl(comp);
    }

    @Override
    public SelectSet value() {
        return this;
    }

    @Override
    public List<Select> elements() {
        return Arrays.asList(toArray(new Select[0]));
    }

}
