package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelector;
import io.ciera.tool.sql.architecture.component.impl.InstancePopulationSelectorImpl;
import io.ciera.tool.sql.architecture.expression.Select;
import io.ciera.tool.sql.architecture.expression.SelectFromInstances;
import io.ciera.tool.sql.architecture.expression.impl.SelectImpl;


public class SelectFromInstancesImpl extends ModelInstance<SelectFromInstances,Sql> implements SelectFromInstances {

    public static final String KEY_LETTERS = "SelectFromInstances";
    public static final SelectFromInstances EMPTY_SELECTFROMINSTANCES = new EmptySelectFromInstances();

    private Sql context;

    // constructors
    private SelectFromInstancesImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_expression_number = "";
        ref_selector_comp_name = "";
        ref_selector_comp_package = "";
        ref_selector_name = "";
        R789_is_a_Select_inst = SelectImpl.EMPTY_SELECT;
        R799_selects_instances_through_InstancePopulationSelector_inst = InstancePopulationSelectorImpl.EMPTY_INSTANCEPOPULATIONSELECTOR;
    }

    private SelectFromInstancesImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_selector_comp_name, String ref_selector_comp_package, String ref_selector_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_expression_number = ref_expression_number;
        this.ref_selector_comp_name = ref_selector_comp_name;
        this.ref_selector_comp_package = ref_selector_comp_package;
        this.ref_selector_name = ref_selector_name;
        R789_is_a_Select_inst = SelectImpl.EMPTY_SELECT;
        R799_selects_instances_through_InstancePopulationSelector_inst = InstancePopulationSelectorImpl.EMPTY_INSTANCEPOPULATIONSELECTOR;
    }

    public static SelectFromInstances create( Sql context ) throws XtumlException {
        SelectFromInstances newSelectFromInstances = new SelectFromInstancesImpl( context );
        if ( context.addInstance( newSelectFromInstances ) ) {
            newSelectFromInstances.getRunContext().addChange(new InstanceCreatedDelta(newSelectFromInstances, KEY_LETTERS));
            return newSelectFromInstances;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SelectFromInstances create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_expression_number, String ref_selector_comp_name, String ref_selector_comp_package, String ref_selector_name ) throws XtumlException {
        SelectFromInstances newSelectFromInstances = new SelectFromInstancesImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_expression_number, ref_selector_comp_name, ref_selector_comp_package, ref_selector_name );
        if ( context.addInstance( newSelectFromInstances ) ) {
            return newSelectFromInstances;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_name, this.ref_parent_name ) ) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
                return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_parent_package, this.ref_parent_package ) ) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
                return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_body_name, this.ref_body_name ) ) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
                return ref_body_name;
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
                return ref_block_number;
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_block_number, this.ref_block_number ) ) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
                return ref_statement_number;
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_statement_number, this.ref_statement_number ) ) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    private String ref_expression_number;
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_expression_number, this.ref_expression_number ) ) {
            final String oldValue = this.ref_expression_number;
            this.ref_expression_number = ref_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_expression_number", oldValue, this.ref_expression_number));
        }
    }
    @Override
    public String getExpression_number() throws XtumlException {
        checkLiving();
                return ref_expression_number;
    }
    private String ref_selector_comp_name;
    @Override
    public String getSelector_comp_name() throws XtumlException {
        checkLiving();
                return ref_selector_comp_name;
    }
    @Override
    public void setSelector_comp_name( String ref_selector_comp_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_selector_comp_name, this.ref_selector_comp_name ) ) {
            final String oldValue = this.ref_selector_comp_name;
            this.ref_selector_comp_name = ref_selector_comp_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_comp_name", oldValue, this.ref_selector_comp_name));
        }
    }
    private String ref_selector_comp_package;
    @Override
    public String getSelector_comp_package() throws XtumlException {
        checkLiving();
                return ref_selector_comp_package;
    }
    @Override
    public void setSelector_comp_package( String ref_selector_comp_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_selector_comp_package, this.ref_selector_comp_package ) ) {
            final String oldValue = this.ref_selector_comp_package;
            this.ref_selector_comp_package = ref_selector_comp_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_comp_package", oldValue, this.ref_selector_comp_package));
        }
    }
    private String ref_selector_name;
    @Override
    public void setSelector_name( String ref_selector_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_selector_name, this.ref_selector_name ) ) {
            final String oldValue = this.ref_selector_name;
            this.ref_selector_name = ref_selector_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_name", oldValue, this.ref_selector_name));
        }
    }
    @Override
    public String getSelector_name() throws XtumlException {
        checkLiving();
                return ref_selector_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number(), getExpression_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "expression/t.selectfrominstances.java", self() );
    }



    // static operations


    // events


    // selections
    private Select R789_is_a_Select_inst;
    @Override
    public void setR789_is_a_Select( Select inst ) {
        R789_is_a_Select_inst = inst;
    }
    @Override
    public Select R789_is_a_Select() throws XtumlException {
        return R789_is_a_Select_inst;
    }
    private InstancePopulationSelector R799_selects_instances_through_InstancePopulationSelector_inst;
    @Override
    public void setR799_selects_instances_through_InstancePopulationSelector( InstancePopulationSelector inst ) {
        R799_selects_instances_through_InstancePopulationSelector_inst = inst;
    }
    @Override
    public InstancePopulationSelector R799_selects_instances_through_InstancePopulationSelector() throws XtumlException {
        return R799_selects_instances_through_InstancePopulationSelector_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SelectFromInstances value() {
        return this;
    }

    @Override
    public SelectFromInstances self() {
        return this;
    }

    @Override
    public SelectFromInstances oneWhere( IWhere<SelectFromInstances> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_SELECTFROMINSTANCES;
    }

}

class EmptySelectFromInstances extends ModelInstance<SelectFromInstances,Sql> implements SelectFromInstances {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getExpression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSelector_comp_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSelector_comp_name( String ref_selector_comp_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSelector_comp_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSelector_comp_package( String ref_selector_comp_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSelector_name( String ref_selector_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSelector_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Select R789_is_a_Select() {
        return SelectImpl.EMPTY_SELECT;
    }
    @Override
    public InstancePopulationSelector R799_selects_instances_through_InstancePopulationSelector() {
        return InstancePopulationSelectorImpl.EMPTY_INSTANCEPOPULATIONSELECTOR;
    }


    @Override
    public String getKeyLetters() {
        return SelectFromInstancesImpl.KEY_LETTERS;
    }

    @Override
    public SelectFromInstances value() {
        return this;
    }
    
    @Override
    public SelectFromInstances self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SelectFromInstances oneWhere( IWhere<SelectFromInstances> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return SelectFromInstancesImpl.EMPTY_SELECTFROMINSTANCES;
    }

}
