package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ActualParameterSet;
import io.ciera.tool.sql.architecture.expression.AnySet;
import io.ciera.tool.sql.architecture.expression.ArrayElementReferenceSet;
import io.ciera.tool.sql.architecture.expression.ArrayLengthAccessSet;
import io.ciera.tool.sql.architecture.expression.AttributeAccessSet;
import io.ciera.tool.sql.architecture.expression.BinaryOperationSet;
import io.ciera.tool.sql.architecture.expression.ConstantReferenceSet;
import io.ciera.tool.sql.architecture.expression.CreationSet;
import io.ciera.tool.sql.architecture.expression.EnumeratorReferenceSet;
import io.ciera.tool.sql.architecture.expression.EventCreationSet;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.InvocationSet;
import io.ciera.tool.sql.architecture.expression.LiteralSet;
import io.ciera.tool.sql.architecture.expression.MemberReferenceSet;
import io.ciera.tool.sql.architecture.expression.NamedReferenceSet;
import io.ciera.tool.sql.architecture.expression.ParameterReferenceSet;
import io.ciera.tool.sql.architecture.expression.ParenthesizedExpressionSet;
import io.ciera.tool.sql.architecture.expression.SelectRelatedSet;
import io.ciera.tool.sql.architecture.expression.SelectSet;
import io.ciera.tool.sql.architecture.expression.SelectedSet;
import io.ciera.tool.sql.architecture.expression.UnaryOperationSet;
import io.ciera.tool.sql.architecture.expression.VariableReferenceSet;
import io.ciera.tool.sql.architecture.expression.WhereSet;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.AnySetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ArrayElementReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ArrayLengthAccessSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.AttributeAccessSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.BinaryOperationSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ConstantReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.CreationSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.EnumeratorReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.EventCreationSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.InvocationSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.LiteralSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.MemberReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.NamedReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ParameterReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ParenthesizedExpressionSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.SelectRelatedSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.SelectSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.SelectedSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.UnaryOperationSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.VariableReferenceSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.WhereSetImpl;
import io.ciera.tool.sql.architecture.statement.DeleteSmtSet;
import io.ciera.tool.sql.architecture.statement.ExpressionAsStatementSet;
import io.ciera.tool.sql.architecture.statement.ForSmtSet;
import io.ciera.tool.sql.architecture.statement.GenerateSet;
import io.ciera.tool.sql.architecture.statement.IfSmtSet;
import io.ciera.tool.sql.architecture.statement.RelateSmtSet;
import io.ciera.tool.sql.architecture.statement.ReturnSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.UnrelateSmtSet;
import io.ciera.tool.sql.architecture.statement.WhileSmtSet;
import io.ciera.tool.sql.architecture.statement.impl.DeleteSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ExpressionAsStatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ForSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.GenerateSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.IfSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.RelateSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ReturnSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.UnrelateSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.WhileSmtSetImpl;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ExpressionSetImpl extends InstanceSet<ExpressionSet,Expression> implements ExpressionSet {

    public ExpressionSetImpl() {
    }

    public ExpressionSetImpl(Comparator<? super Expression> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setType_name( String ref_type_name ) throws XtumlException {
        for ( Expression expression : this ) expression.setType_name( ref_type_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Expression expression : this ) expression.setParent_package( ref_parent_package );
    }
    @Override
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        for ( Expression expression : this ) expression.setType_reference_name( ref_type_reference_name );
    }
    @Override
    public void setType_package( String ref_type_package ) throws XtumlException {
        for ( Expression expression : this ) expression.setType_package( ref_type_package );
    }
    @Override
    public void setExpression_number( String m_expression_number ) throws XtumlException {
        for ( Expression expression : this ) expression.setExpression_number( m_expression_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( Expression expression : this ) expression.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Expression expression : this ) expression.setParent_name( ref_parent_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Expression expression : this ) expression.setBlock_number( ref_block_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Expression expression : this ) expression.setBody_name( ref_body_name );
    }


    // selections
    @Override
    public ArrayElementReferenceSet R3900_is_root_for_ArrayElementReference() throws XtumlException {
        ArrayElementReferenceSet arrayelementreferenceset = new ArrayElementReferenceSetImpl();
        for ( Expression expression : this ) arrayelementreferenceset.add( expression.R3900_is_root_for_ArrayElementReference() );
        return arrayelementreferenceset;
    }
    @Override
    public ArrayElementReferenceSet R3901_is_index_for_ArrayElementReference() throws XtumlException {
        ArrayElementReferenceSet arrayelementreferenceset = new ArrayElementReferenceSetImpl();
        for ( Expression expression : this ) arrayelementreferenceset.add( expression.R3901_is_index_for_ArrayElementReference() );
        return arrayelementreferenceset;
    }
    @Override
    public EventCreationSet R3902_EventCreation() throws XtumlException {
        EventCreationSet eventcreationset = new EventCreationSetImpl();
        for ( Expression expression : this ) eventcreationset.add( expression.R3902_EventCreation() );
        return eventcreationset;
    }
    @Override
    public EventCreationSet R3903_EventCreation() throws XtumlException {
        EventCreationSet eventcreationset = new EventCreationSetImpl();
        for ( Expression expression : this ) eventcreationset.add( expression.R3903_EventCreation() );
        return eventcreationset;
    }
    @Override
    public DeleteSmtSet R462_is_deleted_by_DeleteSmt() throws XtumlException {
        DeleteSmtSet deletesmtset = new DeleteSmtSetImpl();
        for ( Expression expression : this ) deletesmtset.addAll( expression.R462_is_deleted_by_DeleteSmt() );
        return deletesmtset;
    }
    @Override
    public IfSmtSet R471_determines_execution_of_blocks_for_IfSmt() throws XtumlException {
        IfSmtSet ifsmtset = new IfSmtSetImpl();
        for ( Expression expression : this ) ifsmtset.add( expression.R471_determines_execution_of_blocks_for_IfSmt() );
        return ifsmtset;
    }
    @Override
    public WhileSmtSet R472_determines_execution_of_block_for_WhileSmt() throws XtumlException {
        WhileSmtSet whilesmtset = new WhileSmtSetImpl();
        for ( Expression expression : this ) whilesmtset.add( expression.R472_determines_execution_of_block_for_WhileSmt() );
        return whilesmtset;
    }
    @Override
    public ReturnSmtSet R473_defines_return_value_for_ReturnSmt() throws XtumlException {
        ReturnSmtSet returnsmtset = new ReturnSmtSetImpl();
        for ( Expression expression : this ) returnsmtset.add( expression.R473_defines_return_value_for_ReturnSmt() );
        return returnsmtset;
    }
    @Override
    public ExpressionAsStatementSet R476_executed_by_ExpressionAsStatement() throws XtumlException {
        ExpressionAsStatementSet expressionasstatementset = new ExpressionAsStatementSetImpl();
        for ( Expression expression : this ) expressionasstatementset.add( expression.R476_executed_by_ExpressionAsStatement() );
        return expressionasstatementset;
    }
    @Override
    public ForSmtSet R478_is_iterated_by_ForSmt() throws XtumlException {
        ForSmtSet forsmtset = new ForSmtSetImpl();
        for ( Expression expression : this ) forsmtset.add( expression.R478_is_iterated_by_ForSmt() );
        return forsmtset;
    }
    @Override
    public RelateSmtSet R479_related_to_participant_by_RelateSmt() throws XtumlException {
        RelateSmtSet relatesmtset = new RelateSmtSetImpl();
        for ( Expression expression : this ) relatesmtset.add( expression.R479_related_to_participant_by_RelateSmt() );
        return relatesmtset;
    }
    @Override
    public RelateSmtSet R480_related_to_formalizer_by_RelateSmt() throws XtumlException {
        RelateSmtSet relatesmtset = new RelateSmtSetImpl();
        for ( Expression expression : this ) relatesmtset.add( expression.R480_related_to_formalizer_by_RelateSmt() );
        return relatesmtset;
    }
    @Override
    public UnrelateSmtSet R482_unrelated_from_formalizer_by_UnrelateSmt() throws XtumlException {
        UnrelateSmtSet unrelatesmtset = new UnrelateSmtSetImpl();
        for ( Expression expression : this ) unrelatesmtset.add( expression.R482_unrelated_from_formalizer_by_UnrelateSmt() );
        return unrelatesmtset;
    }
    @Override
    public UnrelateSmtSet R483_unrelated_from_participant_by_UnrelateSmt() throws XtumlException {
        UnrelateSmtSet unrelatesmtset = new UnrelateSmtSetImpl();
        for ( Expression expression : this ) unrelatesmtset.add( expression.R483_unrelated_from_participant_by_UnrelateSmt() );
        return unrelatesmtset;
    }
    @Override
    public GenerateSet R486_Generate() throws XtumlException {
        GenerateSet generateset = new GenerateSetImpl();
        for ( Expression expression : this ) generateset.add( expression.R486_Generate() );
        return generateset;
    }
    @Override
    public StatementSet R775_expressed_within_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( Expression expression : this ) statementset.add( expression.R775_expressed_within_Statement() );
        return statementset;
    }
    @Override
    public AnySet R776_is_a_Any() throws XtumlException {
        AnySet anyset = new AnySetImpl();
        for ( Expression expression : this ) anyset.add( expression.R776_is_a_Any() );
        return anyset;
    }
    @Override
    public ArrayElementReferenceSet R776_is_a_ArrayElementReference() throws XtumlException {
        ArrayElementReferenceSet arrayelementreferenceset = new ArrayElementReferenceSetImpl();
        for ( Expression expression : this ) arrayelementreferenceset.add( expression.R776_is_a_ArrayElementReference() );
        return arrayelementreferenceset;
    }
    @Override
    public ArrayLengthAccessSet R776_is_a_ArrayLengthAccess() throws XtumlException {
        ArrayLengthAccessSet arraylengthaccessset = new ArrayLengthAccessSetImpl();
        for ( Expression expression : this ) arraylengthaccessset.add( expression.R776_is_a_ArrayLengthAccess() );
        return arraylengthaccessset;
    }
    @Override
    public AttributeAccessSet R776_is_a_AttributeAccess() throws XtumlException {
        AttributeAccessSet attributeaccessset = new AttributeAccessSetImpl();
        for ( Expression expression : this ) attributeaccessset.add( expression.R776_is_a_AttributeAccess() );
        return attributeaccessset;
    }
    @Override
    public BinaryOperationSet R776_is_a_BinaryOperation() throws XtumlException {
        BinaryOperationSet binaryoperationset = new BinaryOperationSetImpl();
        for ( Expression expression : this ) binaryoperationset.add( expression.R776_is_a_BinaryOperation() );
        return binaryoperationset;
    }
    @Override
    public ConstantReferenceSet R776_is_a_ConstantReference() throws XtumlException {
        ConstantReferenceSet constantreferenceset = new ConstantReferenceSetImpl();
        for ( Expression expression : this ) constantreferenceset.add( expression.R776_is_a_ConstantReference() );
        return constantreferenceset;
    }
    @Override
    public CreationSet R776_is_a_Creation() throws XtumlException {
        CreationSet creationset = new CreationSetImpl();
        for ( Expression expression : this ) creationset.add( expression.R776_is_a_Creation() );
        return creationset;
    }
    @Override
    public EnumeratorReferenceSet R776_is_a_EnumeratorReference() throws XtumlException {
        EnumeratorReferenceSet enumeratorreferenceset = new EnumeratorReferenceSetImpl();
        for ( Expression expression : this ) enumeratorreferenceset.add( expression.R776_is_a_EnumeratorReference() );
        return enumeratorreferenceset;
    }
    @Override
    public EventCreationSet R776_is_a_EventCreation() throws XtumlException {
        EventCreationSet eventcreationset = new EventCreationSetImpl();
        for ( Expression expression : this ) eventcreationset.add( expression.R776_is_a_EventCreation() );
        return eventcreationset;
    }
    @Override
    public InvocationSet R776_is_a_Invocation() throws XtumlException {
        InvocationSet invocationset = new InvocationSetImpl();
        for ( Expression expression : this ) invocationset.add( expression.R776_is_a_Invocation() );
        return invocationset;
    }
    @Override
    public LiteralSet R776_is_a_Literal() throws XtumlException {
        LiteralSet literalset = new LiteralSetImpl();
        for ( Expression expression : this ) literalset.add( expression.R776_is_a_Literal() );
        return literalset;
    }
    @Override
    public MemberReferenceSet R776_is_a_MemberReference() throws XtumlException {
        MemberReferenceSet memberreferenceset = new MemberReferenceSetImpl();
        for ( Expression expression : this ) memberreferenceset.add( expression.R776_is_a_MemberReference() );
        return memberreferenceset;
    }
    @Override
    public NamedReferenceSet R776_is_a_NamedReference() throws XtumlException {
        NamedReferenceSet namedreferenceset = new NamedReferenceSetImpl();
        for ( Expression expression : this ) namedreferenceset.add( expression.R776_is_a_NamedReference() );
        return namedreferenceset;
    }
    @Override
    public ParameterReferenceSet R776_is_a_ParameterReference() throws XtumlException {
        ParameterReferenceSet parameterreferenceset = new ParameterReferenceSetImpl();
        for ( Expression expression : this ) parameterreferenceset.add( expression.R776_is_a_ParameterReference() );
        return parameterreferenceset;
    }
    @Override
    public ParenthesizedExpressionSet R776_is_a_ParenthesizedExpression() throws XtumlException {
        ParenthesizedExpressionSet parenthesizedexpressionset = new ParenthesizedExpressionSetImpl();
        for ( Expression expression : this ) parenthesizedexpressionset.add( expression.R776_is_a_ParenthesizedExpression() );
        return parenthesizedexpressionset;
    }
    @Override
    public SelectSet R776_is_a_Select() throws XtumlException {
        SelectSet selectset = new SelectSetImpl();
        for ( Expression expression : this ) selectset.add( expression.R776_is_a_Select() );
        return selectset;
    }
    @Override
    public SelectedSet R776_is_a_Selected() throws XtumlException {
        SelectedSet selectedset = new SelectedSetImpl();
        for ( Expression expression : this ) selectedset.add( expression.R776_is_a_Selected() );
        return selectedset;
    }
    @Override
    public UnaryOperationSet R776_is_a_UnaryOperation() throws XtumlException {
        UnaryOperationSet unaryoperationset = new UnaryOperationSetImpl();
        for ( Expression expression : this ) unaryoperationset.add( expression.R776_is_a_UnaryOperation() );
        return unaryoperationset;
    }
    @Override
    public VariableReferenceSet R776_is_a_VariableReference() throws XtumlException {
        VariableReferenceSet variablereferenceset = new VariableReferenceSetImpl();
        for ( Expression expression : this ) variablereferenceset.add( expression.R776_is_a_VariableReference() );
        return variablereferenceset;
    }
    @Override
    public WhereSet R776_is_a_Where() throws XtumlException {
        WhereSet whereset = new WhereSetImpl();
        for ( Expression expression : this ) whereset.add( expression.R776_is_a_Where() );
        return whereset;
    }
    @Override
    public UnaryOperationSet R777_is_single_operand_for_UnaryOperation() throws XtumlException {
        UnaryOperationSet unaryoperationset = new UnaryOperationSetImpl();
        for ( Expression expression : this ) unaryoperationset.add( expression.R777_is_single_operand_for_UnaryOperation() );
        return unaryoperationset;
    }
    @Override
    public BinaryOperationSet R778_is_right_operand_for_BinaryOperation() throws XtumlException {
        BinaryOperationSet binaryoperationset = new BinaryOperationSetImpl();
        for ( Expression expression : this ) binaryoperationset.add( expression.R778_is_right_operand_for_BinaryOperation() );
        return binaryoperationset;
    }
    @Override
    public BinaryOperationSet R779_is_left_operand_for_BinaryOperation() throws XtumlException {
        BinaryOperationSet binaryoperationset = new BinaryOperationSetImpl();
        for ( Expression expression : this ) binaryoperationset.add( expression.R779_is_left_operand_for_BinaryOperation() );
        return binaryoperationset;
    }
    @Override
    public AnySet R783_is_basis_for_Any() throws XtumlException {
        AnySet anyset = new AnySetImpl();
        for ( Expression expression : this ) anyset.add( expression.R783_is_basis_for_Any() );
        return anyset;
    }
    @Override
    public ParenthesizedExpressionSet R784_is_wrapped_in_parentheses_by_ParenthesizedExpression() throws XtumlException {
        ParenthesizedExpressionSet parenthesizedexpressionset = new ParenthesizedExpressionSetImpl();
        for ( Expression expression : this ) parenthesizedexpressionset.add( expression.R784_is_wrapped_in_parentheses_by_ParenthesizedExpression() );
        return parenthesizedexpressionset;
    }
    @Override
    public AttributeAccessSet R785_is_used_as_basis_for_AttributeAccess() throws XtumlException {
        AttributeAccessSet attributeaccessset = new AttributeAccessSetImpl();
        for ( Expression expression : this ) attributeaccessset.add( expression.R785_is_used_as_basis_for_AttributeAccess() );
        return attributeaccessset;
    }
    @Override
    public MemberReferenceSet R787_is_used_as_basis_for_MemberReference() throws XtumlException {
        MemberReferenceSet memberreferenceset = new MemberReferenceSetImpl();
        for ( Expression expression : this ) memberreferenceset.add( expression.R787_is_used_as_basis_for_MemberReference() );
        return memberreferenceset;
    }
    @Override
    public WhereSet R790_filtered_by_Where() throws XtumlException {
        WhereSet whereset = new WhereSetImpl();
        for ( Expression expression : this ) whereset.add( expression.R790_filtered_by_Where() );
        return whereset;
    }
    @Override
    public SelectRelatedSet R791_is_basis_for_SelectRelated() throws XtumlException {
        SelectRelatedSet selectrelatedset = new SelectRelatedSetImpl();
        for ( Expression expression : this ) selectrelatedset.add( expression.R791_is_basis_for_SelectRelated() );
        return selectrelatedset;
    }
    @Override
    public ActualParameterSet R794_defines_value_for_ActualParameter() throws XtumlException {
        ActualParameterSet actualparameterset = new ActualParameterSetImpl();
        for ( Expression expression : this ) actualparameterset.add( expression.R794_defines_value_for_ActualParameter() );
        return actualparameterset;
    }
    @Override
    public TypeReferenceSet R795_expresses_value_of_TypeReference() throws XtumlException {
        TypeReferenceSet typereferenceset = new TypeReferenceSetImpl();
        for ( Expression expression : this ) typereferenceset.add( expression.R795_expresses_value_of_TypeReference() );
        return typereferenceset;
    }
    @Override
    public WhereSet R796_defines_condtion_for_Where() throws XtumlException {
        WhereSet whereset = new WhereSetImpl();
        for ( Expression expression : this ) whereset.add( expression.R796_defines_condtion_for_Where() );
        return whereset;
    }
    @Override
    public InvocationSet R798_is_used_as_basis_for_Invocation() throws XtumlException {
        InvocationSet invocationset = new InvocationSetImpl();
        for ( Expression expression : this ) invocationset.add( expression.R798_is_used_as_basis_for_Invocation() );
        return invocationset;
    }


    @Override
    public Expression nullElement() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }

    @Override
    public ExpressionSet emptySet() {
      return new ExpressionSetImpl();
    }

    @Override
    public ExpressionSet emptySet(Comparator<? super Expression> comp) {
      return new ExpressionSetImpl(comp);
    }

    @Override
    public ExpressionSet value() {
        return this;
    }

    @Override
    public List<Expression> elements() {
        return Arrays.asList(toArray(new Expression[0]));
    }

}
