package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;
import io.ciera.tool.sql.architecture.expression.AttributeAccess;
import io.ciera.tool.sql.architecture.expression.AttributeAccessSet;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class AttributeAccessSetImpl extends InstanceSet<AttributeAccessSet,AttributeAccess> implements AttributeAccessSet {

    public AttributeAccessSetImpl() {
    }

    public AttributeAccessSetImpl(Comparator<? super AttributeAccess> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setRoot_expression_number( String ref_root_expression_number ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setRoot_expression_number( ref_root_expression_number );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setExpression_number( ref_expression_number );
    }
    @Override
    public void setAttr_class_name( String ref_attr_class_name ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setAttr_class_name( ref_attr_class_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setParent_name( ref_parent_name );
    }
    @Override
    public void setAttr_class_package( String ref_attr_class_package ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setAttr_class_package( ref_attr_class_package );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setBlock_number( ref_block_number );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setBody_name( ref_body_name );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setParent_package( ref_parent_package );
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( AttributeAccess attributeaccess : this ) attributeaccess.setAttr_name( ref_attr_name );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( AttributeAccess attributeaccess : this ) expressionset.add( attributeaccess.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R785_refers_to_attribute_of_instance_expressed_by_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( AttributeAccess attributeaccess : this ) expressionset.add( attributeaccess.R785_refers_to_attribute_of_instance_expressed_by_Expression() );
        return expressionset;
    }
    @Override
    public AttributeSet R788_refers_to_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( AttributeAccess attributeaccess : this ) attributeset.add( attributeaccess.R788_refers_to_Attribute() );
        return attributeset;
    }


    @Override
    public AttributeAccess nullElement() {
        return AttributeAccessImpl.EMPTY_ATTRIBUTEACCESS;
    }

    @Override
    public AttributeAccessSet emptySet() {
      return new AttributeAccessSetImpl();
    }

    @Override
    public AttributeAccessSet emptySet(Comparator<? super AttributeAccess> comp) {
      return new AttributeAccessSetImpl(comp);
    }

    @Override
    public AttributeAccessSet value() {
        return this;
    }

    @Override
    public List<AttributeAccess> elements() {
        return Arrays.asList(toArray(new AttributeAccess[0]));
    }

}
