package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.component.Utility;
import io.ciera.tool.sql.architecture.component.UtilityFunctionSet;
import io.ciera.tool.sql.architecture.component.UtilityReferenceSet;
import io.ciera.tool.sql.architecture.component.UtilitySet;
import io.ciera.tool.sql.architecture.component.impl.UtilityFunctionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilityReferenceSetImpl;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UtilitySetImpl extends InstanceSet<UtilitySet,Utility> implements UtilitySet {

    public UtilitySetImpl() {
    }

    public UtilitySetImpl(Comparator<? super Utility> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Utility utility : this ) utility.setName( ref_name );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( Utility utility : this ) utility.setPackage( ref_package );
    }


    // selections
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( Utility utility : this ) fileset.add( utility.R401_is_a_File() );
        return fileset;
    }
    @Override
    public UtilityReferenceSet R4558_used_within_context_of_UtilityReference() throws XtumlException {
        UtilityReferenceSet utilityreferenceset = new UtilityReferenceSetImpl();
        for ( Utility utility : this ) utilityreferenceset.addAll( utility.R4558_used_within_context_of_UtilityReference() );
        return utilityreferenceset;
    }
    @Override
    public UtilityFunctionSet R4559_provides_UtilityFunction() throws XtumlException {
        UtilityFunctionSet utilityfunctionset = new UtilityFunctionSetImpl();
        for ( Utility utility : this ) utilityfunctionset.addAll( utility.R4559_provides_UtilityFunction() );
        return utilityfunctionset;
    }


    @Override
    public Utility nullElement() {
        return UtilityImpl.EMPTY_UTILITY;
    }

    @Override
    public UtilitySet emptySet() {
      return new UtilitySetImpl();
    }

    @Override
    public UtilitySet emptySet(Comparator<? super Utility> comp) {
      return new UtilitySetImpl(comp);
    }

    @Override
    public UtilitySet value() {
        return this;
    }

    @Override
    public List<Utility> elements() {
        Utility[] elements = toArray(new Utility[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
