package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelector;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class RelationshipPopulationSelectorSetImpl extends InstanceSet<RelationshipPopulationSelectorSet,RelationshipPopulationSelector> implements RelationshipPopulationSelectorSet {

    public RelationshipPopulationSelectorSetImpl() {
    }

    public RelationshipPopulationSelectorSetImpl(Comparator<? super RelationshipPopulationSelector> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( RelationshipPopulationSelector relationshippopulationselector : this ) relationshippopulationselector.setComp_name( ref_comp_name );
    }
    @Override
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        for ( RelationshipPopulationSelector relationshippopulationselector : this ) relationshippopulationselector.setRel_name( ref_rel_name );
    }
    @Override
    public void setName( String m_name ) throws XtumlException {
        for ( RelationshipPopulationSelector relationshippopulationselector : this ) relationshippopulationselector.setName( m_name );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( RelationshipPopulationSelector relationshippopulationselector : this ) relationshippopulationselector.setComp_package( ref_comp_package );
    }


    // selections
    @Override
    public ComponentDefinitionSet R4571_selects_relationships_out_of_population_of_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( RelationshipPopulationSelector relationshippopulationselector : this ) componentdefinitionset.add( relationshippopulationselector.R4571_selects_relationships_out_of_population_of_ComponentDefinition() );
        return componentdefinitionset;
    }
    @Override
    public ClassRelationshipSet R4572_selects_instances_of_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( RelationshipPopulationSelector relationshippopulationselector : this ) classrelationshipset.add( relationshippopulationselector.R4572_selects_instances_of_ClassRelationship() );
        return classrelationshipset;
    }


    @Override
    public RelationshipPopulationSelector nullElement() {
        return RelationshipPopulationSelectorImpl.EMPTY_RELATIONSHIPPOPULATIONSELECTOR;
    }

    @Override
    public RelationshipPopulationSelectorSet emptySet() {
      return new RelationshipPopulationSelectorSetImpl();
    }

    @Override
    public RelationshipPopulationSelectorSet emptySet(Comparator<? super RelationshipPopulationSelector> comp) {
      return new RelationshipPopulationSelectorSetImpl(comp);
    }

    @Override
    public RelationshipPopulationSelectorSet value() {
        return this;
    }

    @Override
    public List<RelationshipPopulationSelector> elements() {
        RelationshipPopulationSelector[] elements = toArray(new RelationshipPopulationSelector[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
