package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.Function;
import io.ciera.tool.sql.architecture.component.FunctionSet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class FunctionSetImpl extends InstanceSet<FunctionSet,Function> implements FunctionSet {

    public FunctionSetImpl() {
    }

    public FunctionSetImpl(Comparator<? super Function> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Function function : this ) function.setName( ref_name );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( Function function : this ) function.setComp_package( ref_comp_package );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( Function function : this ) function.setComp_name( ref_comp_name );
    }


    // selections
    @Override
    public ComponentDefinitionSet R405_can_execute_synchronously_within_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( Function function : this ) componentdefinitionset.add( function.R405_can_execute_synchronously_within_ComponentDefinition() );
        return componentdefinitionset;
    }
    @Override
    public InvocableObjectSet R427_is_a_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( Function function : this ) invocableobjectset.add( function.R427_is_a_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public ComponentDefinitionSet R4561_initializes_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( Function function : this ) componentdefinitionset.addAll( function.R4561_initializes_ComponentDefinition() );
        return componentdefinitionset;
    }


    @Override
    public Function nullElement() {
        return FunctionImpl.EMPTY_FUNCTION;
    }

    @Override
    public FunctionSet emptySet() {
      return new FunctionSetImpl();
    }

    @Override
    public FunctionSet emptySet(Comparator<? super Function> comp) {
      return new FunctionSetImpl(comp);
    }

    @Override
    public FunctionSet value() {
        return this;
    }

    @Override
    public List<Function> elements() {
        Function[] elements = toArray(new Function[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
