package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.InstSetSet;
import io.ciera.tool.sql.architecture.classes.InstanceSelectorSet;
import io.ciera.tool.sql.architecture.classes.SelectorSet;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.classes.SetSelectorSet;
import io.ciera.tool.sql.architecture.classes.impl.InstSetSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.InstanceSelectorSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class SetSelectorSetImpl extends InstanceSet<SetSelectorSet,SetSelector> implements SetSelectorSet {

    public SetSelectorSetImpl() {
    }

    public SetSelectorSetImpl(Comparator<? super SetSelector> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setSet_parent_name( String ref_set_parent_name ) throws XtumlException {
        for ( SetSelector setselector : this ) setselector.setSet_parent_name( ref_set_parent_name );
    }
    @Override
    public void setSelector_class_name( String ref_selector_class_name ) throws XtumlException {
        for ( SetSelector setselector : this ) setselector.setSelector_class_name( ref_selector_class_name );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( SetSelector setselector : this ) setselector.setName( ref_name );
    }
    @Override
    public void setSelector_name( String ref_selector_name ) throws XtumlException {
        for ( SetSelector setselector : this ) setselector.setSelector_name( ref_selector_name );
    }
    @Override
    public void setSet_parent_package( String ref_set_parent_package ) throws XtumlException {
        for ( SetSelector setselector : this ) setselector.setSet_parent_package( ref_set_parent_package );
    }
    @Override
    public void setSelector_class_package( String ref_selector_class_package ) throws XtumlException {
        for ( SetSelector setselector : this ) setselector.setSelector_class_package( ref_selector_class_package );
    }


    // selections
    @Override
    public InstSetSet R444_navigates_from_InstSet() throws XtumlException {
        InstSetSet instsetset = new InstSetSetImpl();
        for ( SetSelector setselector : this ) instsetset.add( setselector.R444_navigates_from_InstSet() );
        return instsetset;
    }
    @Override
    public SelectorSet R445_is_a_Selector() throws XtumlException {
        SelectorSet selectorset = new SelectorSetImpl();
        for ( SetSelector setselector : this ) selectorset.add( setselector.R445_is_a_Selector() );
        return selectorset;
    }
    @Override
    public InstanceSelectorSet R4505_invokes_InstanceSelector() throws XtumlException {
        InstanceSelectorSet instanceselectorset = new InstanceSelectorSetImpl();
        for ( SetSelector setselector : this ) instanceselectorset.add( setselector.R4505_invokes_InstanceSelector() );
        return instanceselectorset;
    }


    @Override
    public SetSelector nullElement() {
        return SetSelectorImpl.EMPTY_SETSELECTOR;
    }

    @Override
    public SetSelectorSet emptySet() {
      return new SetSelectorSetImpl();
    }

    @Override
    public SetSelectorSet emptySet(Comparator<? super SetSelector> comp) {
      return new SetSelectorSetImpl(comp);
    }

    @Override
    public SetSelectorSet value() {
        return this;
    }

    @Override
    public List<SetSelector> elements() {
        SetSelector[] elements = toArray(new SetSelector[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
