package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.InstanceSelector;
import io.ciera.tool.sql.architecture.classes.Selector;
import io.ciera.tool.sql.architecture.classes.SetSelector;
import io.ciera.tool.sql.architecture.classes.impl.InstSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.InstanceSelectorImpl;
import io.ciera.tool.sql.architecture.classes.impl.SelectorImpl;

import types.Mult;


public class SetSelectorImpl extends ModelInstance<SetSelector,Sql> implements SetSelector {

    public static final String KEY_LETTERS = "SetSelector";
    public static final SetSelector EMPTY_SETSELECTOR = new EmptySetSelector();

    private Sql context;

    // constructors
    private SetSelectorImpl( Sql context ) {
        this.context = context;
        ref_set_parent_name = "";
        ref_set_parent_package = "";
        ref_name = "";
        ref_selector_class_name = "";
        ref_selector_class_package = "";
        ref_selector_name = "";
        R444_navigates_from_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R445_is_a_Selector_inst = SelectorImpl.EMPTY_SELECTOR;
        R4505_invokes_InstanceSelector_inst = InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
    }

    private SetSelectorImpl( Sql context, UniqueId instanceId, String ref_set_parent_name, String ref_set_parent_package, String ref_name, String ref_selector_class_name, String ref_selector_class_package, String ref_selector_name ) {
        super(instanceId);
        this.context = context;
        this.ref_set_parent_name = ref_set_parent_name;
        this.ref_set_parent_package = ref_set_parent_package;
        this.ref_name = ref_name;
        this.ref_selector_class_name = ref_selector_class_name;
        this.ref_selector_class_package = ref_selector_class_package;
        this.ref_selector_name = ref_selector_name;
        R444_navigates_from_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R445_is_a_Selector_inst = SelectorImpl.EMPTY_SELECTOR;
        R4505_invokes_InstanceSelector_inst = InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
    }

    public static SetSelector create( Sql context ) throws XtumlException {
        SetSelector newSetSelector = new SetSelectorImpl( context );
        if ( context.addInstance( newSetSelector ) ) {
            newSetSelector.getRunContext().addChange(new InstanceCreatedDelta(newSetSelector, KEY_LETTERS));
            return newSetSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SetSelector create( Sql context, UniqueId instanceId, String ref_set_parent_name, String ref_set_parent_package, String ref_name, String ref_selector_class_name, String ref_selector_class_package, String ref_selector_name ) throws XtumlException {
        SetSelector newSetSelector = new SetSelectorImpl( context, instanceId, ref_set_parent_name, ref_set_parent_package, ref_name, ref_selector_class_name, ref_selector_class_package, ref_selector_name );
        if ( context.addInstance( newSetSelector ) ) {
            return newSetSelector;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_set_parent_name;
    @Override
    public void setSet_parent_name( String ref_set_parent_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_set_parent_name, this.ref_set_parent_name ) ) {
            final String oldValue = this.ref_set_parent_name;
            this.ref_set_parent_name = ref_set_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_set_parent_name", oldValue, this.ref_set_parent_name));
        }
    }
    @Override
    public String getSet_parent_name() throws XtumlException {
        checkLiving();
                return ref_set_parent_name;
    }
    private String ref_set_parent_package;
    @Override
    public String getSet_parent_package() throws XtumlException {
        checkLiving();
                return ref_set_parent_package;
    }
    @Override
    public void setSet_parent_package( String ref_set_parent_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_set_parent_package, this.ref_set_parent_package ) ) {
            final String oldValue = this.ref_set_parent_package;
            this.ref_set_parent_package = ref_set_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_set_parent_package", oldValue, this.ref_set_parent_package));
        }
    }
    private String ref_name;
    @Override
    public void setName( String ref_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_name, this.ref_name ) ) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return ref_name;
    }
    private String ref_selector_class_name;
    @Override
    public String getSelector_class_name() throws XtumlException {
        checkLiving();
                return ref_selector_class_name;
    }
    @Override
    public void setSelector_class_name( String ref_selector_class_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_selector_class_name, this.ref_selector_class_name ) ) {
            final String oldValue = this.ref_selector_class_name;
            this.ref_selector_class_name = ref_selector_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_class_name", oldValue, this.ref_selector_class_name));
        }
    }
    private String ref_selector_class_package;
    @Override
    public void setSelector_class_package( String ref_selector_class_package ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_selector_class_package, this.ref_selector_class_package ) ) {
            final String oldValue = this.ref_selector_class_package;
            this.ref_selector_class_package = ref_selector_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_class_package", oldValue, this.ref_selector_class_package));
        }
    }
    @Override
    public String getSelector_class_package() throws XtumlException {
        checkLiving();
                return ref_selector_class_package;
    }
    private String ref_selector_name;
    @Override
    public String getSelector_name() throws XtumlException {
        checkLiving();
                return ref_selector_name;
    }
    @Override
    public void setSelector_name( String ref_selector_name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( ref_selector_name, this.ref_selector_name ) ) {
            final String oldValue = this.ref_selector_name;
            this.ref_selector_name = ref_selector_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_selector_name", oldValue, this.ref_selector_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSet_parent_name(), getSet_parent_package(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        Selector selector = self().R445_is_a_Selector();
        String type_name = selector.getType_reference_name();
        boolean multiplicity_many = selector.getMultiplicity().equality( Mult.MANY );
        context().T().include( "class/t.setselector.java", multiplicity_many, self(), type_name );
    }

    @Override
    public void render_interface() throws XtumlException {
        Selector selector = self().R445_is_a_Selector();
        String type_name = selector.getType_reference_name();
        context().T().include( "class/t.setselector.int.java", self(), type_name );
    }



    // static operations


    // events


    // selections
    private InstSet R444_navigates_from_InstSet_inst;
    @Override
    public void setR444_navigates_from_InstSet( InstSet inst ) {
        R444_navigates_from_InstSet_inst = inst;
    }
    @Override
    public InstSet R444_navigates_from_InstSet() throws XtumlException {
        return R444_navigates_from_InstSet_inst;
    }
    private Selector R445_is_a_Selector_inst;
    @Override
    public void setR445_is_a_Selector( Selector inst ) {
        R445_is_a_Selector_inst = inst;
    }
    @Override
    public Selector R445_is_a_Selector() throws XtumlException {
        return R445_is_a_Selector_inst;
    }
    private InstanceSelector R4505_invokes_InstanceSelector_inst;
    @Override
    public void setR4505_invokes_InstanceSelector( InstanceSelector inst ) {
        R4505_invokes_InstanceSelector_inst = inst;
    }
    @Override
    public InstanceSelector R4505_invokes_InstanceSelector() throws XtumlException {
        return R4505_invokes_InstanceSelector_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SetSelector value() {
        return this;
    }

    @Override
    public SetSelector self() {
        return this;
    }

    @Override
    public SetSelector oneWhere( IWhere<SetSelector> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_SETSELECTOR;
    }

}

class EmptySetSelector extends ModelInstance<SetSelector,Sql> implements SetSelector {

    // attributes
    public void setSet_parent_name( String ref_set_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSet_parent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSet_parent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSet_parent_package( String ref_set_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSelector_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSelector_class_name( String ref_selector_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSelector_class_package( String ref_selector_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getSelector_class_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getSelector_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSelector_name( String ref_selector_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_interface() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InstSet R444_navigates_from_InstSet() {
        return InstSetImpl.EMPTY_INSTSET;
    }
    @Override
    public Selector R445_is_a_Selector() {
        return SelectorImpl.EMPTY_SELECTOR;
    }
    @Override
    public InstanceSelector R4505_invokes_InstanceSelector() {
        return InstanceSelectorImpl.EMPTY_INSTANCESELECTOR;
    }


    @Override
    public String getKeyLetters() {
        return SetSelectorImpl.KEY_LETTERS;
    }

    @Override
    public SetSelector value() {
        return this;
    }
    
    @Override
    public SetSelector self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SetSelector oneWhere( IWhere<SetSelector> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return SetSelectorImpl.EMPTY_SETSELECTOR;
    }

}
