package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.Operation;
import io.ciera.tool.sql.architecture.classes.OperationSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class OperationSetImpl extends InstanceSet<OperationSet,Operation> implements OperationSet {

    public OperationSetImpl() {
    }

    public OperationSetImpl(Comparator<? super Operation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setIs_class_based( boolean m_is_class_based ) throws XtumlException {
        for ( Operation operation : this ) operation.setIs_class_based( m_is_class_based );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( Operation operation : this ) operation.setComp_package( ref_comp_package );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( Operation operation : this ) operation.setClass_name( ref_class_name );
    }
    @Override
    public void setClass_package( String ref_class_package ) throws XtumlException {
        for ( Operation operation : this ) operation.setClass_package( ref_class_package );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( Operation operation : this ) operation.setComp_name( ref_comp_name );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Operation operation : this ) operation.setName( ref_name );
    }


    // selections
    @Override
    public ModelInstSet R416_provided_by_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( Operation operation : this ) modelinstset.add( operation.R416_provided_by_ModelInst() );
        return modelinstset;
    }
    @Override
    public InvocableObjectSet R427_is_a_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( Operation operation : this ) invocableobjectset.add( operation.R427_is_a_InvocableObject() );
        return invocableobjectset;
    }


    @Override
    public Operation nullElement() {
        return OperationImpl.EMPTY_OPERATION;
    }

    @Override
    public OperationSet emptySet() {
      return new OperationSetImpl();
    }

    @Override
    public OperationSet emptySet(Comparator<? super Operation> comp) {
      return new OperationSetImpl(comp);
    }

    @Override
    public OperationSet value() {
        return this;
    }

    @Override
    public List<Operation> elements() {
        Operation[] elements = toArray(new Operation[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
