package io.ciera.tool.sql.architecture.application.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.application.ApplicationExecutor;
import io.ciera.tool.sql.architecture.application.ApplicationExecutorSet;
import io.ciera.tool.sql.architecture.application.ApplicationSet;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ApplicationSetImpl;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ApplicationExecutorSetImpl extends InstanceSet<ApplicationExecutorSet,ApplicationExecutor> implements ApplicationExecutorSet {

    public ApplicationExecutorSetImpl() {
    }

    public ApplicationExecutorSetImpl(Comparator<? super ApplicationExecutor> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setIndex( int m_index ) throws XtumlException {
        for ( ApplicationExecutor applicationexecutor : this ) applicationexecutor.setIndex( m_index );
    }
    @Override
    public void setApp_name( String ref_app_name ) throws XtumlException {
        for ( ApplicationExecutor applicationexecutor : this ) applicationexecutor.setApp_name( ref_app_name );
    }
    @Override
    public void setApp_package( String ref_app_package ) throws XtumlException {
        for ( ApplicationExecutor applicationexecutor : this ) applicationexecutor.setApp_package( ref_app_package );
    }


    // selections
    @Override
    public ApplicationSet R4027_executes_tasks_for_Application() throws XtumlException {
        ApplicationSet applicationset = new ApplicationSetImpl();
        for ( ApplicationExecutor applicationexecutor : this ) applicationset.add( applicationexecutor.R4027_executes_tasks_for_Application() );
        return applicationset;
    }
    @Override
    public ComponentInstantiationSet R4028_provides_execution_context_for_ComponentInstantiation() throws XtumlException {
        ComponentInstantiationSet componentinstantiationset = new ComponentInstantiationSetImpl();
        for ( ApplicationExecutor applicationexecutor : this ) componentinstantiationset.addAll( applicationexecutor.R4028_provides_execution_context_for_ComponentInstantiation() );
        return componentinstantiationset;
    }


    @Override
    public ApplicationExecutor nullElement() {
        return ApplicationExecutorImpl.EMPTY_APPLICATIONEXECUTOR;
    }

    @Override
    public ApplicationExecutorSet emptySet() {
      return new ApplicationExecutorSetImpl();
    }

    @Override
    public ApplicationExecutorSet emptySet(Comparator<? super ApplicationExecutor> comp) {
      return new ApplicationExecutorSetImpl(comp);
    }

    @Override
    public ApplicationExecutorSet value() {
        return this;
    }

    @Override
    public List<ApplicationExecutor> elements() {
        return Arrays.asList(toArray(new ApplicationExecutor[0]));
    }

}
