package io.ciera.tool.sql;


import compiler.IGen;

import io.ciera.runtime.summit.exceptions.BadArgumentException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.interfaces.IMessage;
import io.ciera.runtime.summit.interfaces.IPort;
import io.ciera.runtime.summit.interfaces.Port;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.compiler.impl.CIERAImpl;


public class SqlCodegen extends Port<Sql> implements IGen {

    public SqlCodegen( Sql context, IPort<?> peer ) {
        super( context, peer );
    }

    // inbound messages
    public void preprocess( final String p_projectroot ) throws XtumlException {
        new CIERAImpl.CLASS(context()).setprojectroot( p_projectroot );
        context().preprocess();
        context().Codegen().ok();
    }

    public void translate() throws XtumlException {
        context().translate();
        context().Codegen().ok();
    }



    // outbound messages
    public void ok() throws XtumlException {
        if ( satisfied() ) send(new IGen.Ok());
        else {
        }
    }


    @Override
    public void deliver( IMessage message ) throws XtumlException {
        if ( null == message ) throw new BadArgumentException( "Cannot deliver null message." );
        switch ( message.getId() ) {
            case IGen.SIGNAL_NO_PREPROCESS:
                preprocess(StringUtil.deserialize(message.get(0)));
                break;
            case IGen.SIGNAL_NO_TRANSLATE:
                translate();
                break;
        default:
            throw new BadArgumentException( "Message not implemented by this port." );
        }
    }



    @Override
    public String getName() {
        return "Codegen";
    }

}
