package compiler;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.interfaces.Message;


public interface IGen {

    // to provider messages
    public static final int SIGNAL_NO_PREPROCESS = 2;
    public static class Preprocess extends Message {
        public Preprocess( final String p_projectroot ) {
            super(new Object[]{p_projectroot});
        }
        @Override
        public int getId() {
            return SIGNAL_NO_PREPROCESS;
        }
 
    }
    public void preprocess( final String p_projectroot ) throws XtumlException;
    public static final int SIGNAL_NO_TRANSLATE = 3;
    public static class Translate extends Message {
        @Override
        public int getId() {
            return SIGNAL_NO_TRANSLATE;
        }
 
    }
    public void translate() throws XtumlException;


    // from provider messages
    public static final int SIGNAL_NO_OK = 1;
    public static class Ok extends Message {
        @Override
        public int getId() {
            return SIGNAL_NO_OK;
        }
 
    }
    public void ok() throws XtumlException;


}
