/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.tool;

import io.ciera.runtime.Version;
import io.ciera.runtime.instanceloading.IPopulationLoader;
import io.ciera.runtime.summit.application.ApplicationExecutor;
import io.ciera.runtime.summit.application.IApplication;
import io.ciera.runtime.summit.application.IApplicationTask;
import io.ciera.runtime.summit.application.ILogger;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.application.tasks.GenericExecutionTask;
import io.ciera.runtime.summit.application.tasks.HaltExecutionTask;
import io.ciera.runtime.summit.components.IComponent;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.Sql;
import io.ciera.tool.SqlSqlLoader;
import java.util.Arrays;

public class SqlTool
implements IApplication {
    private IComponent<?>[] components = new IComponent[1];
    private ApplicationExecutor[] executors = new ApplicationExecutor[1];

    public void setup(String[] args, ILogger logger) {
        for (int i = 0; i < this.executors.length; ++i) {
            this.executors[i] = null != logger ? new ApplicationExecutor("SqlToolExecutor" + i, args, logger) : new ApplicationExecutor("SqlToolExecutor" + i, args);
        }
        this.components[0] = new Sql(this, (IRunContext)this.executors[0], 0);
        this.components[0].addLoader("Sql", (IPopulationLoader)new SqlSqlLoader((Sql)this.components[0]));
    }

    public void initialize() {
        for (final IComponent<?> component : this.components) {
            component.getRunContext().execute((IApplicationTask)new GenericExecutionTask(){

                public void run() throws XtumlException {
                    component.initialize();
                }
            });
        }
    }

    public void start() {
        if (1 == this.executors.length) {
            this.executors[0].run();
        } else {
            for (ApplicationExecutor executor : this.executors) {
                executor.start();
            }
        }
    }

    public void printVersions() {
        Version.printVersion();
        for (IComponent<?> c : this.components) {
            System.out.printf("%s: %s (%s)", c.getClass().getName(), c.getVersion(), c.getVersionDate());
            System.out.println();
        }
    }

    public void stop() {
        for (ApplicationExecutor executor : this.executors) {
            executor.execute((IApplicationTask)new HaltExecutionTask());
        }
    }

    public static void main(String[] args) {
        SqlTool app = new SqlTool();
        app.setup(args, null);
        if (Arrays.asList(args).contains("-v") || Arrays.asList(args).contains("--version")) {
            app.printVersions();
        } else {
            app.initialize();
            app.start();
        }
    }
}

