package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum TransitionType implements IXtumlType<TransitionType> {

    UNINITIALIZED_ENUM( -1 ),
    CANT_HAPPEN( 1 ),
    IGNORE( 2 ),
    TRANSITION( 0 );

    private final int value;

    TransitionType() {
        value = -1;
    }

    TransitionType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( TransitionType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public TransitionType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static TransitionType deserialize(Object o) throws XtumlException {
        if (o instanceof TransitionType) {
            return (TransitionType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static TransitionType valueOf(int value) {
        switch( value ) {
        case 1:
            return CANT_HAPPEN;
        case 2:
            return IGNORE;
        case 0:
            return TRANSITION;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
