package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum AttributeAccessorType implements IXtumlType<AttributeAccessorType> {

    UNINITIALIZED_ENUM( -1 ),
    GETTER( 0 ),
    SETTER( 1 );

    private final int value;

    AttributeAccessorType() {
        value = -1;
    }

    AttributeAccessorType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( AttributeAccessorType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public AttributeAccessorType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static AttributeAccessorType deserialize(Object o) throws XtumlException {
        if (o instanceof AttributeAccessorType) {
            return (AttributeAccessorType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static AttributeAccessorType valueOf(int value) {
        switch( value ) {
        case 0:
            return GETTER;
        case 1:
            return SETTER;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
