package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Visibility implements IXtumlType<Visibility> {

    UNINITIALIZED_ENUM( -1 ),
    PRIVATE( 0 ),
    PROTECTED( 2 ),
    PUBLIC( 1 );

    private final int value;

    Visibility() {
        value = -1;
    }

    Visibility( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Visibility value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Visibility value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Visibility deserialize(Object o) throws XtumlException {
        if (o instanceof Visibility) {
            return (Visibility)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Visibility valueOf(int value) {
        switch( value ) {
        case 0:
            return PRIVATE;
        case 2:
            return PROTECTED;
        case 1:
            return PUBLIC;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
