package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum SynchronizationType implements IXtumlType<SynchronizationType> {

    UNINITIALIZED_ENUM( -1 ),
    PULL( 0 ),
    PUSH( 1 );

    private final int value;

    SynchronizationType() {
        value = -1;
    }

    SynchronizationType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( SynchronizationType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public SynchronizationType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static SynchronizationType deserialize(Object o) throws XtumlException {
        if (o instanceof SynchronizationType) {
            return (SynchronizationType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static SynchronizationType valueOf(int value) {
        switch( value ) {
        case 0:
            return PULL;
        case 1:
            return PUSH;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
