package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum ModelEventNotification implements IXtumlType<ModelEventNotification> {

    UNINITIALIZED_ENUM( -1 ),
    DELTA_ATTRIBUTE_CHANGE( 0 ),
    DELTA_DELETE( 1 ),
    DELTA_ELEMENT_RELATED( 2 ),
    DELTA_ELEMENT_UNRELATED( 3 ),
    DELTA_NEW( 4 ),
    MASK_ALL_DELTAS( 5 ),
    MASK_ALL_EVENTS( 6 ),
    MASK_NO_DELTAS( 7 ),
    MASK_NO_EVENTS( 8 ),
    MODEL_ELEMENT_CHANGED( 9 ),
    MODEL_ELEMENT_LOADED( 10 ),
    MODEL_ELEMENT_PRE_DELETE( 11 ),
    MODEL_ELEMENT_PRE_RELOAD( 12 ),
    MODEL_ELEMENT_RELOAD( 13 ),
    MODEL_ELEMENT_UNLOADED( 14 ),
    MODEL_EXECUTION_STOPPED( 15 ),
    UNKNOWN( 16 );

    private final int value;

    ModelEventNotification() {
        value = -1;
    }

    ModelEventNotification( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( ModelEventNotification value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public ModelEventNotification value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ModelEventNotification deserialize(Object o) throws XtumlException {
        if (o instanceof ModelEventNotification) {
            return (ModelEventNotification)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static ModelEventNotification valueOf(int value) {
        switch( value ) {
        case 0:
            return DELTA_ATTRIBUTE_CHANGE;
        case 1:
            return DELTA_DELETE;
        case 2:
            return DELTA_ELEMENT_RELATED;
        case 3:
            return DELTA_ELEMENT_UNRELATED;
        case 4:
            return DELTA_NEW;
        case 5:
            return MASK_ALL_DELTAS;
        case 6:
            return MASK_ALL_EVENTS;
        case 7:
            return MASK_NO_DELTAS;
        case 8:
            return MASK_NO_EVENTS;
        case 9:
            return MODEL_ELEMENT_CHANGED;
        case 10:
            return MODEL_ELEMENT_LOADED;
        case 11:
            return MODEL_ELEMENT_PRE_DELETE;
        case 12:
            return MODEL_ELEMENT_PRE_RELOAD;
        case 13:
            return MODEL_ELEMENT_RELOAD;
        case 14:
            return MODEL_ELEMENT_UNLOADED;
        case 15:
            return MODEL_EXECUTION_STOPPED;
        case 16:
            return UNKNOWN;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
