package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum EventProcessType implements IXtumlType<EventProcessType> {

    UNINITIALIZED_ENUM( -1 ),
    CANTHAPPEN( 0 ),
    DEQUEUED( 1 ),
    ENQUEUED( 2 ),
    IGNORED( 3 );

    private final int value;

    EventProcessType() {
        value = -1;
    }

    EventProcessType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( EventProcessType value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public EventProcessType value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static EventProcessType deserialize(Object o) throws XtumlException {
        if (o instanceof EventProcessType) {
            return (EventProcessType)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static EventProcessType valueOf(int value) {
        switch( value ) {
        case 0:
            return CANTHAPPEN;
        case 1:
            return DEQUEUED;
        case 2:
            return ENQUEUED;
        case 3:
            return IGNORED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
