package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;


public enum Breakpoint_Type implements IXtumlType<Breakpoint_Type> {

    UNINITIALIZED_ENUM( -1 ),
    ASSOCIATION( 0 ),
    ATTRIBUTE( 1 ),
    EVENT_BP( 2 ),
    INSTANCE( 3 ),
    OAL( 4 ),
    STATE( 5 );

    private final int value;

    Breakpoint_Type() {
        value = -1;
    }

    Breakpoint_Type( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( Breakpoint_Type value ) throws XtumlException {
        return null != value && this.value == value.getValue();
    }

    @Override
    public Breakpoint_Type value() {
        return this;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Breakpoint_Type deserialize(Object o) throws XtumlException {
        if (o instanceof Breakpoint_Type) {
            return (Breakpoint_Type)o;
        }
        else {
            int value;
            if (o instanceof Integer) {
                value = (int)o;
            }
            else if (o instanceof String) {
                value = Integer.parseInt((String)o);
            }
            else throw new XtumlException("Cannot deserialize value");
            return valueOf(value);
        }
    }

    public static Breakpoint_Type valueOf(int value) {
        switch( value ) {
        case 0:
            return ASSOCIATION;
        case 1:
            return ATTRIBUTE;
        case 2:
            return EVENT_BP;
        case 3:
            return INSTANCE;
        case 4:
            return OAL;
        case 5:
            return STATE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
