package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.I_INS;
import io.ciera.tool.sql.ooaofooa.instance.I_INSSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.I_INSSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.CreationTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.MealyActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.NewStateTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.NoEventTransition;
import io.ciera.tool.sql.ooaofooa.statemachine.SM_SM;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineState;
import io.ciera.tool.sql.ooaofooa.statemachine.Transition;
import io.ciera.tool.sql.ooaofooa.statemachine.TransitionActionHome;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.CreationTransitionImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.MealyActionHomeImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.NewStateTransitionImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.NoEventTransitionImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.SM_SMImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineStateImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.TransitionActionHomeImpl;


public class TransitionImpl extends ModelInstance<Transition,Sql> implements Transition {

    public static final String KEY_LETTERS = "SM_TXN";
    public static final Transition EMPTY_TRANSITION = new EmptyTransition();

    private Sql context;

    // constructors
    private TransitionImpl( Sql context ) {
        this.context = context;
        m_Trans_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMstt_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        R2953_caused_last_state_change_to_I_INS_set = new I_INSSetImpl();
        R505_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R506_is_destined_to_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
        R507_is_a_CreationTransition_inst = CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
        R507_is_a_NewStateTransition_inst = NewStateTransitionImpl.EMPTY_NEWSTATETRANSITION;
        R507_is_a_NoEventTransition_inst = NoEventTransitionImpl.EMPTY_NOEVENTTRANSITION;
        R512_MealyActionHome_inst = MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
        R530_houses_action_for_TransitionActionHome_inst = TransitionActionHomeImpl.EMPTY_TRANSITIONACTIONHOME;
    }

    private TransitionImpl( Sql context, UniqueId instanceId, UniqueId m_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID, UniqueId m_SMspd_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.m_Trans_ID = m_Trans_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMstt_ID = ref_SMstt_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        R2953_caused_last_state_change_to_I_INS_set = new I_INSSetImpl();
        R505_SM_SM_inst = SM_SMImpl.EMPTY_SM_SM;
        R506_is_destined_to_StateMachineState_inst = StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
        R507_is_a_CreationTransition_inst = CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
        R507_is_a_NewStateTransition_inst = NewStateTransitionImpl.EMPTY_NEWSTATETRANSITION;
        R507_is_a_NoEventTransition_inst = NoEventTransitionImpl.EMPTY_NOEVENTTRANSITION;
        R512_MealyActionHome_inst = MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
        R530_houses_action_for_TransitionActionHome_inst = TransitionActionHomeImpl.EMPTY_TRANSITIONACTIONHOME;
    }

    public static Transition create( Sql context ) throws XtumlException {
        Transition newTransition = new TransitionImpl( context );
        if ( context.addInstance( newTransition ) ) {
            newTransition.getRunContext().addChange(new InstanceCreatedDelta(newTransition, KEY_LETTERS));
            return newTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Transition create( Sql context, UniqueId instanceId, UniqueId m_Trans_ID, UniqueId ref_SM_ID, UniqueId ref_SMstt_ID, UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        Transition newTransition = new TransitionImpl( context, instanceId, m_Trans_ID, ref_SM_ID, ref_SMstt_ID, m_SMspd_IDdeprecated );
        if ( context.addInstance( newTransition ) ) {
            return newTransition;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Trans_ID;
    @Override
    public UniqueId getTrans_ID() throws XtumlException {
        checkLiving();
                return m_Trans_ID;
    }
    @Override
    public void setTrans_ID( UniqueId m_Trans_ID ) throws XtumlException {
        checkLiving();
        if ( m_Trans_ID.inequality( this.m_Trans_ID ) ) {
            final UniqueId oldValue = this.m_Trans_ID;
            this.m_Trans_ID = m_Trans_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Trans_ID", oldValue, this.m_Trans_ID));
            if ( !R507_is_a_NoEventTransition().isEmpty() ) R507_is_a_NoEventTransition().setTrans_ID( m_Trans_ID );
            if ( !R2953_caused_last_state_change_to_I_INS().isEmpty() ) R2953_caused_last_state_change_to_I_INS().setTrans_ID( m_Trans_ID );
            if ( !R530_houses_action_for_TransitionActionHome().isEmpty() ) R530_houses_action_for_TransitionActionHome().setTrans_ID( m_Trans_ID );
            if ( !R512_MealyActionHome().isEmpty() ) R512_MealyActionHome().setTrans_ID( m_Trans_ID );
            if ( !R507_is_a_NewStateTransition().isEmpty() ) R507_is_a_NewStateTransition().setTrans_ID( m_Trans_ID );
            if ( !R507_is_a_CreationTransition().isEmpty() ) R507_is_a_CreationTransition().setTrans_ID( m_Trans_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
                return ref_SM_ID;
    }
    @Override
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        checkLiving();
        if ( ref_SM_ID.inequality( this.ref_SM_ID ) ) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R507_is_a_CreationTransition().isEmpty() ) R507_is_a_CreationTransition().setSM_ID( ref_SM_ID );
            if ( !R507_is_a_NoEventTransition().isEmpty() ) R507_is_a_NoEventTransition().setSM_ID( ref_SM_ID );
            if ( !R530_houses_action_for_TransitionActionHome().isEmpty() ) R530_houses_action_for_TransitionActionHome().setSM_ID( ref_SM_ID );
            if ( !R2953_caused_last_state_change_to_I_INS().isEmpty() ) R2953_caused_last_state_change_to_I_INS().setSM_ID( ref_SM_ID );
            if ( !R507_is_a_NewStateTransition().isEmpty() ) R507_is_a_NewStateTransition().setSM_ID( ref_SM_ID );
            if ( !R512_MealyActionHome().isEmpty() ) R512_MealyActionHome().setSM_ID( ref_SM_ID );
        }
    }
    private UniqueId ref_SMstt_ID;
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
                return ref_SMstt_ID;
    }
    @Override
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        checkLiving();
        if ( ref_SMstt_ID.inequality( this.ref_SMstt_ID ) ) {
            final UniqueId oldValue = this.ref_SMstt_ID;
            this.ref_SMstt_ID = ref_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMstt_ID", oldValue, this.ref_SMstt_ID));
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
                return m_SMspd_IDdeprecated;
    }
    @Override
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        checkLiving();
        if ( m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated ) ) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getTrans_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private I_INSSet R2953_caused_last_state_change_to_I_INS_set;
    @Override
    public void addR2953_caused_last_state_change_to_I_INS( I_INS inst ) {
        R2953_caused_last_state_change_to_I_INS_set.add(inst);
    }
    @Override
    public void removeR2953_caused_last_state_change_to_I_INS( I_INS inst ) {
        R2953_caused_last_state_change_to_I_INS_set.remove(inst);
    }
    @Override
    public I_INSSet R2953_caused_last_state_change_to_I_INS() throws XtumlException {
        return R2953_caused_last_state_change_to_I_INS_set;
    }
    private SM_SM R505_SM_SM_inst;
    @Override
    public void setR505_SM_SM( SM_SM inst ) {
        R505_SM_SM_inst = inst;
    }
    @Override
    public SM_SM R505_SM_SM() throws XtumlException {
        return R505_SM_SM_inst;
    }
    private StateMachineState R506_is_destined_to_StateMachineState_inst;
    @Override
    public void setR506_is_destined_to_StateMachineState( StateMachineState inst ) {
        R506_is_destined_to_StateMachineState_inst = inst;
    }
    @Override
    public StateMachineState R506_is_destined_to_StateMachineState() throws XtumlException {
        return R506_is_destined_to_StateMachineState_inst;
    }
    private CreationTransition R507_is_a_CreationTransition_inst;
    @Override
    public void setR507_is_a_CreationTransition( CreationTransition inst ) {
        R507_is_a_CreationTransition_inst = inst;
    }
    @Override
    public CreationTransition R507_is_a_CreationTransition() throws XtumlException {
        return R507_is_a_CreationTransition_inst;
    }
    private NewStateTransition R507_is_a_NewStateTransition_inst;
    @Override
    public void setR507_is_a_NewStateTransition( NewStateTransition inst ) {
        R507_is_a_NewStateTransition_inst = inst;
    }
    @Override
    public NewStateTransition R507_is_a_NewStateTransition() throws XtumlException {
        return R507_is_a_NewStateTransition_inst;
    }
    private NoEventTransition R507_is_a_NoEventTransition_inst;
    @Override
    public void setR507_is_a_NoEventTransition( NoEventTransition inst ) {
        R507_is_a_NoEventTransition_inst = inst;
    }
    @Override
    public NoEventTransition R507_is_a_NoEventTransition() throws XtumlException {
        return R507_is_a_NoEventTransition_inst;
    }
    private MealyActionHome R512_MealyActionHome_inst;
    @Override
    public void setR512_MealyActionHome( MealyActionHome inst ) {
        R512_MealyActionHome_inst = inst;
    }
    @Override
    public MealyActionHome R512_MealyActionHome() throws XtumlException {
        return R512_MealyActionHome_inst;
    }
    private TransitionActionHome R530_houses_action_for_TransitionActionHome_inst;
    @Override
    public void setR530_houses_action_for_TransitionActionHome( TransitionActionHome inst ) {
        R530_houses_action_for_TransitionActionHome_inst = inst;
    }
    @Override
    public TransitionActionHome R530_houses_action_for_TransitionActionHome() throws XtumlException {
        return R530_houses_action_for_TransitionActionHome_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Transition value() {
        return this;
    }

    @Override
    public Transition self() {
        return this;
    }

    @Override
    public Transition oneWhere( IWhere<Transition> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_TRANSITION;
    }

}

class EmptyTransition extends ModelInstance<Transition,Sql> implements Transition {

    // attributes
    public UniqueId getTrans_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTrans_ID( UniqueId m_Trans_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public I_INSSet R2953_caused_last_state_change_to_I_INS() {
        return (new I_INSSetImpl());
    }
    @Override
    public SM_SM R505_SM_SM() {
        return SM_SMImpl.EMPTY_SM_SM;
    }
    @Override
    public StateMachineState R506_is_destined_to_StateMachineState() {
        return StateMachineStateImpl.EMPTY_STATEMACHINESTATE;
    }
    @Override
    public CreationTransition R507_is_a_CreationTransition() {
        return CreationTransitionImpl.EMPTY_CREATIONTRANSITION;
    }
    @Override
    public NewStateTransition R507_is_a_NewStateTransition() {
        return NewStateTransitionImpl.EMPTY_NEWSTATETRANSITION;
    }
    @Override
    public NoEventTransition R507_is_a_NoEventTransition() {
        return NoEventTransitionImpl.EMPTY_NOEVENTTRANSITION;
    }
    @Override
    public MealyActionHome R512_MealyActionHome() {
        return MealyActionHomeImpl.EMPTY_MEALYACTIONHOME;
    }
    @Override
    public TransitionActionHome R530_houses_action_for_TransitionActionHome() {
        return TransitionActionHomeImpl.EMPTY_TRANSITIONACTIONHOME;
    }


    @Override
    public String getKeyLetters() {
        return TransitionImpl.KEY_LETTERS;
    }

    @Override
    public Transition value() {
        return this;
    }
    
    @Override
    public Transition self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Transition oneWhere( IWhere<Transition> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return TransitionImpl.EMPTY_TRANSITION;
    }

}
