package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.InformalArgument;
import io.ciera.tool.sql.ooaofooa.message.MessageArgument;
import io.ciera.tool.sql.ooaofooa.message.impl.MessageArgumentImpl;


public class InformalArgumentImpl extends ModelInstance<InformalArgument,Sql> implements InformalArgument {

    public static final String KEY_LETTERS = "MSG_IA";
    public static final InformalArgument EMPTY_INFORMALARGUMENT = new EmptyInformalArgument();

    private Sql context;

    // constructors
    private InformalArgumentImpl( Sql context ) {
        this.context = context;
        ref_Arg_ID = UniqueId.random();
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }

    private InformalArgumentImpl( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Arg_ID = ref_Arg_ID;
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }

    public static InformalArgument create( Sql context ) throws XtumlException {
        InformalArgument newInformalArgument = new InformalArgumentImpl( context );
        if ( context.addInstance( newInformalArgument ) ) {
            newInformalArgument.getRunContext().addChange(new InstanceCreatedDelta(newInformalArgument, KEY_LETTERS));
            return newInformalArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InformalArgument create( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID ) throws XtumlException {
        InformalArgument newInformalArgument = new InformalArgumentImpl( context, instanceId, ref_Arg_ID );
        if ( context.addInstance( newInformalArgument ) ) {
            return newInformalArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Arg_ID;
    @Override
    public UniqueId getArg_ID() throws XtumlException {
        checkLiving();
                return ref_Arg_ID;
    }
    @Override
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Arg_ID.inequality( this.ref_Arg_ID ) ) {
            final UniqueId oldValue = this.ref_Arg_ID;
            this.ref_Arg_ID = ref_Arg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Arg_ID", oldValue, this.ref_Arg_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getArg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MessageArgument R1013_is_a_MessageArgument_inst;
    @Override
    public void setR1013_is_a_MessageArgument( MessageArgument inst ) {
        R1013_is_a_MessageArgument_inst = inst;
    }
    @Override
    public MessageArgument R1013_is_a_MessageArgument() throws XtumlException {
        return R1013_is_a_MessageArgument_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InformalArgument value() {
        return this;
    }

    @Override
    public InformalArgument self() {
        return this;
    }

    @Override
    public InformalArgument oneWhere( IWhere<InformalArgument> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_INFORMALARGUMENT;
    }

}

class EmptyInformalArgument extends ModelInstance<InformalArgument,Sql> implements InformalArgument {

    // attributes
    public UniqueId getArg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MessageArgument R1013_is_a_MessageArgument() {
        return MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }


    @Override
    public String getKeyLetters() {
        return InformalArgumentImpl.KEY_LETTERS;
    }

    @Override
    public InformalArgument value() {
        return this;
    }
    
    @Override
    public InformalArgument self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InformalArgument oneWhere( IWhere<InformalArgument> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return InformalArgumentImpl.EMPTY_INFORMALARGUMENT;
    }

}
