package io.ciera.tool.sql.ooaofooa.invocation.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.RequiredSignal;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.ProvidedSignalImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.RequiredSignalImpl;
import io.ciera.tool.sql.ooaofooa.invocation.SignalInvocation;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class SignalInvocationImpl extends ModelInstance<SignalInvocation,Sql> implements SignalInvocation {

    public static final String KEY_LETTERS = "ACT_SGN";
    public static final SignalInvocation EMPTY_SIGNALINVOCATION = new EmptySignalInvocation();

    private Sql context;

    // constructors
    private SignalInvocationImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        m_sigNameLineNumber = 0;
        m_sigNameColumn = 0;
        m_ownerNameLineNumber = 0;
        m_ownerNameColumn = 0;
        ref_ProvidedSig_Id = UniqueId.random();
        ref_RequiredSig_Id = UniqueId.random();
        ref_Value_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R630_has_target_Value_inst = ValueImpl.EMPTY_VALUE;
        R660_is_invocation_of_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
        R662_takes_V_PAR_set = new V_PARSetImpl();
        R663_is_invocation_of_ProvidedSignal_inst = ProvidedSignalImpl.EMPTY_PROVIDEDSIGNAL;
    }

    private SignalInvocationImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, int m_sigNameLineNumber, int m_sigNameColumn, int m_ownerNameLineNumber, int m_ownerNameColumn, UniqueId ref_ProvidedSig_Id, UniqueId ref_RequiredSig_Id, UniqueId ref_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.m_sigNameLineNumber = m_sigNameLineNumber;
        this.m_sigNameColumn = m_sigNameColumn;
        this.m_ownerNameLineNumber = m_ownerNameLineNumber;
        this.m_ownerNameColumn = m_ownerNameColumn;
        this.ref_ProvidedSig_Id = ref_ProvidedSig_Id;
        this.ref_RequiredSig_Id = ref_RequiredSig_Id;
        this.ref_Value_ID = ref_Value_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R630_has_target_Value_inst = ValueImpl.EMPTY_VALUE;
        R660_is_invocation_of_RequiredSignal_inst = RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
        R662_takes_V_PAR_set = new V_PARSetImpl();
        R663_is_invocation_of_ProvidedSignal_inst = ProvidedSignalImpl.EMPTY_PROVIDEDSIGNAL;
    }

    public static SignalInvocation create( Sql context ) throws XtumlException {
        SignalInvocation newSignalInvocation = new SignalInvocationImpl( context );
        if ( context.addInstance( newSignalInvocation ) ) {
            newSignalInvocation.getRunContext().addChange(new InstanceCreatedDelta(newSignalInvocation, KEY_LETTERS));
            return newSignalInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SignalInvocation create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, int m_sigNameLineNumber, int m_sigNameColumn, int m_ownerNameLineNumber, int m_ownerNameColumn, UniqueId ref_ProvidedSig_Id, UniqueId ref_RequiredSig_Id, UniqueId ref_Value_ID ) throws XtumlException {
        SignalInvocation newSignalInvocation = new SignalInvocationImpl( context, instanceId, ref_Statement_ID, m_sigNameLineNumber, m_sigNameColumn, m_ownerNameLineNumber, m_ownerNameColumn, ref_ProvidedSig_Id, ref_RequiredSig_Id, ref_Value_ID );
        if ( context.addInstance( newSignalInvocation ) ) {
            return newSignalInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Statement_ID.inequality( this.ref_Statement_ID ) ) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R662_takes_V_PAR().isEmpty() ) R662_takes_V_PAR().setStatement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
                return ref_Statement_ID;
    }
    private int m_sigNameLineNumber;
    @Override
    public int getSigNameLineNumber() throws XtumlException {
        checkLiving();
                return m_sigNameLineNumber;
    }
    @Override
    public void setSigNameLineNumber( int m_sigNameLineNumber ) throws XtumlException {
        checkLiving();
        if ( m_sigNameLineNumber != this.m_sigNameLineNumber ) {
            final int oldValue = this.m_sigNameLineNumber;
            this.m_sigNameLineNumber = m_sigNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_sigNameLineNumber", oldValue, this.m_sigNameLineNumber));
        }
    }
    private int m_sigNameColumn;
    @Override
    public int getSigNameColumn() throws XtumlException {
        checkLiving();
                return m_sigNameColumn;
    }
    @Override
    public void setSigNameColumn( int m_sigNameColumn ) throws XtumlException {
        checkLiving();
        if ( m_sigNameColumn != this.m_sigNameColumn ) {
            final int oldValue = this.m_sigNameColumn;
            this.m_sigNameColumn = m_sigNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_sigNameColumn", oldValue, this.m_sigNameColumn));
        }
    }
    private int m_ownerNameLineNumber;
    @Override
    public int getOwnerNameLineNumber() throws XtumlException {
        checkLiving();
                return m_ownerNameLineNumber;
    }
    @Override
    public void setOwnerNameLineNumber( int m_ownerNameLineNumber ) throws XtumlException {
        checkLiving();
        if ( m_ownerNameLineNumber != this.m_ownerNameLineNumber ) {
            final int oldValue = this.m_ownerNameLineNumber;
            this.m_ownerNameLineNumber = m_ownerNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ownerNameLineNumber", oldValue, this.m_ownerNameLineNumber));
        }
    }
    private int m_ownerNameColumn;
    @Override
    public int getOwnerNameColumn() throws XtumlException {
        checkLiving();
                return m_ownerNameColumn;
    }
    @Override
    public void setOwnerNameColumn( int m_ownerNameColumn ) throws XtumlException {
        checkLiving();
        if ( m_ownerNameColumn != this.m_ownerNameColumn ) {
            final int oldValue = this.m_ownerNameColumn;
            this.m_ownerNameColumn = m_ownerNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ownerNameColumn", oldValue, this.m_ownerNameColumn));
        }
    }
    private UniqueId ref_ProvidedSig_Id;
    @Override
    public void setProvidedSig_Id( UniqueId ref_ProvidedSig_Id ) throws XtumlException {
        checkLiving();
        if ( ref_ProvidedSig_Id.inequality( this.ref_ProvidedSig_Id ) ) {
            final UniqueId oldValue = this.ref_ProvidedSig_Id;
            this.ref_ProvidedSig_Id = ref_ProvidedSig_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_ProvidedSig_Id", oldValue, this.ref_ProvidedSig_Id));
        }
    }
    @Override
    public UniqueId getProvidedSig_Id() throws XtumlException {
        checkLiving();
                return ref_ProvidedSig_Id;
    }
    private UniqueId ref_RequiredSig_Id;
    @Override
    public UniqueId getRequiredSig_Id() throws XtumlException {
        checkLiving();
                return ref_RequiredSig_Id;
    }
    @Override
    public void setRequiredSig_Id( UniqueId ref_RequiredSig_Id ) throws XtumlException {
        checkLiving();
        if ( ref_RequiredSig_Id.inequality( this.ref_RequiredSig_Id ) ) {
            final UniqueId oldValue = this.ref_RequiredSig_Id;
            this.ref_RequiredSig_Id = ref_RequiredSig_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_RequiredSig_Id", oldValue, this.ref_RequiredSig_Id));
        }
    }
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
                return ref_Value_ID;
    }
    @Override
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Value_ID.inequality( this.ref_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Value R630_has_target_Value_inst;
    @Override
    public void setR630_has_target_Value( Value inst ) {
        R630_has_target_Value_inst = inst;
    }
    @Override
    public Value R630_has_target_Value() throws XtumlException {
        return R630_has_target_Value_inst;
    }
    private RequiredSignal R660_is_invocation_of_RequiredSignal_inst;
    @Override
    public void setR660_is_invocation_of_RequiredSignal( RequiredSignal inst ) {
        R660_is_invocation_of_RequiredSignal_inst = inst;
    }
    @Override
    public RequiredSignal R660_is_invocation_of_RequiredSignal() throws XtumlException {
        return R660_is_invocation_of_RequiredSignal_inst;
    }
    private V_PARSet R662_takes_V_PAR_set;
    @Override
    public void addR662_takes_V_PAR( V_PAR inst ) {
        R662_takes_V_PAR_set.add(inst);
    }
    @Override
    public void removeR662_takes_V_PAR( V_PAR inst ) {
        R662_takes_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R662_takes_V_PAR() throws XtumlException {
        return R662_takes_V_PAR_set;
    }
    private ProvidedSignal R663_is_invocation_of_ProvidedSignal_inst;
    @Override
    public void setR663_is_invocation_of_ProvidedSignal( ProvidedSignal inst ) {
        R663_is_invocation_of_ProvidedSignal_inst = inst;
    }
    @Override
    public ProvidedSignal R663_is_invocation_of_ProvidedSignal() throws XtumlException {
        return R663_is_invocation_of_ProvidedSignal_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SignalInvocation value() {
        return this;
    }

    @Override
    public SignalInvocation self() {
        return this;
    }

    @Override
    public SignalInvocation oneWhere( IWhere<SignalInvocation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_SIGNALINVOCATION;
    }

}

class EmptySignalInvocation extends ModelInstance<SignalInvocation,Sql> implements SignalInvocation {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getSigNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSigNameLineNumber( int m_sigNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getSigNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSigNameColumn( int m_sigNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOwnerNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOwnerNameLineNumber( int m_ownerNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOwnerNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOwnerNameColumn( int m_ownerNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setProvidedSig_Id( UniqueId ref_ProvidedSig_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getProvidedSig_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRequiredSig_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRequiredSig_Id( UniqueId ref_RequiredSig_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Value R630_has_target_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public RequiredSignal R660_is_invocation_of_RequiredSignal() {
        return RequiredSignalImpl.EMPTY_REQUIREDSIGNAL;
    }
    @Override
    public V_PARSet R662_takes_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public ProvidedSignal R663_is_invocation_of_ProvidedSignal() {
        return ProvidedSignalImpl.EMPTY_PROVIDEDSIGNAL;
    }


    @Override
    public String getKeyLetters() {
        return SignalInvocationImpl.KEY_LETTERS;
    }

    @Override
    public SignalInvocation value() {
        return this;
    }
    
    @Override
    public SignalInvocation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SignalInvocation oneWhere( IWhere<SignalInvocation> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return SignalInvocationImpl.EMPTY_SIGNALINVOCATION;
    }

}
