package io.ciera.tool.sql.ooaofooa.invocation.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.invocation.ReturnStmt;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class ReturnStmtImpl extends ModelInstance<ReturnStmt,Sql> implements ReturnStmt {

    public static final String KEY_LETTERS = "ACT_RET";
    public static final ReturnStmt EMPTY_RETURNSTMT = new EmptyReturnStmt();

    private Sql context;

    // constructors
    private ReturnStmtImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Value_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R668_has_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private ReturnStmtImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Value_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Value_ID = ref_Value_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R668_has_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static ReturnStmt create( Sql context ) throws XtumlException {
        ReturnStmt newReturnStmt = new ReturnStmtImpl( context );
        if ( context.addInstance( newReturnStmt ) ) {
            newReturnStmt.getRunContext().addChange(new InstanceCreatedDelta(newReturnStmt, KEY_LETTERS));
            return newReturnStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReturnStmt create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Value_ID ) throws XtumlException {
        ReturnStmt newReturnStmt = new ReturnStmtImpl( context, instanceId, ref_Statement_ID, ref_Value_ID );
        if ( context.addInstance( newReturnStmt ) ) {
            return newReturnStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Statement_ID.inequality( this.ref_Statement_ID ) ) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
                return ref_Statement_ID;
    }
    private UniqueId ref_Value_ID;
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
                return ref_Value_ID;
    }
    @Override
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Value_ID.inequality( this.ref_Value_ID ) ) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Value R668_has_Value_inst;
    @Override
    public void setR668_has_Value( Value inst ) {
        R668_has_Value_inst = inst;
    }
    @Override
    public Value R668_has_Value() throws XtumlException {
        return R668_has_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReturnStmt value() {
        return this;
    }

    @Override
    public ReturnStmt self() {
        return this;
    }

    @Override
    public ReturnStmt oneWhere( IWhere<ReturnStmt> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_RETURNSTMT;
    }

}

class EmptyReturnStmt extends ModelInstance<ReturnStmt,Sql> implements ReturnStmt {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Value R668_has_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return ReturnStmtImpl.KEY_LETTERS;
    }

    @Override
    public ReturnStmt value() {
        return this;
    }
    
    @Override
    public ReturnStmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReturnStmt oneWhere( IWhere<ReturnStmt> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return ReturnStmtImpl.EMPTY_RETURNSTMT;
    }

}
