package io.ciera.tool.sql.ooaofooa.instanceaccess.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.instanceaccess.AssignToMember;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class AssignToMemberImpl extends ModelInstance<AssignToMember,Sql> implements AssignToMember {

    public static final String KEY_LETTERS = "ACT_AI";
    public static final AssignToMember EMPTY_ASSIGNTOMEMBER = new EmptyAssignToMember();

    private Sql context;

    // constructors
    private AssignToMemberImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_r_Value_ID = UniqueId.random();
        ref_l_Value_ID = UniqueId.random();
        m_attributeLineNumber = 0;
        m_attributeColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R609_reads_Value_inst = ValueImpl.EMPTY_VALUE;
        R689_writes_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private AssignToMemberImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_r_Value_ID, UniqueId ref_l_Value_ID, int m_attributeLineNumber, int m_attributeColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_r_Value_ID = ref_r_Value_ID;
        this.ref_l_Value_ID = ref_l_Value_ID;
        this.m_attributeLineNumber = m_attributeLineNumber;
        this.m_attributeColumn = m_attributeColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R609_reads_Value_inst = ValueImpl.EMPTY_VALUE;
        R689_writes_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static AssignToMember create( Sql context ) throws XtumlException {
        AssignToMember newAssignToMember = new AssignToMemberImpl( context );
        if ( context.addInstance( newAssignToMember ) ) {
            newAssignToMember.getRunContext().addChange(new InstanceCreatedDelta(newAssignToMember, KEY_LETTERS));
            return newAssignToMember;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AssignToMember create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_r_Value_ID, UniqueId ref_l_Value_ID, int m_attributeLineNumber, int m_attributeColumn ) throws XtumlException {
        AssignToMember newAssignToMember = new AssignToMemberImpl( context, instanceId, ref_Statement_ID, ref_r_Value_ID, ref_l_Value_ID, m_attributeLineNumber, m_attributeColumn );
        if ( context.addInstance( newAssignToMember ) ) {
            return newAssignToMember;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        checkLiving();
        if ( ref_Statement_ID.inequality( this.ref_Statement_ID ) ) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
                return ref_Statement_ID;
    }
    private UniqueId ref_r_Value_ID;
    @Override
    public void setR_Value_ID( UniqueId ref_r_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_r_Value_ID.inequality( this.ref_r_Value_ID ) ) {
            final UniqueId oldValue = this.ref_r_Value_ID;
            this.ref_r_Value_ID = ref_r_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_r_Value_ID", oldValue, this.ref_r_Value_ID));
        }
    }
    @Override
    public UniqueId getR_Value_ID() throws XtumlException {
        checkLiving();
                return ref_r_Value_ID;
    }
    private UniqueId ref_l_Value_ID;
    @Override
    public UniqueId getL_Value_ID() throws XtumlException {
        checkLiving();
                return ref_l_Value_ID;
    }
    @Override
    public void setL_Value_ID( UniqueId ref_l_Value_ID ) throws XtumlException {
        checkLiving();
        if ( ref_l_Value_ID.inequality( this.ref_l_Value_ID ) ) {
            final UniqueId oldValue = this.ref_l_Value_ID;
            this.ref_l_Value_ID = ref_l_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_l_Value_ID", oldValue, this.ref_l_Value_ID));
        }
    }
    private int m_attributeLineNumber;
    @Override
    public void setAttributeLineNumber( int m_attributeLineNumber ) throws XtumlException {
        checkLiving();
        if ( m_attributeLineNumber != this.m_attributeLineNumber ) {
            final int oldValue = this.m_attributeLineNumber;
            this.m_attributeLineNumber = m_attributeLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_attributeLineNumber", oldValue, this.m_attributeLineNumber));
        }
    }
    @Override
    public int getAttributeLineNumber() throws XtumlException {
        checkLiving();
                return m_attributeLineNumber;
    }
    private int m_attributeColumn;
    @Override
    public void setAttributeColumn( int m_attributeColumn ) throws XtumlException {
        checkLiving();
        if ( m_attributeColumn != this.m_attributeColumn ) {
            final int oldValue = this.m_attributeColumn;
            this.m_attributeColumn = m_attributeColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_attributeColumn", oldValue, this.m_attributeColumn));
        }
    }
    @Override
    public int getAttributeColumn() throws XtumlException {
        checkLiving();
                return m_attributeColumn;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Value R609_reads_Value_inst;
    @Override
    public void setR609_reads_Value( Value inst ) {
        R609_reads_Value_inst = inst;
    }
    @Override
    public Value R609_reads_Value() throws XtumlException {
        return R609_reads_Value_inst;
    }
    private Value R689_writes_Value_inst;
    @Override
    public void setR689_writes_Value( Value inst ) {
        R689_writes_Value_inst = inst;
    }
    @Override
    public Value R689_writes_Value() throws XtumlException {
        return R689_writes_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AssignToMember value() {
        return this;
    }

    @Override
    public AssignToMember self() {
        return this;
    }

    @Override
    public AssignToMember oneWhere( IWhere<AssignToMember> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_ASSIGNTOMEMBER;
    }

}

class EmptyAssignToMember extends ModelInstance<AssignToMember,Sql> implements AssignToMember {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setR_Value_ID( UniqueId ref_r_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getR_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getL_Value_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setL_Value_ID( UniqueId ref_l_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAttributeLineNumber( int m_attributeLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getAttributeLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAttributeColumn( int m_attributeColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getAttributeColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Value R609_reads_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public Value R689_writes_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return AssignToMemberImpl.KEY_LETTERS;
    }

    @Override
    public AssignToMember value() {
        return this;
    }
    
    @Override
    public AssignToMember self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AssignToMember oneWhere( IWhere<AssignToMember> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return AssignToMemberImpl.EMPTY_ASSIGNTOMEMBER;
    }

}
