package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstanceSet;
import io.ciera.tool.sql.ooaofooa.instance.I_INSSet;
import io.ciera.tool.sql.ooaofooa.instance.Monitor;
import io.ciera.tool.sql.ooaofooa.instance.MonitorSet;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceSetImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.I_INSSetImpl;

import java.util.Arrays;
import java.util.List;


public class MonitorSetImpl extends InstanceSet<MonitorSet,Monitor> implements MonitorSet {

    // attributes
    @Override
    public void setInst_ID( UniqueId ref_Inst_ID ) throws XtumlException {
        for ( Monitor monitor : this ) monitor.setInst_ID( ref_Inst_ID );
    }
    @Override
    public void setEnabled( boolean m_enabled ) throws XtumlException {
        for ( Monitor monitor : this ) monitor.setEnabled( m_enabled );
    }
    @Override
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        for ( Monitor monitor : this ) monitor.setExecution_Engine_ID( ref_Execution_Engine_ID );
    }


    // selections
    @Override
    public ComponentInstanceSet R2949_monitored_by_ComponentInstance() throws XtumlException {
        ComponentInstanceSet componentinstanceset = new ComponentInstanceSetImpl();
        for ( Monitor monitor : this ) componentinstanceset.add( monitor.R2949_monitored_by_ComponentInstance() );
        return componentinstanceset;
    }
    @Override
    public I_INSSet R2949_monitors_I_INS() throws XtumlException {
        I_INSSet i_insset = new I_INSSetImpl();
        for ( Monitor monitor : this ) i_insset.add( monitor.R2949_monitors_I_INS() );
        return i_insset;
    }


    @Override
    public Monitor nullElement() {
        return MonitorImpl.EMPTY_MONITOR;
    }

    @Override
    public MonitorSet emptySet() {
      return new MonitorSetImpl();
    }

    @Override
    public MonitorSet value() {
        return this;
    }

    @Override
    public List<Monitor> elements() {
        return Arrays.asList(toArray(new Monitor[0]));
    }

}
