package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperation;
import io.ciera.tool.sql.ooaofooa.component.InterfaceOperationSet;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameterSet;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceOperationSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstant;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstantSet;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantSetImpl;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorService;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceParameter;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceParameterSet;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceSet;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameter;
import io.ciera.tool.sql.ooaofooa.domain.BridgeParameterSet;
import io.ciera.tool.sql.ooaofooa.domain.BridgeSet;
import io.ciera.tool.sql.ooaofooa.domain.CoreDataType;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.EnumerationDataType;
import io.ciera.tool.sql.ooaofooa.domain.FunctionParameter;
import io.ciera.tool.sql.ooaofooa.domain.FunctionParameterSet;
import io.ciera.tool.sql.ooaofooa.domain.InstanceReferenceDataType;
import io.ciera.tool.sql.ooaofooa.domain.S_SYNC;
import io.ciera.tool.sql.ooaofooa.domain.S_SYNCSet;
import io.ciera.tool.sql.ooaofooa.domain.StructureMember;
import io.ciera.tool.sql.ooaofooa.domain.StructureMemberSet;
import io.ciera.tool.sql.ooaofooa.domain.StructuredDataType;
import io.ciera.tool.sql.ooaofooa.domain.UserDataType;
import io.ciera.tool.sql.ooaofooa.domain.UserDataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.CoreDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.EnumerationDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.FunctionParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.InstanceReferenceDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_SYNCSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructureMemberSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructuredDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.UserDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.UserDataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItem;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItemSet;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventDataItemSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTRSet;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFRSet;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameter;
import io.ciera.tool.sql.ooaofooa.subsystem.OperationParameterSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.OperationParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.value.TransientVar;
import io.ciera.tool.sql.ooaofooa.value.TransientVarSet;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.V_VARSet;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.ValueSet;
import io.ciera.tool.sql.ooaofooa.value.impl.TransientVarSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueSetImpl;


public class DataTypeImpl extends ModelInstance<DataType,Sql> implements DataType {

    public static final String KEY_LETTERS = "S_DT";
    public static final DataType EMPTY_DATATYPE = new EmptyDataType();

    private Sql context;

    // constructors
    private DataTypeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        m_Dom_IDdeprecated = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_DefaultValue = "";
        R114_is_defined_by_O_ATTR_set = new O_ATTRSetImpl();
        R116_defines_the_type_of_return_code_O_TFR_set = new O_TFRSetImpl();
        R118_defines_the_type_of__OperationParameter_set = new OperationParameterSetImpl();
        R1500_defines_the_type_of_SymbolicConstant_set = new SymbolicConstantSetImpl();
        R1653_TerminatorServiceParameter_set = new TerminatorServiceParameterSetImpl();
        R1656_TerminatorService_set = new TerminatorServiceSetImpl();
        R17_is_a_CoreDataType_inst = CoreDataTypeImpl.EMPTY_COREDATATYPE;
        R17_is_a_EnumerationDataType_inst = EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
        R17_is_a_InstanceReferenceDataType_inst = InstanceReferenceDataTypeImpl.EMPTY_INSTANCEREFERENCEDATATYPE;
        R17_is_a_StructuredDataType_inst = StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
        R17_is_a_UserDataType_inst = UserDataTypeImpl.EMPTY_USERDATATYPE;
        R18_defines_domain_of_UserDataType_set = new UserDataTypeSetImpl();
        R20_defines_the_return_value_Bridge_set = new BridgeSetImpl();
        R22_defines_the_type_of_BridgeParameter_set = new BridgeParameterSetImpl();
        R25_defines_return_type_S_SYNC_set = new S_SYNCSetImpl();
        R26_describes_type_of_FunctionParameter_set = new FunctionParameterSetImpl();
        R4007_Defines_the_type_PropertyParameter_set = new PropertyParameterSetImpl();
        R4008_defines_return_type_InterfaceOperation_set = new InterfaceOperationSetImpl();
        R423_is_basis_of_Type_inst = TypeImpl.EMPTY_TYPE;
        R45_defines_the_type_of_StructureMember_set = new StructureMemberSetImpl();
        R524_defines_the_type_of_StateMachineEventDataItem_set = new StateMachineEventDataItemSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R820_is_type_of_Value_set = new ValueSetImpl();
        R821_is_type_of_TransientVar_set = new TransientVarSetImpl();
        R848_is_type_of_V_VAR_set = new V_VARSetImpl();
    }

    private DataTypeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, UniqueId m_Dom_IDdeprecated, String m_Name, String m_Descrip, String m_DefaultValue ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Dom_IDdeprecated = m_Dom_IDdeprecated;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_DefaultValue = m_DefaultValue;
        R114_is_defined_by_O_ATTR_set = new O_ATTRSetImpl();
        R116_defines_the_type_of_return_code_O_TFR_set = new O_TFRSetImpl();
        R118_defines_the_type_of__OperationParameter_set = new OperationParameterSetImpl();
        R1500_defines_the_type_of_SymbolicConstant_set = new SymbolicConstantSetImpl();
        R1653_TerminatorServiceParameter_set = new TerminatorServiceParameterSetImpl();
        R1656_TerminatorService_set = new TerminatorServiceSetImpl();
        R17_is_a_CoreDataType_inst = CoreDataTypeImpl.EMPTY_COREDATATYPE;
        R17_is_a_EnumerationDataType_inst = EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
        R17_is_a_InstanceReferenceDataType_inst = InstanceReferenceDataTypeImpl.EMPTY_INSTANCEREFERENCEDATATYPE;
        R17_is_a_StructuredDataType_inst = StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
        R17_is_a_UserDataType_inst = UserDataTypeImpl.EMPTY_USERDATATYPE;
        R18_defines_domain_of_UserDataType_set = new UserDataTypeSetImpl();
        R20_defines_the_return_value_Bridge_set = new BridgeSetImpl();
        R22_defines_the_type_of_BridgeParameter_set = new BridgeParameterSetImpl();
        R25_defines_return_type_S_SYNC_set = new S_SYNCSetImpl();
        R26_describes_type_of_FunctionParameter_set = new FunctionParameterSetImpl();
        R4007_Defines_the_type_PropertyParameter_set = new PropertyParameterSetImpl();
        R4008_defines_return_type_InterfaceOperation_set = new InterfaceOperationSetImpl();
        R423_is_basis_of_Type_inst = TypeImpl.EMPTY_TYPE;
        R45_defines_the_type_of_StructureMember_set = new StructureMemberSetImpl();
        R524_defines_the_type_of_StateMachineEventDataItem_set = new StateMachineEventDataItemSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R820_is_type_of_Value_set = new ValueSetImpl();
        R821_is_type_of_TransientVar_set = new TransientVarSetImpl();
        R848_is_type_of_V_VAR_set = new V_VARSetImpl();
    }

    public static DataType create( Sql context ) throws XtumlException {
        DataType newDataType = new DataTypeImpl( context );
        if ( context.addInstance( newDataType ) ) {
            newDataType.getRunContext().addChange(new InstanceCreatedDelta(newDataType, KEY_LETTERS));
            return newDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static DataType create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, UniqueId m_Dom_IDdeprecated, String m_Name, String m_Descrip, String m_DefaultValue ) throws XtumlException {
        DataType newDataType = new DataTypeImpl( context, instanceId, ref_DT_ID, m_Dom_IDdeprecated, m_Name, m_Descrip, m_DefaultValue );
        if ( context.addInstance( newDataType ) ) {
            return newDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        checkLiving();
        if ( ref_DT_ID.inequality( this.ref_DT_ID ) ) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
            if ( !R848_is_type_of_V_VAR().isEmpty() ) R848_is_type_of_V_VAR().setDT_ID( ref_DT_ID );
            if ( !R4008_defines_return_type_InterfaceOperation().isEmpty() ) R4008_defines_return_type_InterfaceOperation().setDT_ID( ref_DT_ID );
            if ( !R118_defines_the_type_of__OperationParameter().isEmpty() ) R118_defines_the_type_of__OperationParameter().setDT_ID( ref_DT_ID );
            if ( !R1656_TerminatorService().isEmpty() ) R1656_TerminatorService().setDT_ID( ref_DT_ID );
            if ( !R1653_TerminatorServiceParameter().isEmpty() ) R1653_TerminatorServiceParameter().setDT_ID( ref_DT_ID );
            if ( !R821_is_type_of_TransientVar().isEmpty() ) R821_is_type_of_TransientVar().setDT_ID( ref_DT_ID );
            if ( !R17_is_a_InstanceReferenceDataType().isEmpty() ) R17_is_a_InstanceReferenceDataType().setDT_ID( ref_DT_ID );
            if ( !R820_is_type_of_Value().isEmpty() ) R820_is_type_of_Value().setDT_ID( ref_DT_ID );
            if ( !R25_defines_return_type_S_SYNC().isEmpty() ) R25_defines_return_type_S_SYNC().setDT_ID( ref_DT_ID );
            if ( !R18_defines_domain_of_UserDataType().isEmpty() ) R18_defines_domain_of_UserDataType().setCDT_DT_ID( ref_DT_ID );
            if ( !R22_defines_the_type_of_BridgeParameter().isEmpty() ) R22_defines_the_type_of_BridgeParameter().setDT_ID( ref_DT_ID );
            if ( !R17_is_a_StructuredDataType().isEmpty() ) R17_is_a_StructuredDataType().setDT_ID( ref_DT_ID );
            if ( !R45_defines_the_type_of_StructureMember().isEmpty() ) R45_defines_the_type_of_StructureMember().setDT_ID( ref_DT_ID );
            if ( !R114_is_defined_by_O_ATTR().isEmpty() ) R114_is_defined_by_O_ATTR().setDT_ID( ref_DT_ID );
            if ( !R4007_Defines_the_type_PropertyParameter().isEmpty() ) R4007_Defines_the_type_PropertyParameter().setDT_ID( ref_DT_ID );
            if ( !R17_is_a_CoreDataType().isEmpty() ) R17_is_a_CoreDataType().setDT_ID( ref_DT_ID );
            if ( !R524_defines_the_type_of_StateMachineEventDataItem().isEmpty() ) R524_defines_the_type_of_StateMachineEventDataItem().setDT_ID( ref_DT_ID );
            if ( !R116_defines_the_type_of_return_code_O_TFR().isEmpty() ) R116_defines_the_type_of_return_code_O_TFR().setDT_ID( ref_DT_ID );
            if ( !R1500_defines_the_type_of_SymbolicConstant().isEmpty() ) R1500_defines_the_type_of_SymbolicConstant().setDT_ID( ref_DT_ID );
            if ( !R423_is_basis_of_Type().isEmpty() ) R423_is_basis_of_Type().setDT_ID( ref_DT_ID );
            if ( !R26_describes_type_of_FunctionParameter().isEmpty() ) R26_describes_type_of_FunctionParameter().setDT_ID( ref_DT_ID );
            if ( !R17_is_a_EnumerationDataType().isEmpty() ) R17_is_a_EnumerationDataType().setDT_ID( ref_DT_ID );
            if ( !R20_defines_the_return_value_Bridge().isEmpty() ) R20_defines_the_return_value_Bridge().setDT_ID( ref_DT_ID );
            if ( !R17_is_a_UserDataType().isEmpty() ) R17_is_a_UserDataType().setDT_ID( ref_DT_ID );
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
                return ref_DT_ID;
    }
    private UniqueId m_Dom_IDdeprecated;
    @Override
    public void setDom_IDdeprecated( UniqueId m_Dom_IDdeprecated ) throws XtumlException {
        checkLiving();
        if ( m_Dom_IDdeprecated.inequality( this.m_Dom_IDdeprecated ) ) {
            final UniqueId oldValue = this.m_Dom_IDdeprecated;
            this.m_Dom_IDdeprecated = m_Dom_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dom_IDdeprecated", oldValue, this.m_Dom_IDdeprecated));
        }
    }
    @Override
    public UniqueId getDom_IDdeprecated() throws XtumlException {
        checkLiving();
                return m_Dom_IDdeprecated;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
                return m_Name;
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Name, this.m_Name ) ) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
                return m_Descrip;
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_Descrip, this.m_Descrip ) ) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_DefaultValue;
    @Override
    public String getDefaultValue() throws XtumlException {
        checkLiving();
                return m_DefaultValue;
    }
    @Override
    public void setDefaultValue( String m_DefaultValue ) throws XtumlException {
        checkLiving();
        if ( StringUtil.inequality( m_DefaultValue, this.m_DefaultValue ) ) {
            final String oldValue = this.m_DefaultValue;
            this.m_DefaultValue = m_DefaultValue;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_DefaultValue", oldValue, this.m_DefaultValue));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private O_ATTRSet R114_is_defined_by_O_ATTR_set;
    @Override
    public void addR114_is_defined_by_O_ATTR( O_ATTR inst ) {
        R114_is_defined_by_O_ATTR_set.add(inst);
    }
    @Override
    public void removeR114_is_defined_by_O_ATTR( O_ATTR inst ) {
        R114_is_defined_by_O_ATTR_set.remove(inst);
    }
    @Override
    public O_ATTRSet R114_is_defined_by_O_ATTR() throws XtumlException {
        return R114_is_defined_by_O_ATTR_set;
    }
    private O_TFRSet R116_defines_the_type_of_return_code_O_TFR_set;
    @Override
    public void addR116_defines_the_type_of_return_code_O_TFR( O_TFR inst ) {
        R116_defines_the_type_of_return_code_O_TFR_set.add(inst);
    }
    @Override
    public void removeR116_defines_the_type_of_return_code_O_TFR( O_TFR inst ) {
        R116_defines_the_type_of_return_code_O_TFR_set.remove(inst);
    }
    @Override
    public O_TFRSet R116_defines_the_type_of_return_code_O_TFR() throws XtumlException {
        return R116_defines_the_type_of_return_code_O_TFR_set;
    }
    private OperationParameterSet R118_defines_the_type_of__OperationParameter_set;
    @Override
    public void addR118_defines_the_type_of__OperationParameter( OperationParameter inst ) {
        R118_defines_the_type_of__OperationParameter_set.add(inst);
    }
    @Override
    public void removeR118_defines_the_type_of__OperationParameter( OperationParameter inst ) {
        R118_defines_the_type_of__OperationParameter_set.remove(inst);
    }
    @Override
    public OperationParameterSet R118_defines_the_type_of__OperationParameter() throws XtumlException {
        return R118_defines_the_type_of__OperationParameter_set;
    }
    private SymbolicConstantSet R1500_defines_the_type_of_SymbolicConstant_set;
    @Override
    public void addR1500_defines_the_type_of_SymbolicConstant( SymbolicConstant inst ) {
        R1500_defines_the_type_of_SymbolicConstant_set.add(inst);
    }
    @Override
    public void removeR1500_defines_the_type_of_SymbolicConstant( SymbolicConstant inst ) {
        R1500_defines_the_type_of_SymbolicConstant_set.remove(inst);
    }
    @Override
    public SymbolicConstantSet R1500_defines_the_type_of_SymbolicConstant() throws XtumlException {
        return R1500_defines_the_type_of_SymbolicConstant_set;
    }
    private TerminatorServiceParameterSet R1653_TerminatorServiceParameter_set;
    @Override
    public void addR1653_TerminatorServiceParameter( TerminatorServiceParameter inst ) {
        R1653_TerminatorServiceParameter_set.add(inst);
    }
    @Override
    public void removeR1653_TerminatorServiceParameter( TerminatorServiceParameter inst ) {
        R1653_TerminatorServiceParameter_set.remove(inst);
    }
    @Override
    public TerminatorServiceParameterSet R1653_TerminatorServiceParameter() throws XtumlException {
        return R1653_TerminatorServiceParameter_set;
    }
    private TerminatorServiceSet R1656_TerminatorService_set;
    @Override
    public void addR1656_TerminatorService( TerminatorService inst ) {
        R1656_TerminatorService_set.add(inst);
    }
    @Override
    public void removeR1656_TerminatorService( TerminatorService inst ) {
        R1656_TerminatorService_set.remove(inst);
    }
    @Override
    public TerminatorServiceSet R1656_TerminatorService() throws XtumlException {
        return R1656_TerminatorService_set;
    }
    private CoreDataType R17_is_a_CoreDataType_inst;
    @Override
    public void setR17_is_a_CoreDataType( CoreDataType inst ) {
        R17_is_a_CoreDataType_inst = inst;
    }
    @Override
    public CoreDataType R17_is_a_CoreDataType() throws XtumlException {
        return R17_is_a_CoreDataType_inst;
    }
    private EnumerationDataType R17_is_a_EnumerationDataType_inst;
    @Override
    public void setR17_is_a_EnumerationDataType( EnumerationDataType inst ) {
        R17_is_a_EnumerationDataType_inst = inst;
    }
    @Override
    public EnumerationDataType R17_is_a_EnumerationDataType() throws XtumlException {
        return R17_is_a_EnumerationDataType_inst;
    }
    private InstanceReferenceDataType R17_is_a_InstanceReferenceDataType_inst;
    @Override
    public void setR17_is_a_InstanceReferenceDataType( InstanceReferenceDataType inst ) {
        R17_is_a_InstanceReferenceDataType_inst = inst;
    }
    @Override
    public InstanceReferenceDataType R17_is_a_InstanceReferenceDataType() throws XtumlException {
        return R17_is_a_InstanceReferenceDataType_inst;
    }
    private StructuredDataType R17_is_a_StructuredDataType_inst;
    @Override
    public void setR17_is_a_StructuredDataType( StructuredDataType inst ) {
        R17_is_a_StructuredDataType_inst = inst;
    }
    @Override
    public StructuredDataType R17_is_a_StructuredDataType() throws XtumlException {
        return R17_is_a_StructuredDataType_inst;
    }
    private UserDataType R17_is_a_UserDataType_inst;
    @Override
    public void setR17_is_a_UserDataType( UserDataType inst ) {
        R17_is_a_UserDataType_inst = inst;
    }
    @Override
    public UserDataType R17_is_a_UserDataType() throws XtumlException {
        return R17_is_a_UserDataType_inst;
    }
    private UserDataTypeSet R18_defines_domain_of_UserDataType_set;
    @Override
    public void addR18_defines_domain_of_UserDataType( UserDataType inst ) {
        R18_defines_domain_of_UserDataType_set.add(inst);
    }
    @Override
    public void removeR18_defines_domain_of_UserDataType( UserDataType inst ) {
        R18_defines_domain_of_UserDataType_set.remove(inst);
    }
    @Override
    public UserDataTypeSet R18_defines_domain_of_UserDataType() throws XtumlException {
        return R18_defines_domain_of_UserDataType_set;
    }
    private BridgeSet R20_defines_the_return_value_Bridge_set;
    @Override
    public void addR20_defines_the_return_value_Bridge( Bridge inst ) {
        R20_defines_the_return_value_Bridge_set.add(inst);
    }
    @Override
    public void removeR20_defines_the_return_value_Bridge( Bridge inst ) {
        R20_defines_the_return_value_Bridge_set.remove(inst);
    }
    @Override
    public BridgeSet R20_defines_the_return_value_Bridge() throws XtumlException {
        return R20_defines_the_return_value_Bridge_set;
    }
    private BridgeParameterSet R22_defines_the_type_of_BridgeParameter_set;
    @Override
    public void addR22_defines_the_type_of_BridgeParameter( BridgeParameter inst ) {
        R22_defines_the_type_of_BridgeParameter_set.add(inst);
    }
    @Override
    public void removeR22_defines_the_type_of_BridgeParameter( BridgeParameter inst ) {
        R22_defines_the_type_of_BridgeParameter_set.remove(inst);
    }
    @Override
    public BridgeParameterSet R22_defines_the_type_of_BridgeParameter() throws XtumlException {
        return R22_defines_the_type_of_BridgeParameter_set;
    }
    private S_SYNCSet R25_defines_return_type_S_SYNC_set;
    @Override
    public void addR25_defines_return_type_S_SYNC( S_SYNC inst ) {
        R25_defines_return_type_S_SYNC_set.add(inst);
    }
    @Override
    public void removeR25_defines_return_type_S_SYNC( S_SYNC inst ) {
        R25_defines_return_type_S_SYNC_set.remove(inst);
    }
    @Override
    public S_SYNCSet R25_defines_return_type_S_SYNC() throws XtumlException {
        return R25_defines_return_type_S_SYNC_set;
    }
    private FunctionParameterSet R26_describes_type_of_FunctionParameter_set;
    @Override
    public void addR26_describes_type_of_FunctionParameter( FunctionParameter inst ) {
        R26_describes_type_of_FunctionParameter_set.add(inst);
    }
    @Override
    public void removeR26_describes_type_of_FunctionParameter( FunctionParameter inst ) {
        R26_describes_type_of_FunctionParameter_set.remove(inst);
    }
    @Override
    public FunctionParameterSet R26_describes_type_of_FunctionParameter() throws XtumlException {
        return R26_describes_type_of_FunctionParameter_set;
    }
    private PropertyParameterSet R4007_Defines_the_type_PropertyParameter_set;
    @Override
    public void addR4007_Defines_the_type_PropertyParameter( PropertyParameter inst ) {
        R4007_Defines_the_type_PropertyParameter_set.add(inst);
    }
    @Override
    public void removeR4007_Defines_the_type_PropertyParameter( PropertyParameter inst ) {
        R4007_Defines_the_type_PropertyParameter_set.remove(inst);
    }
    @Override
    public PropertyParameterSet R4007_Defines_the_type_PropertyParameter() throws XtumlException {
        return R4007_Defines_the_type_PropertyParameter_set;
    }
    private InterfaceOperationSet R4008_defines_return_type_InterfaceOperation_set;
    @Override
    public void addR4008_defines_return_type_InterfaceOperation( InterfaceOperation inst ) {
        R4008_defines_return_type_InterfaceOperation_set.add(inst);
    }
    @Override
    public void removeR4008_defines_return_type_InterfaceOperation( InterfaceOperation inst ) {
        R4008_defines_return_type_InterfaceOperation_set.remove(inst);
    }
    @Override
    public InterfaceOperationSet R4008_defines_return_type_InterfaceOperation() throws XtumlException {
        return R4008_defines_return_type_InterfaceOperation_set;
    }
    private Type R423_is_basis_of_Type_inst;
    @Override
    public void setR423_is_basis_of_Type( Type inst ) {
        R423_is_basis_of_Type_inst = inst;
    }
    @Override
    public Type R423_is_basis_of_Type() throws XtumlException {
        return R423_is_basis_of_Type_inst;
    }
    private StructureMemberSet R45_defines_the_type_of_StructureMember_set;
    @Override
    public void addR45_defines_the_type_of_StructureMember( StructureMember inst ) {
        R45_defines_the_type_of_StructureMember_set.add(inst);
    }
    @Override
    public void removeR45_defines_the_type_of_StructureMember( StructureMember inst ) {
        R45_defines_the_type_of_StructureMember_set.remove(inst);
    }
    @Override
    public StructureMemberSet R45_defines_the_type_of_StructureMember() throws XtumlException {
        return R45_defines_the_type_of_StructureMember_set;
    }
    private StateMachineEventDataItemSet R524_defines_the_type_of_StateMachineEventDataItem_set;
    @Override
    public void addR524_defines_the_type_of_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R524_defines_the_type_of_StateMachineEventDataItem_set.add(inst);
    }
    @Override
    public void removeR524_defines_the_type_of_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R524_defines_the_type_of_StateMachineEventDataItem_set.remove(inst);
    }
    @Override
    public StateMachineEventDataItemSet R524_defines_the_type_of_StateMachineEventDataItem() throws XtumlException {
        return R524_defines_the_type_of_StateMachineEventDataItem_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }
    private ValueSet R820_is_type_of_Value_set;
    @Override
    public void addR820_is_type_of_Value( Value inst ) {
        R820_is_type_of_Value_set.add(inst);
    }
    @Override
    public void removeR820_is_type_of_Value( Value inst ) {
        R820_is_type_of_Value_set.remove(inst);
    }
    @Override
    public ValueSet R820_is_type_of_Value() throws XtumlException {
        return R820_is_type_of_Value_set;
    }
    private TransientVarSet R821_is_type_of_TransientVar_set;
    @Override
    public void addR821_is_type_of_TransientVar( TransientVar inst ) {
        R821_is_type_of_TransientVar_set.add(inst);
    }
    @Override
    public void removeR821_is_type_of_TransientVar( TransientVar inst ) {
        R821_is_type_of_TransientVar_set.remove(inst);
    }
    @Override
    public TransientVarSet R821_is_type_of_TransientVar() throws XtumlException {
        return R821_is_type_of_TransientVar_set;
    }
    private V_VARSet R848_is_type_of_V_VAR_set;
    @Override
    public void addR848_is_type_of_V_VAR( V_VAR inst ) {
        R848_is_type_of_V_VAR_set.add(inst);
    }
    @Override
    public void removeR848_is_type_of_V_VAR( V_VAR inst ) {
        R848_is_type_of_V_VAR_set.remove(inst);
    }
    @Override
    public V_VARSet R848_is_type_of_V_VAR() throws XtumlException {
        return R848_is_type_of_V_VAR_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public DataType value() {
        return this;
    }

    @Override
    public DataType self() {
        return this;
    }

    @Override
    public DataType oneWhere( IWhere<DataType> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_DATATYPE;
    }

}

class EmptyDataType extends ModelInstance<DataType,Sql> implements DataType {

    // attributes
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDom_IDdeprecated( UniqueId m_Dom_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDom_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDefaultValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDefaultValue( String m_DefaultValue ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public O_ATTRSet R114_is_defined_by_O_ATTR() {
        return (new O_ATTRSetImpl());
    }
    @Override
    public O_TFRSet R116_defines_the_type_of_return_code_O_TFR() {
        return (new O_TFRSetImpl());
    }
    @Override
    public OperationParameterSet R118_defines_the_type_of__OperationParameter() {
        return (new OperationParameterSetImpl());
    }
    @Override
    public SymbolicConstantSet R1500_defines_the_type_of_SymbolicConstant() {
        return (new SymbolicConstantSetImpl());
    }
    @Override
    public TerminatorServiceParameterSet R1653_TerminatorServiceParameter() {
        return (new TerminatorServiceParameterSetImpl());
    }
    @Override
    public TerminatorServiceSet R1656_TerminatorService() {
        return (new TerminatorServiceSetImpl());
    }
    @Override
    public CoreDataType R17_is_a_CoreDataType() {
        return CoreDataTypeImpl.EMPTY_COREDATATYPE;
    }
    @Override
    public EnumerationDataType R17_is_a_EnumerationDataType() {
        return EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
    }
    @Override
    public InstanceReferenceDataType R17_is_a_InstanceReferenceDataType() {
        return InstanceReferenceDataTypeImpl.EMPTY_INSTANCEREFERENCEDATATYPE;
    }
    @Override
    public StructuredDataType R17_is_a_StructuredDataType() {
        return StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
    }
    @Override
    public UserDataType R17_is_a_UserDataType() {
        return UserDataTypeImpl.EMPTY_USERDATATYPE;
    }
    @Override
    public UserDataTypeSet R18_defines_domain_of_UserDataType() {
        return (new UserDataTypeSetImpl());
    }
    @Override
    public BridgeSet R20_defines_the_return_value_Bridge() {
        return (new BridgeSetImpl());
    }
    @Override
    public BridgeParameterSet R22_defines_the_type_of_BridgeParameter() {
        return (new BridgeParameterSetImpl());
    }
    @Override
    public S_SYNCSet R25_defines_return_type_S_SYNC() {
        return (new S_SYNCSetImpl());
    }
    @Override
    public FunctionParameterSet R26_describes_type_of_FunctionParameter() {
        return (new FunctionParameterSetImpl());
    }
    @Override
    public PropertyParameterSet R4007_Defines_the_type_PropertyParameter() {
        return (new PropertyParameterSetImpl());
    }
    @Override
    public InterfaceOperationSet R4008_defines_return_type_InterfaceOperation() {
        return (new InterfaceOperationSetImpl());
    }
    @Override
    public Type R423_is_basis_of_Type() {
        return TypeImpl.EMPTY_TYPE;
    }
    @Override
    public StructureMemberSet R45_defines_the_type_of_StructureMember() {
        return (new StructureMemberSetImpl());
    }
    @Override
    public StateMachineEventDataItemSet R524_defines_the_type_of_StateMachineEventDataItem() {
        return (new StateMachineEventDataItemSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public ValueSet R820_is_type_of_Value() {
        return (new ValueSetImpl());
    }
    @Override
    public TransientVarSet R821_is_type_of_TransientVar() {
        return (new TransientVarSetImpl());
    }
    @Override
    public V_VARSet R848_is_type_of_V_VAR() {
        return (new V_VARSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return DataTypeImpl.KEY_LETTERS;
    }

    @Override
    public DataType value() {
        return this;
    }
    
    @Override
    public DataType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public DataType oneWhere( IWhere<DataType> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return DataTypeImpl.EMPTY_DATATYPE;
    }

}
