package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.CoreDataType;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;


public class CoreDataTypeImpl extends ModelInstance<CoreDataType,Sql> implements CoreDataType {

    public static final String KEY_LETTERS = "S_CDT";
    public static final CoreDataType EMPTY_COREDATATYPE = new EmptyCoreDataType();

    private Sql context;

    // constructors
    private CoreDataTypeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        m_Core_Typ = 0;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    private CoreDataTypeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, int m_Core_Typ ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Core_Typ = m_Core_Typ;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    public static CoreDataType create( Sql context ) throws XtumlException {
        CoreDataType newCoreDataType = new CoreDataTypeImpl( context );
        if ( context.addInstance( newCoreDataType ) ) {
            newCoreDataType.getRunContext().addChange(new InstanceCreatedDelta(newCoreDataType, KEY_LETTERS));
            return newCoreDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CoreDataType create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID, int m_Core_Typ ) throws XtumlException {
        CoreDataType newCoreDataType = new CoreDataTypeImpl( context, instanceId, ref_DT_ID, m_Core_Typ );
        if ( context.addInstance( newCoreDataType ) ) {
            return newCoreDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        checkLiving();
        if ( ref_DT_ID.inequality( this.ref_DT_ID ) ) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
                return ref_DT_ID;
    }
    private int m_Core_Typ;
    @Override
    public int getCore_Typ() throws XtumlException {
        checkLiving();
                return m_Core_Typ;
    }
    @Override
    public void setCore_Typ( int m_Core_Typ ) throws XtumlException {
        checkLiving();
        if ( m_Core_Typ != this.m_Core_Typ ) {
            final int oldValue = this.m_Core_Typ;
            this.m_Core_Typ = m_Core_Typ;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Core_Typ", oldValue, this.m_Core_Typ));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private DataType R17_is_a_DataType_inst;
    @Override
    public void setR17_is_a_DataType( DataType inst ) {
        R17_is_a_DataType_inst = inst;
    }
    @Override
    public DataType R17_is_a_DataType() throws XtumlException {
        return R17_is_a_DataType_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CoreDataType value() {
        return this;
    }

    @Override
    public CoreDataType self() {
        return this;
    }

    @Override
    public CoreDataType oneWhere( IWhere<CoreDataType> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        if ( condition.evaluate( value() ) ) return value();
        else return EMPTY_COREDATATYPE;
    }

}

class EmptyCoreDataType extends ModelInstance<CoreDataType,Sql> implements CoreDataType {

    // attributes
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getCore_Typ() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setCore_Typ( int m_Core_Typ ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public DataType R17_is_a_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }


    @Override
    public String getKeyLetters() {
        return CoreDataTypeImpl.KEY_LETTERS;
    }

    @Override
    public CoreDataType value() {
        return this;
    }
    
    @Override
    public CoreDataType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CoreDataType oneWhere( IWhere<CoreDataType> condition ) throws XtumlException {
        if ( null == condition ) throw new XtumlException( "Null condition passed to selection." );
        return CoreDataTypeImpl.EMPTY_COREDATATYPE;
    }

}
